/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.coordinatedcommits;

import io.delta.storage.commit.CommitCoordinatorClient;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.delta.CatalogOwnedTableFeature$;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.delta.commands.CloneTableCommand;
import org.apache.spark.sql.delta.coordinatedcommits.CatalogOwnedCommitCoordinatorProvider$;
import org.apache.spark.sql.delta.coordinatedcommits.TableCommitCoordinatorClient;
import org.apache.spark.sql.delta.coordinatedcommits.UCCommitCoordinatorBuilder$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class CatalogOwnedTableUtils$ {
    public static final CatalogOwnedTableUtils$ MODULE$ = new CatalogOwnedTableUtils$();
    private static final Seq<DeltaConfig<? super Option<Object>>> ICT_TABLE_PROPERTY_CONFS = new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMPS_ENABLED(), (List)new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION(), (List)new .colon.colon(DeltaConfigs$.MODULE$.IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP(), (List)Nil$.MODULE$)));
    private static final Seq<String> ICT_TABLE_PROPERTY_KEYS = (Seq)MODULE$.ICT_TABLE_PROPERTY_CONFS().map((Function1 & Serializable)x$2 -> x$2.key());

    public Option<TableCommitCoordinatorClient> populateTableCommitCoordinatorFromCatalog(SparkSession spark, Option<CatalogTable> catalogTableOpt, Snapshot snapshot) {
        Option option;
        Object object = new Object();
        try {
            if (!snapshot.isCatalogOwned()) {
                return None$.MODULE$;
            }
            option = catalogTableOpt.map((Function1 & Serializable)catalogTable -> {
                CommitCoordinatorClient cc = (CommitCoordinatorClient)MODULE$.getCommitCoordinator(spark, catalogTable.identifier()).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(40).append("Couldn't locate commit coordinator for: ").append(catalogTable.identifier()).toString());
                });
                return new TableCommitCoordinatorClient(cc, snapshot.deltaLog().logPath(), snapshot.metadata().configuration(), snapshot.deltaLog().newDeltaHadoopConf(), snapshot.deltaLog().store());
            }).orElse((Function0 & Serializable)() -> {
                Object object = Utils$.MODULE$.isTesting() ? CatalogOwnedCommitCoordinatorProvider$.MODULE$.getBuilder("spark_catalog").flatMap((Function1 & Serializable)builder -> new Some((Object)builder.buildForCatalog(spark, "spark_catalog"))).map((Function1 & Serializable)cc -> {
                    throw new NonLocalReturnControl(object, (Object)new Some((Object)new TableCommitCoordinatorClient((CommitCoordinatorClient)cc, snapshot.deltaLog().logPath(), snapshot.metadata().configuration(), snapshot.deltaLog().newDeltaHadoopConf(), snapshot.deltaLog().store())));
                }) : BoxedUnit.UNIT;
                throw new IllegalStateException(new StringBuilder(60).append("Path based access is not supported for Catalog-Owned table: ").append(snapshot.path()).toString());
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Option<CommitCoordinatorClient> getCommitCoordinator(SparkSession spark, TableIdentifier identifier) {
        Option option;
        Seq seq = identifier.nameParts();
        if (seq != null && !(option = spark.sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
            return CatalogOwnedCommitCoordinatorProvider$.MODULE$.getBuilder(catalog.name()).map((Function1 & Serializable)x$1 -> x$1.buildForCatalog(spark, catalog.name())).orElse((Function0 & Serializable)() -> {
                String string = catalog.getClass().getName();
                String string2 = UCCommitCoordinatorBuilder$.MODULE$.UNITY_CATALOG_CONNECTOR_CLASS();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return new Some((Object)UCCommitCoordinatorBuilder$.MODULE$.buildForCatalog(spark, catalog.name()));
                }
                return None$.MODULE$;
            });
        }
        throw new IllegalStateException(new StringBuilder(31).append("Failed to resolve the catalog: ").append(identifier).toString());
    }

    public Option<String> getCatalogName(SparkSession spark, TableIdentifier identifier) {
        Option option;
        Seq seq = identifier.nameParts();
        if (seq != null && !(option = spark.sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
            String string = catalog.getClass().getName();
            String string2 = UCCommitCoordinatorBuilder$.MODULE$.UNITY_CATALOG_CONNECTOR_CLASS();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some((Object)"unity-catalog");
            }
            return new Some((Object)catalog.name());
        }
        return None$.MODULE$;
    }

    public Seq<DeltaConfig<? super Option<Object>>> ICT_TABLE_PROPERTY_CONFS() {
        return ICT_TABLE_PROPERTY_CONFS;
    }

    public Seq<String> ICT_TABLE_PROPERTY_KEYS() {
        return ICT_TABLE_PROPERTY_KEYS;
    }

    public void verifyNotContainsICTConfigurations(Seq<String> propKeys) {
        this.ICT_TABLE_PROPERTY_KEYS().foreach((Function1 & Serializable)key -> {
            CatalogOwnedTableUtils$.$anonfun$verifyNotContainsICTConfigurations$1(propKeys, key);
            return BoxedUnit.UNIT;
        });
    }

    public void validatePropertiesForAlterTableSetPropertiesDeltaCommand(Snapshot snapshot, Map<String, String> propertyOverrides) {
        if (snapshot.isCatalogOwned()) {
            this.verifyNotContainsICTConfigurations((Seq<String>)propertyOverrides.keys().toSeq());
            return;
        }
    }

    public void validatePropertiesForAlterTableUnsetPropertiesDeltaCommand(Snapshot snapshot, Seq<String> propKeysToUnset) {
        if (snapshot.isCatalogOwned()) {
            this.verifyNotContainsICTConfigurations(propKeysToUnset);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validatePropertiesForCreateDeltaTableCommand(SparkSession spark, boolean tableExists, Option<LogicalPlan> query, Map<String, String> catalogTableProperties) {
        block6: {
            var9_5 = query;
            if (var9_5 instanceof Some && (cmd = (LogicalPlan)(var10_6 = (Some)var9_5).value()) instanceof CloneTableCommand) {
                var12_8 = (CloneTableCommand)cmd;
                v0 = new Tuple2((Object)(tableExists != false ? "REPLACE with CLONE" : "CREATE with CLONE"), var12_8.tablePropertyOverrides());
            } else {
                v0 = var8_9 = new Tuple2((Object)(tableExists != false ? "REPLACE" : "CREATE"), catalogTableProperties);
            }
            if (var8_9 == null) {
                throw new MatchError((Object)var8_9);
            }
            command = (String)var8_9._1();
            propertyOverrides = (Map)var8_9._2();
            var7_12 = new Tuple2((Object)command, (Object)propertyOverrides);
            command = (String)var7_12._1();
            propertyOverrides = (Map)var7_12._2();
            if (!tableExists) break block6;
            v1 = command;
            var17_15 = "REPLACE with CLONE";
            if (!(v1 == null ? var17_15 != null : v1.equals(var17_15) == false)) ** GOTO lbl-1000
            v2 = command;
            var18_16 = "REPLACE";
            if (!(v2 != null ? v2.equals(var18_16) == false : var18_16 != null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            Predef$.MODULE$.assert(v3, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validatePropertiesForCreateDeltaTableCommand$1(java.lang.String ), ()Ljava/lang/String;)((String)command));
            this.validateUCTableIdNotPresent((Map<String, String>)propertyOverrides);
            if (TableFeatureProtocolUtils$.MODULE$.getSupportedFeaturesFromTableConfigs((Map<String, String>)propertyOverrides).contains((Object)CatalogOwnedTableFeature$.MODULE$)) {
                throw new IllegalStateException("Specifying Catalog-Owned in REPLACE TABLE command is not supported. Please use CREATE TABLE command to create a Catalog-Owned table.");
            }
            return;
        }
    }

    public Protocol filterOutCatalogOwnedTableFeature(Protocol protocol) {
        Option x$1 = CatalogOwnedTableUtils$.filterImpl$1(protocol.readerFeatures());
        Option x$2 = CatalogOwnedTableUtils$.filterImpl$1(protocol.writerFeatures());
        int x$3 = protocol.copy$default$1();
        int x$4 = protocol.copy$default$2();
        return protocol.copy(x$3, x$4, (Option<Set<String>>)x$1, (Option<Set<String>>)x$2);
    }

    public void validateUCTableIdNotPresent(Map<String, String> property) {
        if (property.contains((Object)"ucTableId")) {
            throw DeltaErrors$.MODULE$.cannotModifyTableProperty("ucTableId");
        }
    }

    public boolean defaultCatalogOwnedEnabled(SparkSession spark) {
        return spark.conf().getOption(TableFeatureProtocolUtils$.MODULE$.defaultPropertyKey(CatalogOwnedTableFeature$.MODULE$)).contains((Object)"supported");
    }

    public static final /* synthetic */ void $anonfun$verifyNotContainsICTConfigurations$1(Seq propKeys$1, String key) {
        if (propKeys$1.contains((Object)key)) {
            throw new DeltaIllegalArgumentException("DELTA_CANNOT_MODIFY_CATALOG_OWNED_DEPENDENCIES", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final /* synthetic */ String $anonfun$validatePropertiesForCreateDeltaTableCommand$1(String command$1) {
        return new StringBuilder(20).append("Unexpected command: ").append(command$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$filterOutCatalogOwnedTableFeature$2(String x$5) {
        String string = x$5;
        String string2 = CatalogOwnedTableFeature$.MODULE$.name();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final Option filterImpl$1(Option tableFeatures) {
        return tableFeatures.map((Function1 & Serializable)x$4 -> (Set)x$4.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CatalogOwnedTableUtils$.$anonfun$filterOutCatalogOwnedTableFeature$2(x$5))));
    }

    private CatalogOwnedTableUtils$() {
    }
}

