/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.coordinatedcommits;

import io.delta.storage.commit.Commit;
import io.delta.storage.commit.CommitFailedException;
import io.delta.storage.commit.GetCommitsResponse;
import io.delta.storage.commit.actions.AbstractMetadata;
import io.delta.storage.commit.actions.AbstractProtocol;
import io.delta.storage.commit.uccommitcoordinator.CommitLimitReachedException;
import io.delta.storage.commit.uccommitcoordinator.InvalidTargetTableException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.coordinatedcommits.InMemoryUCCommitCoordinator$PerTableData$UCCommit$;
import org.apache.spark.sql.delta.coordinatedcommits.UCCoordinatedCommitsRequestType$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001\u0002*T\u0001\u0001DQa\u001a\u0001\u0005\u0002!4Aa\u001b\u0001\u0005Y\"AQN\u0001BC\u0002\u0013\u0005a\u000e\u0003\u0005x\u0005\t\u0005\t\u0015!\u0003p\u0011\u00159'\u0001\"\u0001y\r\u0011a(\u0001R?\t\u0015\u0005maA!f\u0001\n\u0003\ti\u0002\u0003\u0006\u00024\u0019\u0011\t\u0012)A\u0005\u0003?A!\"!\u000e\u0007\u0005+\u0007I\u0011AA\u001c\u0011)\tyD\u0002B\tB\u0003%\u0011\u0011\b\u0005\u000b\u0003\u00032!Q3A\u0005\u0002\u0005]\u0002BCA\"\r\tE\t\u0015!\u0003\u0002:!1qM\u0002C\u0001\u0003\u000bB\u0011\"!\u0015\u0007\u0005\u0004%\t!a\u0015\t\u0011\u0005mc\u0001)A\u0005\u0003+B\u0011\"!\u0018\u0007\u0003\u0003%\t!a\u0018\t\u0013\u0005\u001dd!%A\u0005\u0002\u0005%\u0004\"CA@\rE\u0005I\u0011AAA\u0011%\t)IBI\u0001\n\u0003\t\t\tC\u0005\u0002\b\u001a\t\t\u0011\"\u0011\u0002\n\"I\u0011q\u0013\u0004\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003C3\u0011\u0011!C\u0001\u0003GC\u0011\"a,\u0007\u0003\u0003%\t%!-\t\u0013\u0005}f!!A\u0005\u0002\u0005\u0005\u0007\"CAc\r\u0005\u0005I\u0011IAd\u0011%\tYMBA\u0001\n\u0003\ni\rC\u0005\u0002P\u001a\t\t\u0011\"\u0011\u0002R\"I\u00111\u001b\u0004\u0002\u0002\u0013\u0005\u0013Q[\u0004\n\u00033\u0014\u0011\u0011!E\u0005\u000374\u0001\u0002 \u0002\u0002\u0002#%\u0011Q\u001c\u0005\u0007Oz!\t!a=\t\u0013\u0005=g$!A\u0005F\u0005E\u0007\"CA{=\u0005\u0005I\u0011QA|\u0011%\tyPHI\u0001\n\u0003\t\t\tC\u0005\u0003\u0002y\t\t\u0011\"!\u0003\u0004!I!Q\u0003\u0010\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0005/\u0011!\u0019!C\u0005\u00053A\u0001Ba\n\u0003A\u0003%!1\u0004\u0005\n\u0005S\u0011!\u0019!C\u0001\u0005WA\u0001B!\u0011\u0003A\u0003%!Q\u0006\u0005\b\u0005\u0007\u0012A\u0011AA*\u0011\u001d\u0011)E\u0001C\u0001\u0003oAqAa\u0012\u0003\t\u0003\t9\u0004C\u0004\u0003J\t!\tAa\u0013\t\u000f\t]#\u0001\"\u0001\u0003Z!9!Q\f\u0002\u0005\u0002\t}\u0003b\u0002B1\u0005\u0011\u0005!1\r\u0005\n\u0005k\u0002\u0001\u0019!C\u0001\u0003oA\u0011Ba\u001e\u0001\u0001\u0004%\tA!\u001f\t\u0011\tu\u0004\u0001)Q\u0005\u0003sA\u0011Ba \u0001\u0001\u0004%\t!a\u000e\t\u0013\t\u0005\u0005\u00011A\u0005\u0002\t\r\u0005\u0002\u0003BD\u0001\u0001\u0006K!!\u000f\t\u0013\t%\u0005A1A\u0005\n\u0005e\u0005\u0002\u0003BF\u0001\u0001\u0006I!a'\t\u0013\t5\u0005A1A\u0005\n\t=\u0005\u0002\u0003BQ\u0001\u0001\u0006IA!%\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"I!Q\u001a\u0001\u0012\u0002\u0013%!q\u001a\u0005\b\u0005'\u0004A\u0011\u0002Bk\u0011\u001d\u0011\t\u0010\u0001C\u0005\u0005gD\u0011b!\u000b\u0001#\u0003%Iaa\u000b\t\u0013\r=\u0002!%A\u0005\n\rE\u0002\"CB\u001b\u0001E\u0005I\u0011BB\u0019\u0011%\u00199\u0004AI\u0001\n\u0013\u0019\t\u0004C\u0005\u0004:\u0001\t\n\u0011\"\u0003\u00042!I11\b\u0001\u0012\u0002\u0013%1\u0011\u0007\u0005\n\u0007{\u0001\u0011\u0013!C\u0005\u0003\u0003Cqaa\u0010\u0001\t\u0013\u0019\t\u0005C\u0005\u0004H\u0001\t\n\u0011\"\u0003\u00042!91\u0011\n\u0001\u0005\u0002\r-\u0003\"CB?\u0001E\u0005I\u0011AB\u0016\u0011%\u0019y\bAI\u0001\n\u0003\u0019\t\u0004C\u0005\u0004\u0002\u0002\t\n\u0011\"\u0001\u00042!I11\u0011\u0001\u0012\u0002\u0013\u00051\u0011\u0007\u0005\n\u0007\u000b\u0003\u0011\u0013!C\u0001\u0007cA\u0011ba\"\u0001#\u0003%\ta!\r\t\u0013\r%\u0005!%A\u0005\u0002\u0005\u0005\u0005\"CBF\u0001E\u0005I\u0011ABG\u0011%\u0019\t\nAI\u0001\n\u0003\u0019\u0019\nC\u0004\u0004\u0018\u0002!\ta!'\u00037%sW*Z7pef,6iQ8n[&$8i\\8sI&t\u0017\r^8s\u0015\t!V+\u0001\nd_>\u0014H-\u001b8bi\u0016$7m\\7nSR\u001c(B\u0001,X\u0003\u0015!W\r\u001c;b\u0015\tA\u0016,A\u0002tc2T!AW.\u0002\u000bM\u0004\u0018M]6\u000b\u0005qk\u0016AB1qC\u000eDWMC\u0001_\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0004\"A\u001b\u0001\u000e\u0003M\u0013A\u0002U3s)\u0006\u0014G.\u001a#bi\u0006\u001c\"AA1\u0002\tA\fG\u000f[\u000b\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0004]\u0016$(\"\u0001;\u0002\t)\fg/Y\u0005\u0003mF\u00141!\u0016*J\u0003\u0015\u0001\u0018\r\u001e5!)\tI8\u0010\u0005\u0002{\u00055\t\u0001\u0001C\u0003n\u000b\u0001\u0007qN\u0001\u0005V\u0007\u000e{W.\\5u'\u00151\u0011M`A\u0002!\t\u0011w0C\u0002\u0002\u0002\r\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0006\u0005Ua\u0002BA\u0004\u0003#qA!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001by\u0016A\u0002\u001fs_>$h(C\u0001e\u0013\r\t\u0019bY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9\"!\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005M1-\u0001\u0004d_6l\u0017\u000e^\u000b\u0003\u0003?\u0001B!!\t\u000205\u0011\u00111\u0005\u0006\u0005\u00037\t)C\u0003\u0003\u0002(\u0005%\u0012aB:u_J\fw-\u001a\u0006\u0004-\u0006-\"BAA\u0017\u0003\tIw.\u0003\u0003\u00022\u0005\r\"AB\"p[6LG/A\u0004d_6l\u0017\u000e\u001e\u0011\u0002\u001d%\u001cH)[:po:\u001cu.\\7jiV\u0011\u0011\u0011\b\t\u0004E\u0006m\u0012bAA\u001fG\n9!i\\8mK\u0006t\u0017aD5t\t&\u001cxn\u001e8D_6l\u0017\u000e\u001e\u0011\u0002\u0019%\u001c()Y2lM&dG.\u001a3\u0002\u001b%\u001c()Y2lM&dG.\u001a3!)!\t9%a\u0013\u0002N\u0005=\u0003cAA%\r5\t!\u0001C\u0004\u0002\u001c5\u0001\r!a\b\t\u000f\u0005UR\u00021\u0001\u0002:!I\u0011\u0011I\u0007\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\bm\u0016\u00148/[8o+\t\t)\u0006E\u0002c\u0003/J1!!\u0017d\u0005\u0011auN\\4\u0002\u0011Y,'o]5p]\u0002\nAaY8qsRA\u0011qIA1\u0003G\n)\u0007C\u0005\u0002\u001cA\u0001\n\u00111\u0001\u0002 !I\u0011Q\u0007\t\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0003\u0003\u0002\u0002\u0013!a\u0001\u0003s\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\"\u0011qDA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=G\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007SC!!\u000f\u0002n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\fB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012N\fA\u0001\\1oO&!\u0011QSAH\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0014\t\u0004E\u0006u\u0015bAAPG\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QUAV!\r\u0011\u0017qU\u0005\u0004\u0003S\u001b'aA!os\"I\u0011Q\u0016\f\u0002\u0002\u0003\u0007\u00111T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0006CBA[\u0003w\u000b)+\u0004\u0002\u00028*\u0019\u0011\u0011X2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0006]&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u000f\u0002D\"I\u0011Q\u0016\r\u0002\u0002\u0003\u0007\u0011QU\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\f\u0006%\u0007\"CAW3\u0005\u0005\t\u0019AAN\u0003!A\u0017m\u001d5D_\u0012,GCAAN\u0003!!xn\u0015;sS:<GCAAF\u0003\u0019)\u0017/^1mgR!\u0011\u0011HAl\u0011%\ti\u000bHA\u0001\u0002\u0004\t)+\u0001\u0005V\u0007\u000e{W.\\5u!\r\tIEH\n\u0006=\u0005}\u00171\u001e\t\r\u0003C\f9/a\b\u0002:\u0005e\u0012qI\u0007\u0003\u0003GT1!!:d\u0003\u001d\u0011XO\u001c;j[\u0016LA!!;\u0002d\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u00055\u0018\u0011_\u0007\u0003\u0003_T1!!\ft\u0013\u0011\t9\"a<\u0015\u0005\u0005m\u0017!B1qa2LH\u0003CA$\u0003s\fY0!@\t\u000f\u0005m\u0011\u00051\u0001\u0002 !9\u0011QG\u0011A\u0002\u0005e\u0002\"CA!CA\u0005\t\u0019AA\u001d\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u0011\t\u0002E\u0003c\u0005\u000f\u0011Y!C\u0002\u0003\n\r\u0014aa\u00149uS>t\u0007#\u00032\u0003\u000e\u0005}\u0011\u0011HA\u001d\u0013\r\u0011ya\u0019\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tM1%!AA\u0002\u0005\u001d\u0013a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n\u0011\"^2D_6l\u0017\u000e^:\u0016\u0005\tm\u0001C\u0002B\u000f\u0005G\t9%\u0004\u0002\u0003 )!!\u0011EA\\\u0003\u001diW\u000f^1cY\u0016LAA!\n\u0003 \tY\u0011I\u001d:bs\n+hMZ3s\u0003))8mQ8n[&$8\u000fI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003.A!!q\u0006B\u001f\u001b\t\u0011\tD\u0003\u0003\u00034\tU\u0012!\u00027pG.\u001c(\u0002\u0002B\u001c\u0005s\t!bY8oGV\u0014(/\u001a8u\u0015\r\u0011Yd]\u0001\u0005kRLG.\u0003\u0003\u0003@\tE\"A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002\u000b1|7m\u001b\u0011\u000231\f7\u000f\u001e*bi&4\u0017.\u001a3D_6l\u0017\u000e\u001e,feNLwN\\\u0001\tSN\f5\r^5wK\u0006Q\u0011n\u001d#jg><h.\u001a3\u0002\u0019\u0005\u0004\b/\u001a8e\u0007>lW.\u001b;\u0015\r\t5#1\u000bB+!\r\u0011'qJ\u0005\u0004\u0005#\u001a'\u0001B+oSRDq!a\u0007-\u0001\u0004\ty\u0002C\u0004\u000261\u0002\r!!\u000f\u00023I,Wn\u001c<f\u0007>lW.\u001b;t+:$\u0018\u000e\u001c,feNLwN\u001c\u000b\u0005\u0005\u001b\u0012Y\u0006C\u0004\u0002R5\u0002\r!!\u0016\u000215\f'o\u001b'bgR\u001cu.\\7ji\n\u000b7m\u001b4jY2,G\r\u0006\u0002\u0003N\u0005Qq-\u001a;D_6l\u0017\u000e^:\u0015\r\t\u0015$1\u000eB9!\u0019\t)Aa\u001a\u0002 %!!\u0011NA\r\u0005\r\u0019V-\u001d\u0005\b\u0005[z\u0003\u0019\u0001B8\u00031\u0019H/\u0019:u-\u0016\u00148/[8o!\u0015\u0011'qAA+\u0011\u001d\u0011\u0019h\fa\u0001\u0005_\n!\"\u001a8e-\u0016\u00148/[8o\u0003m!\bN]8x\u0013>+\u0005pY3qi&|g.\u00114uKJ\u001cu.\\7ji\u0006yB\u000f\u001b:po&{U\t_2faRLwN\\!gi\u0016\u00148i\\7nSR|F%Z9\u0015\t\t5#1\u0010\u0005\n\u0003[\u000b\u0014\u0011!a\u0001\u0003s\tA\u0004\u001e5s_^Lu*\u0012=dKB$\u0018n\u001c8BMR,'oQ8n[&$\b%\u0001\u000fuQJ|w/S(Fq\u000e,\u0007\u000f^5p]\n+gm\u001c:f\u0007>lW.\u001b;\u0002AQD'o\\<J\u001f\u0016C8-\u001a9uS>t')\u001a4pe\u0016\u001cu.\\7ji~#S-\u001d\u000b\u0005\u0005\u001b\u0012)\tC\u0005\u0002.R\n\t\u00111\u0001\u0002:\u0005iB\u000f\u001b:po&{U\t_2faRLwN\u001c\"fM>\u0014XmQ8n[&$\b%A\bN\u0003b{f*V'`\u0007>kU*\u0013+T\u0003Ai\u0015\tW0O+6{6iT'N\u0013R\u001b\u0006%A\u0006qKJ$\u0016M\u00197f\u001b\u0006\u0004XC\u0001BI!\u001d\u0011\u0019J!&\u0003\u001afl!A!\u000e\n\t\t]%Q\u0007\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003\u0002BN\u0005;k!A!\u000f\n\t\t}%\u0011\b\u0002\u0005+VKE)\u0001\u0007qKJ$\u0016M\u00197f\u001b\u0006\u0004\b%\u0001\u0005xSRDGj\\2l+\u0011\u00119Ka,\u0015\r\t%&Q\u0019Be)\u0011\u0011YKa/\u0011\t\t5&q\u0016\u0007\u0001\t\u001d\u0011\tL\u000fb\u0001\u0005g\u0013\u0011\u0001V\t\u0005\u0005k\u000b)\u000bE\u0002c\u0005oK1A!/d\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001B!0;\t\u0003\u0007!qX\u0001\n_B,'/\u0019;j_:\u0004RA\u0019Ba\u0005WK1Aa1d\u0005!a$-\u001f8b[\u0016t\u0004b\u0002Bdu\u0001\u0007!\u0011T\u0001\ni\u0006\u0014G.Z+V\u0013\u0012C\u0011Ba3;!\u0003\u0005\r!!\u000f\u0002\u0013]\u0014\u0018\u000e^3M_\u000e\\\u0017AE<ji\"dunY6%I\u00164\u0017-\u001e7uII*B!!!\u0003R\u00129!\u0011W\u001eC\u0002\tM\u0016\u0001\u0005<bY&$\u0017\r^3UC\ndW-\u0016*J)!\u0011iEa6\u0003\\\n}\u0007B\u0002Bmy\u0001\u0007q.\u0001\u0005te\u000e$\u0016M\u00197f\u0011\u0019\u0011i\u000e\u0010a\u0001_\u0006YA/\u0019:hKR$\u0016M\u00197f\u0011\u001d\u0011\t\u000f\u0010a\u0001\u0005G\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003f\n-hb\u00016\u0003h&\u0019!\u0011^*\u0002?U\u001b5i\\8sI&t\u0017\r^3e\u0007>lW.\u001b;t%\u0016\fX/Z:u)f\u0004X-\u0003\u0003\u0003n\n=(aH+D\u0007>|'\u000fZ5oCR,GmQ8n[&$8OU3rk\u0016\u001cH\u000fV=qK*\u0019!\u0011^*\u0002%\u001d,GOV1mS\u0012\fG/\u001a3D_6l\u0017\u000e\u001e\u000b\u0015\u0005k\u00149p!\u0003\u0004\u000e\rM1qCB\u000e\u0007?\u0019\u0019ca\n\u0011\u000b\t\u00149!a\b\t\u000f\teX\b1\u0001\u0003|\u00069A/\u00192mK&#\u0007\u0003\u0002B\u007f\u0007\u000bqAAa@\u0004\u0002A\u0019\u0011\u0011B2\n\u0007\r\r1-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\u001b9AC\u0002\u0004\u0004\rDaaa\u0003>\u0001\u0004y\u0017\u0001\u0003;bE2,WK]5\t\u0013\r=Q\b%AA\u0002\rE\u0011AD2p[6LGOR5mK:\u000bW.\u001a\t\u0006E\n\u001d!1 \u0005\n\u0007+i\u0004\u0013!a\u0001\u0005_\nQbY8n[&$h+\u001a:tS>t\u0007\"CB\r{A\u0005\t\u0019\u0001B8\u00039\u0019w.\\7ji\u001aKG.Z*ju\u0016D\u0011b!\b>!\u0003\u0005\rAa\u001c\u0002#\r|W.\\5u\r&dW-T8e)&lW\rC\u0005\u0004\"u\u0002\n\u00111\u0001\u0003p\u0005y1m\\7nSR$\u0016.\\3ti\u0006l\u0007\u000fC\u0005\u0004&u\u0002\n\u00111\u0001\u0003p\u0005QB.Y:u\u0017:|wO\u001c\"bG.4\u0017\u000e\u001c7fIZ+'o]5p]\"I\u0011QG\u001f\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u001dO\u0016$h+\u00197jI\u0006$X\rZ\"p[6LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iC\u000b\u0003\u0004\u0012\u00055\u0014\u0001H4fiZ\u000bG.\u001b3bi\u0016$7i\\7nSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007gQCAa\u001c\u0002n\u0005ar-\u001a;WC2LG-\u0019;fI\u000e{W.\\5uI\u0011,g-Y;mi\u0012*\u0014\u0001H4fiZ\u000bG.\u001b3bi\u0016$7i\\7nSR$C-\u001a4bk2$HEN\u0001\u001dO\u0016$h+\u00197jI\u0006$X\rZ\"p[6LG\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003q9W\r\u001e,bY&$\u0017\r^3e\u0007>lW.\u001b;%I\u00164\u0017-\u001e7uIa\nAdZ3u-\u0006d\u0017\u000eZ1uK\u0012\u001cu.\\7ji\u0012\"WMZ1vYR$\u0013(\u0001\u0015cC\u000e\\g-\u001b7m\u0003\u001a$XM]\"p[6LG\u000fV8D_>\u0014H-\u001b8bi>\u0014\u0018J\u001c;fe:\fG\u000e\u0006\u0004\u0003N\r\r3Q\t\u0005\b\u0005s,\u0005\u0019\u0001B~\u0011%\u0019)#\u0012I\u0001\u0002\u0004\u0011y'\u0001\u001acC\u000e\\g-\u001b7m\u0003\u001a$XM]\"p[6LG\u000fV8D_>\u0014H-\u001b8bi>\u0014\u0018J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003M\u0019w.\\7jiR{7i\\8sI&t\u0017\r^8s)a\u0011ie!\u0014\u0004P\rE31KB+\u0007/\u001aIfa\u0017\u0004^\r}3\u0011\u000f\u0005\b\u0005s<\u0005\u0019\u0001B~\u0011\u0019\u0019Ya\u0012a\u0001_\"I1qB$\u0011\u0002\u0003\u00071\u0011\u0003\u0005\n\u0007+9\u0005\u0013!a\u0001\u0005_B\u0011b!\u0007H!\u0003\u0005\rAa\u001c\t\u0013\ruq\t%AA\u0002\t=\u0004\"CB\u0011\u000fB\u0005\t\u0019\u0001B8\u0011%\u0019)c\u0012I\u0001\u0002\u0004\u0011y\u0007C\u0005\u00026\u001d\u0003\n\u00111\u0001\u0002:!I1\u0011M$\u0011\u0002\u0003\u000711M\u0001\faJ|Go\\2pY>\u0003H\u000fE\u0003c\u0005\u000f\u0019)\u0007\u0005\u0003\u0004h\r5TBAB5\u0015\u0011\u0019Y'a\t\u0002\u000f\u0005\u001cG/[8og&!1qNB5\u0005A\t%m\u001d;sC\u000e$\bK]8u_\u000e|G\u000eC\u0005\u0004t\u001d\u0003\n\u00111\u0001\u0004v\u0005YQ.\u001a;bI\u0006$\u0018m\u00149u!\u0015\u0011'qAB<!\u0011\u00199g!\u001f\n\t\rm4\u0011\u000e\u0002\u0011\u0003\n\u001cHO]1di6+G/\u00193bi\u0006\fQdY8n[&$Hk\\\"p_J$\u0017N\\1u_J$C-\u001a4bk2$HeM\u0001\u001eG>lW.\u001b;U_\u000e{wN\u001d3j]\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005i2m\\7nSR$vnQ8pe\u0012Lg.\u0019;pe\u0012\"WMZ1vYR$S'A\u000fd_6l\u0017\u000e\u001e+p\u0007>|'\u000fZ5oCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003u\u0019w.\\7jiR{7i\\8sI&t\u0017\r^8sI\u0011,g-Y;mi\u0012:\u0014!H2p[6LG\u000fV8D_>\u0014H-\u001b8bi>\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0002;\r|W.\\5u)>\u001cun\u001c:eS:\fGo\u001c:%I\u00164\u0017-\u001e7uIe\nadY8n[&$Hk\\\"p_J$\u0017N\\1u_J$C-\u001a4bk2$H%\r\u0019\u0016\u0005\r=%\u0006BB2\u0003[\nadY8n[&$Hk\\\"p_J$\u0017N\\1u_J$C-\u001a4bk2$H%M\u0019\u0016\u0005\rU%\u0006BB;\u0003[\n\u0011dZ3u\u0007>lW.\u001b;t\rJ|WnQ8pe\u0012Lg.\u0019;peRQ11TBQ\u0007G\u001b)ka*\u0011\t\u0005\u00052QT\u0005\u0005\u0007?\u000b\u0019C\u0001\nHKR\u001cu.\\7jiN\u0014Vm\u001d9p]N,\u0007b\u0002B}#\u0002\u0007!1 \u0005\u0007\u0007\u0017\t\u0006\u0019A8\t\u000f\t5\u0014\u000b1\u0001\u0003p!9!1O)A\u0002\t=\u0004")
public class InMemoryUCCommitCoordinator {
    private boolean throwIOExceptionAfterCommit = false;
    private boolean throwIOExceptionBeforeCommit = false;
    private final int MAX_NUM_COMMITS;
    private final ConcurrentHashMap<UUID, PerTableData> perTableMap = new ConcurrentHashMap();

    public boolean throwIOExceptionAfterCommit() {
        return this.throwIOExceptionAfterCommit;
    }

    public void throwIOExceptionAfterCommit_$eq(boolean x$1) {
        this.throwIOExceptionAfterCommit = x$1;
    }

    public boolean throwIOExceptionBeforeCommit() {
        return this.throwIOExceptionBeforeCommit;
    }

    public void throwIOExceptionBeforeCommit_$eq(boolean x$1) {
        this.throwIOExceptionBeforeCommit = x$1;
    }

    private int MAX_NUM_COMMITS() {
        return this.MAX_NUM_COMMITS;
    }

    private ConcurrentHashMap<UUID, PerTableData> perTableMap() {
        return this.perTableMap;
    }

    private <T> T withLock(UUID tableUUID, boolean writeLock, Function0<T> operation) {
        Object object;
        PerTableData tableData = (PerTableData)Option$.MODULE$.apply((Object)this.perTableMap().get(tableUUID)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append("Unknown table ").append(tableUUID).append(".").toString());
        });
        Lock lock = writeLock ? tableData.lock().writeLock() : tableData.lock().readLock();
        lock.lock();
        try {
            object = operation.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    private <T> boolean withLock$default$2() {
        return false;
    }

    private void validateTableURI(URI srcTable, URI targetTable, Enumeration.Value request) {
        URI uRI = srcTable;
        URI uRI2 = targetTable;
        if (uRI == null ? uRI2 != null : !((Object)uRI).equals(uRI2)) {
            String errorMsg = new StringBuilder(48).append("Source table ").append(srcTable).append(" and targetTable ").append(targetTable).append(" do not match for ").append(request).toString();
            throw new InvalidTargetTableException(errorMsg);
        }
    }

    private Option<Commit> getValidatedCommit(String tableId, URI tableUri, Option<String> commitFileName, Option<Object> commitVersion, Option<Object> commitFileSize, Option<Object> commitFileModTime, Option<Object> commitTimestamp, Option<Object> lastKnownBackfilledVersion, boolean isDisownCommit) {
        UUID tableUUID = UUID.fromString(tableId);
        URI path = tableUri;
        PerTableData tableData = this.perTableMap().get(tableUUID);
        lastKnownBackfilledVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)backfilledUntil -> {
            long maxBackfillVersion = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)commitVersion.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))), tableData.lastRatifiedCommitVersion());
            if (backfilledUntil > maxBackfillVersion) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unexpected backfill version: ").append(backfilledUntil).append(". ").append("Max backfill version: ").append(maxBackfillVersion).toString());
            }
        });
        return commitFileName.map((Function1 & Serializable)fileName -> {
            Predef$.MODULE$.require(commitVersion.nonEmpty());
            Predef$.MODULE$.require(commitFileSize.nonEmpty());
            Predef$.MODULE$.require(commitFileModTime.nonEmpty());
            Predef$.MODULE$.require(commitTimestamp.nonEmpty());
            this.validateTableURI(path, tableUri, UCCoordinatedCommitsRequestType$.MODULE$.COMMIT());
            String tableIdStr = tableUUID.toString();
            int currentNumCommits = this.getCommitsFromCoordinator(tableIdStr, tableUri, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$).getCommits().size();
            if (currentNumCommits == this.MAX_NUM_COMMITS()) {
                String errorMsg = new StringBuilder(67).append("Too many unbackfilled commits for ").append(tableIdStr).append(". Cannot ").append("store more than ").append(this.MAX_NUM_COMMITS()).append(" commits").toString();
                throw new CommitLimitReachedException(errorMsg);
            }
            if (this.throwIOExceptionBeforeCommit()) {
                this.throwIOExceptionBeforeCommit_$eq(false);
                throw new IOException("Problem before comitting");
            }
            Path basePath = FileNames$.MODULE$.commitDirPath(DeltaTableUtils$.MODULE$.safeConcatPaths(new Path(tableUri), "_delta_log"));
            Path commitFilePath = new Path(basePath, fileName);
            FileStatus fileStatus = new FileStatus(BoxesRunTime.unboxToLong((Object)commitFileSize.get()), false, 0, 0L, BoxesRunTime.unboxToLong((Object)commitFileModTime.get()), commitFilePath);
            if (tableData.isActive()) {
                long expectedVersion = tableData.lastRatifiedCommitVersion() + 1L;
                if (BoxesRunTime.unboxToLong((Object)commitVersion.get()) != expectedVersion) {
                    throw new CommitFailedException(BoxesRunTime.unboxToLong((Object)commitVersion.get()) < expectedVersion, BoxesRunTime.unboxToLong((Object)commitVersion.get()) < expectedVersion, new StringBuilder(49).append("Commit version ").append(commitVersion.get()).append(" is not valid. ").append("Expected version: ").append(expectedVersion).append(".").toString());
                }
            }
            return new Commit(BoxesRunTime.unboxToLong((Object)commitVersion.get()), fileStatus, BoxesRunTime.unboxToLong((Object)commitTimestamp.get()));
        });
    }

    private Option<String> getValidatedCommit$default$3() {
        return None$.MODULE$;
    }

    private Option<Object> getValidatedCommit$default$4() {
        return None$.MODULE$;
    }

    private Option<Object> getValidatedCommit$default$5() {
        return None$.MODULE$;
    }

    private Option<Object> getValidatedCommit$default$6() {
        return None$.MODULE$;
    }

    private Option<Object> getValidatedCommit$default$7() {
        return None$.MODULE$;
    }

    private Option<Object> getValidatedCommit$default$8() {
        return None$.MODULE$;
    }

    private boolean getValidatedCommit$default$9() {
        return false;
    }

    private void backfillAfterCommitToCoordinatorInternal(String tableId, Option<Object> lastKnownBackfilledVersion) {
        UUID tableUUID = UUID.fromString(tableId);
        lastKnownBackfilledVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)backfilledUntil -> {
            long l;
            PerTableData tableData = this.perTableMap().get(tableUUID);
            if (backfilledUntil == tableData.lastRatifiedCommitVersion()) {
                tableData.markLastCommitBackfilled();
                l = backfilledUntil - 1L;
            } else {
                l = backfilledUntil;
            }
            long maxVersionToRemove = l;
            tableData.removeCommitsUntilVersion(maxVersionToRemove);
        });
    }

    private Option<Object> backfillAfterCommitToCoordinatorInternal$default$2() {
        return None$.MODULE$;
    }

    public void commitToCoordinator(String tableId, URI tableUri, Option<String> commitFileName, Option<Object> commitVersion, Option<Object> commitFileSize, Option<Object> commitFileModTime, Option<Object> commitTimestamp, Option<Object> lastKnownBackfilledVersion, boolean isDisownCommit, Option<AbstractProtocol> protocolOpt, Option<AbstractMetadata> metadataOpt) {
        Object object;
        Predef$.MODULE$.require(commitFileName.nonEmpty() || lastKnownBackfilledVersion.nonEmpty());
        if (commitVersion.nonEmpty()) {
            UUID tableUuid = UUID.fromString(tableId);
            object = this.perTableMap().putIfAbsent(tableUuid, new PerTableData(this, tableUri));
        } else {
            object = BoxedUnit.UNIT;
        }
        this.withLock(UUID.fromString(tableId), true, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<Commit> commitToAppendOpt = this.getValidatedCommit(tableId, tableUri, commitFileName, commitVersion, commitFileSize, commitFileModTime, commitTimestamp, lastKnownBackfilledVersion, isDisownCommit);
            commitToAppendOpt.foreach((Function1 & Serializable)commitToAppend -> {
                InMemoryUCCommitCoordinator.$anonfun$commitToCoordinator$2(this, tableId, isDisownCommit, commitToAppend);
                return BoxedUnit.UNIT;
            });
            if (this.throwIOExceptionAfterCommit()) {
                this.throwIOExceptionAfterCommit_$eq(false);
                throw new IOException("Problem after comitting");
            }
            this.backfillAfterCommitToCoordinatorInternal(tableId, lastKnownBackfilledVersion);
        });
    }

    public Option<String> commitToCoordinator$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> commitToCoordinator$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> commitToCoordinator$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> commitToCoordinator$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> commitToCoordinator$default$7() {
        return None$.MODULE$;
    }

    public Option<Object> commitToCoordinator$default$8() {
        return None$.MODULE$;
    }

    public boolean commitToCoordinator$default$9() {
        return false;
    }

    public Option<AbstractProtocol> commitToCoordinator$default$10() {
        return None$.MODULE$;
    }

    public Option<AbstractMetadata> commitToCoordinator$default$11() {
        return None$.MODULE$;
    }

    public GetCommitsResponse getCommitsFromCoordinator(String tableId, URI tableUri, Option<Object> startVersion, Option<Object> endVersion) {
        GetCommitsResponse getCommitsResponse;
        Object object = new Object();
        try {
            UUID tableUUID = UUID.fromString(tableId);
            URI path = (URI)Option$.MODULE$.apply((Object)this.perTableMap().get(tableUUID)).map((Function1 & Serializable)x$7 -> x$7.path()).getOrElse((Function0 & Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)new GetCommitsResponse((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().empty()).asJava(), -1L));
            });
            this.validateTableURI(path, tableUri, UCCoordinatedCommitsRequestType$.MODULE$.GET_COMMITS());
            getCommitsResponse = (GetCommitsResponse)this.withLock(tableUUID, this.withLock$default$2(), (Function0 & Serializable)() -> {
                PerTableData tableData = this.perTableMap().get(tableUUID);
                scala.collection.immutable.Seq<Commit> commits = tableData.getCommits(startVersion, endVersion);
                return new GetCommitsResponse((List)JavaConverters$.MODULE$.seqAsJavaListConverter(commits).asJava(), tableData.lastRatifiedCommitVersion());
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                getCommitsResponse = (GetCommitsResponse)ex.value();
            }
            throw ex;
        }
        return getCommitsResponse;
    }

    public static final /* synthetic */ void $anonfun$commitToCoordinator$2(InMemoryUCCommitCoordinator $this, String tableId$1, boolean isDisownCommit$1, Commit commitToAppend) {
        PerTableData tableData = $this.perTableMap().get(UUID.fromString(tableId$1));
        tableData.appendCommit(commitToAppend, isDisownCommit$1);
    }

    public InMemoryUCCommitCoordinator() {
        this.MAX_NUM_COMMITS = 10;
    }

    private class PerTableData {
        private volatile InMemoryUCCommitCoordinator$PerTableData$UCCommit$ UCCommit$module;
        private final URI path;
        private final ArrayBuffer<UCCommit> ucCommits;
        private final ReentrantReadWriteLock lock;
        public final /* synthetic */ InMemoryUCCommitCoordinator $outer;

        private InMemoryUCCommitCoordinator$PerTableData$UCCommit$ UCCommit() {
            if (this.UCCommit$module == null) {
                this.UCCommit$lzycompute$1();
            }
            return this.UCCommit$module;
        }

        public URI path() {
            return this.path;
        }

        private ArrayBuffer<UCCommit> ucCommits() {
            return this.ucCommits;
        }

        public ReentrantReadWriteLock lock() {
            return this.lock;
        }

        public long lastRatifiedCommitVersion() {
            return BoxesRunTime.unboxToLong((Object)this.ucCommits().lastOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        }

        public boolean isActive() {
            return this.ucCommits().lastOption().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PerTableData.$anonfun$isActive$1(x$2)));
        }

        public boolean isDisowned() {
            return this.ucCommits().lastOption().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDisownCommit()));
        }

        public void appendCommit(Commit commit, boolean isDisownCommit) {
            this.ucCommits().$plus$eq((Object)new UCCommit(this, commit, isDisownCommit, this.UCCommit().apply$default$3()));
        }

        public void removeCommitsUntilVersion(long version) {
            ArrayBuffer toRemove = (ArrayBuffer)this.ucCommits().takeWhile((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PerTableData.$anonfun$removeCommitsUntilVersion$1(version, x$4)));
            this.ucCommits().$minus$minus$eq((IterableOnce)toRemove);
        }

        public void markLastCommitBackfilled() {
            this.ucCommits().lastOption().foreach((Function1 & Serializable)lastUCCommit -> {
                PerTableData.$anonfun$markLastCommitBackfilled$1(this, lastUCCommit);
                return BoxedUnit.UNIT;
            });
        }

        public scala.collection.immutable.Seq<Commit> getCommits(Option<Object> startVersion, Option<Object> endVersion) {
            scala.collection.immutable.Seq seq;
            Object object = new Object();
            try {
                long effectiveStartVersion = BoxesRunTime.unboxToLong((Object)startVersion.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                long effectiveEndVersion = BoxesRunTime.unboxToLong((Object)endVersion.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.ucCommits().lastOption().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.version())).getOrElse((Function0 & Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)package$.MODULE$.Seq().empty());
                }))));
                seq = ((IterableOnceOps)((StrictOptimizedIterableOps)this.ucCommits().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)PerTableData.$anonfun$getCommits$5(effectiveStartVersion, effectiveEndVersion, c)))).map((Function1 & Serializable)x$6 -> x$6.commit())).toSeq();
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    seq = (scala.collection.immutable.Seq)ex.value();
                }
                throw ex;
            }
            return seq;
        }

        public /* synthetic */ InMemoryUCCommitCoordinator org$apache$spark$sql$delta$coordinatedcommits$InMemoryUCCommitCoordinator$PerTableData$$$outer() {
            return this.$outer;
        }

        private final void UCCommit$lzycompute$1() {
            PerTableData perTableData = this;
            synchronized (perTableData) {
                if (this.UCCommit$module == null) {
                    this.UCCommit$module = new InMemoryUCCommitCoordinator$PerTableData$UCCommit$(this);
                }
            }
        }

        public static final /* synthetic */ boolean $anonfun$isActive$1(UCCommit x$2) {
            return !x$2.isDisownCommit();
        }

        public static final /* synthetic */ boolean $anonfun$removeCommitsUntilVersion$1(long version$1, UCCommit x$4) {
            return x$4.version() <= version$1;
        }

        public static final /* synthetic */ void $anonfun$markLastCommitBackfilled$1(PerTableData $this, UCCommit lastUCCommit) {
            boolean x$1 = true;
            Commit x$2 = lastUCCommit.copy$default$1();
            boolean x$3 = lastUCCommit.copy$default$2();
            $this.ucCommits().update($this.ucCommits().size() - 1, (Object)lastUCCommit.copy(x$2, x$3, true));
        }

        public static final /* synthetic */ boolean $anonfun$getCommits$5(long effectiveStartVersion$1, long effectiveEndVersion$1, UCCommit c) {
            return effectiveStartVersion$1 <= c.version() && c.version() <= effectiveEndVersion$1 && !c.isBackfilled();
        }

        public PerTableData(InMemoryUCCommitCoordinator $outer, URI path) {
            this.path = path;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.ucCommits = ArrayBuffer$.MODULE$.empty();
            this.lock = new ReentrantReadWriteLock();
        }

        private class UCCommit
        implements Product,
        Serializable {
            private final Commit commit;
            private final boolean isDisownCommit;
            private final boolean isBackfilled;
            private final long version;
            public final /* synthetic */ PerTableData $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Commit commit() {
                return this.commit;
            }

            public boolean isDisownCommit() {
                return this.isDisownCommit;
            }

            public boolean isBackfilled() {
                return this.isBackfilled;
            }

            public long version() {
                return this.version;
            }

            public UCCommit copy(Commit commit, boolean isDisownCommit, boolean isBackfilled) {
                return new UCCommit(this.org$apache$spark$sql$delta$coordinatedcommits$InMemoryUCCommitCoordinator$PerTableData$UCCommit$$$outer(), commit, isDisownCommit, isBackfilled);
            }

            public Commit copy$default$1() {
                return this.commit();
            }

            public boolean copy$default$2() {
                return this.isDisownCommit();
            }

            public boolean copy$default$3() {
                return this.isBackfilled();
            }

            public String productPrefix() {
                return "UCCommit";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return this.commit();
                    }
                    case 1: {
                        return BoxesRunTime.boxToBoolean((boolean)this.isDisownCommit());
                    }
                    case 2: {
                        return BoxesRunTime.boxToBoolean((boolean)this.isBackfilled());
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof UCCommit;
            }

            public String productElementName(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return "commit";
                    }
                    case 1: {
                        return "isDisownCommit";
                    }
                    case 2: {
                        return "isBackfilled";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commit()));
                n = Statics.mix((int)n, (int)(this.isDisownCommit() ? 1231 : 1237));
                n = Statics.mix((int)n, (int)(this.isBackfilled() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof UCCommit)) return false;
                if (((UCCommit)object).org$apache$spark$sql$delta$coordinatedcommits$InMemoryUCCommitCoordinator$PerTableData$UCCommit$$$outer() != this.org$apache$spark$sql$delta$coordinatedcommits$InMemoryUCCommitCoordinator$PerTableData$UCCommit$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                UCCommit uCCommit = (UCCommit)x$1;
                if (this.isDisownCommit() != uCCommit.isDisownCommit()) return false;
                if (this.isBackfilled() != uCCommit.isBackfilled()) return false;
                Commit commit = this.commit();
                Commit commit2 = uCCommit.commit();
                if (commit == null) {
                    if (commit2 != null) {
                        return false;
                    }
                } else if (!commit.equals(commit2)) return false;
                if (!uCCommit.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ PerTableData org$apache$spark$sql$delta$coordinatedcommits$InMemoryUCCommitCoordinator$PerTableData$UCCommit$$$outer() {
                return this.$outer;
            }

            public UCCommit(PerTableData $outer, Commit commit, boolean isDisownCommit, boolean isBackfilled) {
                this.commit = commit;
                this.isDisownCommit = isDisownCommit;
                this.isBackfilled = isBackfilled;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
                this.version = commit.getVersion();
            }
        }
    }
}

