/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.hooks;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.hooks.AutoCompactPartitionReserve$;
import org.apache.spark.sql.delta.hooks.AutoCompactRequest;
import org.apache.spark.sql.delta.hooks.AutoCompactUtils;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.AutoCompactPartitionStats;
import org.apache.spark.sql.delta.stats.AutoCompactPartitionStats$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public final class AutoCompactUtils$
implements DeltaLogging {
    public static final AutoCompactUtils$ MODULE$ = new AutoCompactUtils$();
    private static final String STATUS_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        STATUS_NAME = "status";
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String STATUS_NAME() {
        return STATUS_NAME;
    }

    private Seq<Expression> createPartitionPredicate(Snapshot postCommitSnapshot, Set<scala.collection.immutable.Map<String, String>> partitions) {
        StructType schema = postCommitSnapshot.metadata().physicalPartitionSchema();
        Set partitionBranches = (Set)((IterableOps)partitions.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))).map((Function1 & Serializable)partition -> (Expression)((IterableOnceOps)partition.toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                StructField field = schema.apply(key);
                return new EqualNullSafe((Expression)UnresolvedAttribute$.MODULE$.quoted(key), (Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)value), field.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
            }
            throw new MatchError((Object)tuple2);
        })).reduceLeft((Function2 & Serializable)(left, right) -> new And(left, right)));
        if (partitionBranches.size() > 1) {
            return new .colon.colon((Object)((Expression)partitionBranches.reduceLeft((Function2 & Serializable)(left, right) -> new Or(left, right))), (List)Nil$.MODULE$);
        }
        if (partitionBranches.size() == 1) {
            return partitionBranches.toList();
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean isModifiedPartitionsOnlyAutoCompactEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_MODIFIED_PARTITIONS_ONLY_ENABLED()));
    }

    public boolean isNonBlindAppendAutoCompactEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_NON_BLIND_APPEND_ENABLED()));
    }

    public boolean reservePartitionEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_RESERVE_PARTITIONS_ENABLED()));
    }

    public int minNumFilesForAutoCompact(SparkSession spark) {
        return BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_MIN_NUM_FILES()));
    }

    private Tuple2<Object, Set<scala.collection.immutable.Map<String, String>>> reserveTablePartitions(SparkSession spark, DeltaLog deltaLog, Snapshot postCommitSnapshot, Option<Set<scala.collection.immutable.Map<String, String>>> partitionsAddedToOpt, String opType, Option<Object> maxDeletedRowsRatio) {
        boolean shouldCompact;
        Set<scala.collection.immutable.Map<String, String>> freePartitions;
        if (partitionsAddedToOpt.isEmpty()) {
            DeltaLog x$1 = deltaLog;
            String x$2 = opType;
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STATUS_NAME()), (Object)"skipEmptyIngestion")}));
            scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Predef$.MODULE$.Set().empty());
        }
        boolean shouldReservePartitions = this.isModifiedPartitionsOnlyAutoCompactEnabled(spark) && this.reservePartitionEnabled(spark);
        Set<scala.collection.immutable.Map<String, String>> set = freePartitions = shouldReservePartitions ? AutoCompactPartitionReserve$.MODULE$.filterFreePartitions(deltaLog.tableId(), (Set<scala.collection.immutable.Map<String, String>>)((Set)partitionsAddedToOpt.get())) : (Set<scala.collection.immutable.Map<String, String>>)partitionsAddedToOpt.get();
        if (freePartitions.isEmpty()) {
            DeltaLog x$6 = deltaLog;
            String x$7 = opType;
            scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STATUS_NAME()), (Object)"skipAllPartitionsAlreadyReserved")}));
            scala.collection.immutable.Map<TagDefinition, String> x$9 = this.recordDeltaEvent$default$3();
            Option<Path> x$10 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$6, x$7, x$9, x$8, x$10);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Predef$.MODULE$.Set().empty());
        }
        AutoCompactUtils.ChosenPartitionsResult chosenPartitionsResult = this.choosePartitionsBasedOnMinNumSmallFiles(spark, deltaLog, postCommitSnapshot, freePartitions);
        if (chosenPartitionsResult == null) {
            throw new MatchError((Object)chosenPartitionsResult);
        }
        boolean shouldCompactBasedOnNumFiles = chosenPartitionsResult.shouldRunAC();
        Set<scala.collection.immutable.Map<String, String>> chosenPartitionsBasedOnNumFiles = chosenPartitionsResult.chosenPartitions();
        String minNumFilesLogMsg = chosenPartitionsResult.logMessage();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)shouldCompactBasedOnNumFiles), chosenPartitionsBasedOnNumFiles, (Object)minNumFilesLogMsg);
        boolean shouldCompactBasedOnNumFiles2 = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        Set chosenPartitionsBasedOnNumFiles2 = (Set)tuple3._2();
        String minNumFilesLogMsg2 = (String)tuple3._3();
        if (shouldCompactBasedOnNumFiles2 && chosenPartitionsBasedOnNumFiles2.isEmpty()) {
            DeltaLog x$11 = deltaLog;
            String x$12 = opType;
            scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STATUS_NAME()), (Object)"runOnAllPartitions")}));
            scala.collection.immutable.Map<TagDefinition, String> x$14 = this.recordDeltaEvent$default$3();
            Option<Path> x$15 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$11, x$12, x$14, x$13, x$15);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)shouldCompactBasedOnNumFiles2), (Object)chosenPartitionsBasedOnNumFiles2);
        }
        Tuple2<Object, Set<scala.collection.immutable.Map<String, String>>> tuple2 = this.choosePartitionsBasedOnDVs(freePartitions, postCommitSnapshot, maxDeletedRowsRatio);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean shouldCompactBasedOnDVs = tuple2._1$mcZ$sp();
        Set chosenPartitionsBasedOnDVs = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)shouldCompactBasedOnDVs), (Object)chosenPartitionsBasedOnDVs);
        boolean shouldCompactBasedOnDVs2 = tuple22._1$mcZ$sp();
        Set chosenPartitionsBasedOnDVs2 = (Set)tuple22._2();
        Set finalPartitions = (Set)chosenPartitionsBasedOnNumFiles2.$plus$plus((IterableOnce)chosenPartitionsBasedOnDVs2);
        if (this.isModifiedPartitionsOnlyAutoCompactEnabled(spark)) {
            int maxNumPartitions = BoxesRunTime.unboxToInt((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_MAX_NUM_MODIFIED_PARTITIONS()));
            finalPartitions = finalPartitions.size() > maxNumPartitions ? ((IterableOnceOps)((IndexedSeqOps)Random$.MODULE$.shuffle((IterableOnce)finalPartitions.toIndexedSeq(), BuildFrom$.MODULE$.buildFromIterableOps())).take(maxNumPartitions)).toSet() : finalPartitions;
        }
        int numChosenPartitions = finalPartitions.size();
        if (shouldReservePartitions) {
            finalPartitions = AutoCompactPartitionReserve$.MODULE$.tryReservePartitions(deltaLog.tableId(), (Set<scala.collection.immutable.Map<String, String>>)finalPartitions);
        }
        if (numChosenPartitions > 0 && finalPartitions.isEmpty()) {
            DeltaLog x$16 = deltaLog;
            String x$17 = opType;
            scala.collection.immutable.Map x$18 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STATUS_NAME()), (Object)"skipAllPartitionsAlreadyReserved")}));
            scala.collection.immutable.Map<TagDefinition, String> x$19 = this.recordDeltaEvent$default$3();
            Option<Path> x$20 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$16, x$17, x$19, x$18, x$20);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Predef$.MODULE$.Set().empty());
        }
        boolean bl = shouldCompact = shouldCompactBasedOnNumFiles2 || shouldCompactBasedOnDVs2;
        BoxedUnit statusLogMessage = !shouldCompact ? new StringBuilder(4).append("skip").append(minNumFilesLogMsg2).toString() : (shouldCompactBasedOnNumFiles2 && !shouldCompactBasedOnDVs2 ? new StringBuilder(3).append("run").append(minNumFilesLogMsg2).toString() : (shouldCompactBasedOnNumFiles2 && shouldCompactBasedOnDVs2 ? new StringBuilder(23).append("run").append(minNumFilesLogMsg2).append("AndPartitionsWithDVs").toString() : (!shouldCompactBasedOnNumFiles2 && shouldCompactBasedOnDVs2 ? "runOnPartitionsWithDVs" : BoxedUnit.UNIT)));
        scala.collection.mutable.Map logData = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STATUS_NAME()), (Object)statusLogMessage)}));
        Object object = finalPartitions.nonEmpty() ? logData.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)Integer.toString(finalPartitions.size()))) : BoxedUnit.UNIT;
        DeltaLog x$21 = deltaLog;
        String x$22 = opType;
        scala.collection.mutable.Map x$23 = logData;
        scala.collection.immutable.Map<TagDefinition, String> x$24 = this.recordDeltaEvent$default$3();
        Option<Path> x$25 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$21, x$22, x$24, x$23, x$25);
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((shouldCompactBasedOnNumFiles2 || shouldCompactBasedOnDVs2 ? 1 : 0) != 0), (Object)finalPartitions);
    }

    private AutoCompactUtils.ChosenPartitionsResult choosePartitionsBasedOnMinNumSmallFiles(SparkSession spark, DeltaLog deltaLog, Snapshot postCommitSnapshot, Set<scala.collection.immutable.Map<String, String>> freePartitionsAddedTo) {
        int minNumFiles = this.minNumFilesForAutoCompact(spark);
        boolean partitionEarlySkippingEnabled = BoxesRunTime.unboxToBoolean((Object)AutoCompactUtils$.getConf$1(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_EARLY_SKIP_PARTITION_TABLE_ENABLED(), spark));
        AutoCompactPartitionStats tablePartitionStats = AutoCompactPartitionStats$.MODULE$.instance(spark);
        if (this.isModifiedPartitionsOnlyAutoCompactEnabled(spark)) {
            long minNumFilesPerPartition = partitionEarlySkippingEnabled ? (long)minNumFiles : 0L;
            Set<scala.collection.immutable.Map<String, String>> pickedPartitions = tablePartitionStats.filterPartitionsWithSmallFiles(deltaLog.tableId(), freePartitionsAddedTo, minNumFilesPerPartition);
            if (pickedPartitions.isEmpty()) {
                return new AutoCompactUtils.ChosenPartitionsResult(false, pickedPartitions, "InsufficientFilesInModifiedPartitions");
            }
            return new AutoCompactUtils.ChosenPartitionsResult(true, pickedPartitions, "OnModifiedPartitions");
        }
        if (partitionEarlySkippingEnabled) {
            boolean shouldCompact;
            long maxNumFiles = tablePartitionStats.maxNumFilesInTable(deltaLog.tableId());
            boolean bl = shouldCompact = maxNumFiles >= (long)minNumFiles;
            if (shouldCompact) {
                return new AutoCompactUtils.ChosenPartitionsResult(true, (Set<scala.collection.immutable.Map<String, String>>)Predef$.MODULE$.Set().empty(), "OnAllPartitions");
            }
            return new AutoCompactUtils.ChosenPartitionsResult(false, (Set<scala.collection.immutable.Map<String, String>>)Predef$.MODULE$.Set().empty(), "InsufficientInAllPartitions");
        }
        return new AutoCompactUtils.ChosenPartitionsResult(true, (Set<scala.collection.immutable.Map<String, String>>)Predef$.MODULE$.Set().empty(), "OnAllPartitions");
    }

    private Tuple2<Object, Set<scala.collection.immutable.Map<String, String>>> choosePartitionsBasedOnDVs(Set<scala.collection.immutable.Map<String, String>> freePartitionsAddedTo, Snapshot postCommitSnapshot, Option<Object> maxDeletedRowsRatio) {
        Set partitionsWithDVs = maxDeletedRowsRatio.nonEmpty() ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])postCommitSnapshot.allFiles().where("deletionVector IS NOT NULL").where(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n           |(deletionVector.cardinality / stats:`numRecords`) > ").append(maxDeletedRowsRatio.get()).append("\n           |").toString()))).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(partitionValues AS STRING) as partitionValuesStr", "partitionValues"})).groupBy("partitionValuesStr", (Seq)Nil$.MODULE$).agg(functions$.MODULE$.collect_list("partitionValues").as("partitionValues"), (Seq)Nil$.MODULE$).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValues[0] as partitionValues"})).collect()), (Function1 & Serializable)x$4 -> (scala.collection.immutable.Map)x$4.getAs("partitionValues"), ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class))).toSet() : Predef$.MODULE$.Set().empty();
        partitionsWithDVs = (Set)partitionsWithDVs.intersect(freePartitionsAddedTo);
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)partitionsWithDVs.nonEmpty()), (Object)partitionsWithDVs);
    }

    public AutoCompactRequest prepareAutoCompactRequest(SparkSession spark, DeltaTransaction txn, Snapshot postCommitSnapshot, Option<Set<scala.collection.immutable.Map<String, String>>> partitionsAddedToOpt, String opType, Option<Object> maxDeletedRowsRatio) {
        Tuple2<Object, Set<scala.collection.immutable.Map<String, String>>> tuple2 = this.reserveTablePartitions(spark, txn.deltaLog(), postCommitSnapshot, partitionsAddedToOpt, opType, maxDeletedRowsRatio);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean needAutoCompact = tuple2._1$mcZ$sp();
        Set reservedPartitions = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)needAutoCompact), (Object)reservedPartitions);
        boolean needAutoCompact2 = tuple22._1$mcZ$sp();
        Set reservedPartitions2 = (Set)tuple22._2();
        return new AutoCompactRequest(needAutoCompact2, (Set<scala.collection.immutable.Map<String, String>>)reservedPartitions2, this.createPartitionPredicate(postCommitSnapshot, (Set<scala.collection.immutable.Map<String, String>>)reservedPartitions2));
    }

    public boolean isQualifiedForAutoCompact(SparkSession spark, DeltaTransaction txn) {
        if (txn.txnExecutionTimeMs().isEmpty()) {
            return false;
        }
        if (!this.isModifiedPartitionsOnlyAutoCompactEnabled(spark)) {
            return true;
        }
        return !this.isNonBlindAppendAutoCompactEnabled(spark) || !txn.isBlindAppend();
    }

    private static final Object getConf$1(ConfigEntry entry, SparkSession spark$1) {
        return spark$1.sessionState().conf().getConf(entry);
    }

    private AutoCompactUtils$() {
    }
}

