/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage.dv;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.DataInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStoreUtils;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.PathWithFileSystem;
import org.apache.spark.sql.delta.util.PathWithFileSystem$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e3AAB\u0004\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003/\u0001\u0011\u0005s\u0006C\u0003F\u0001\u0011\u0005c\tC\u0003W\u0001\u0011\u0005sKA\fIC\u0012|w\u000e\u001d$jY\u0016\u001c\u0016p\u001d;f[\u001236\u000b^8sK*\u0011\u0001\"C\u0001\u0003IZT!AC\u0006\u0002\u000fM$xN]1hK*\u0011A\"D\u0001\u0006I\u0016dG/\u0019\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001f?5\tq!\u0003\u0002!\u000f\t\u0019B)\u001a7fi&|gNV3di>\u00148\u000b^8sK\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2p]\u001aT!aJ\t\u0002\r!\fGm\\8q\u0013\tICEA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003C\u0001\u0010\u0001\u0011\u0015\t#\u00011\u0001#\u0003\u0011\u0011X-\u00193\u0015\tA2dh\u0011\t\u0003cQj\u0011A\r\u0006\u0003g-\tq\u0002Z3mKRLwN\u001c<fGR|'o]\u0005\u0003kI\u0012!CU8be&twMQ5u[\u0006\u0004\u0018I\u001d:bs\")qg\u0001a\u0001q\u0005!\u0001/\u0019;i!\tID(D\u0001;\u0015\tYd%\u0001\u0002gg&\u0011QH\u000f\u0002\u0005!\u0006$\b\u000eC\u0003@\u0007\u0001\u0007\u0001)\u0001\u0004pM\u001a\u001cX\r\u001e\t\u00031\u0005K!AQ\r\u0003\u0007%sG\u000fC\u0003E\u0007\u0001\u0007\u0001)\u0001\u0003tSj,\u0017\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014HCA$P!\tA5J\u0004\u0002\u001f\u0013&\u0011!jB\u0001\u0014\t\u0016dW\r^5p]Z+7\r^8s'R|'/Z\u0005\u0003\u00196\u0013aa\u0016:ji\u0016\u0014\u0018B\u0001(\b\u0005a!U\r\\3uS>tg+Z2u_J\u001cFo\u001c:f+RLGn\u001d\u0005\u0006o\u0011\u0001\r\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'.\tA!\u001e;jY&\u0011QK\u0015\u0002\u0013!\u0006$\bnV5uQ\u001aKG.Z*zgR,W.\u0001\nqCRDw+\u001b;i\r&dWmU=ti\u0016lGC\u0001)Y\u0011\u00159T\u00011\u00019\u0001")
public class HadoopFileSystemDVStore
implements DeletionVectorStore {
    private final Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public RoaringBitmapArray read(DeletionVectorDescriptor dvDescriptor, Path tablePath) {
        return DeletionVectorStore.read$(this, dvDescriptor, tablePath);
    }

    @Override
    public PathWithFileSystem generateFileNameInTable(PathWithFileSystem targetPath, UUID fileId, String prefix) {
        return DeletionVectorStore.generateFileNameInTable$(this, targetPath, fileId, prefix);
    }

    @Override
    public String generateFileNameInTable$default$3() {
        return DeletionVectorStore.generateFileNameInTable$default$3$(this);
    }

    @Override
    public PathWithFileSystem generateUniqueNameInTable(PathWithFileSystem targetPath, String prefix) {
        return DeletionVectorStore.generateUniqueNameInTable$(this, targetPath, prefix);
    }

    @Override
    public String generateUniqueNameInTable$default$2() {
        return DeletionVectorStore.generateUniqueNameInTable$default$2$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public RoaringBitmapArray read(Path path, int offset, int size) {
        byte[] buffer;
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        byte[] x$1 = buffer = (byte[])Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> fs.open(path), (Function1 & Serializable)reader -> {
            reader.seek((long)offset);
            return DeletionVectorStore$.MODULE$.readRangeFromStream((DataInputStream)reader, size);
        });
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)BoxesRunTime.boxToInteger((int)offset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)size))}));
        Option<Path> x$3 = DeletionVectorUtils$.MODULE$.deserialize$default$2();
        return DeletionVectorUtils$.MODULE$.deserialize(x$1, x$3, (scala.collection.immutable.Map<String, Object>)x$2);
    }

    @Override
    public DeletionVectorStoreUtils.Writer createWriter(PathWithFileSystem path) {
        return new DeletionVectorStoreUtils.Writer(this, path){
            private FSDataOutputStream outputStream;
            private long writtenBytes;
            private final byte[] serializedPath;
            private final /* synthetic */ HadoopFileSystemDVStore $outer;
            private final PathWithFileSystem path$2;

            private FSDataOutputStream outputStream() {
                return this.outputStream;
            }

            private void outputStream_$eq(FSDataOutputStream x$1) {
                this.outputStream = x$1;
            }

            private long writtenBytes() {
                return this.writtenBytes;
            }

            private void writtenBytes_$eq(long x$1) {
                this.writtenBytes = x$1;
            }

            public DeletionVectorStoreUtils.DVRangeDescriptor write(byte[] data) {
                if (this.outputStream() == null) {
                    boolean overwrite = false;
                    this.outputStream_$eq(this.path$2.fs().create(this.path$2.path(), overwrite));
                    this.outputStream().writeByte((int)DeletionVectorStore$.MODULE$.DV_FILE_FORMAT_VERSION_ID_V1());
                    this.writtenBytes_$eq(this.writtenBytes() + 1L);
                }
                DeletionVectorStoreUtils.DVRangeDescriptor dvRange = new DeletionVectorStoreUtils.DVRangeDescriptor(DeletionVectorStore$.MODULE$, this.outputStream().size(), data.length, DeletionVectorStore$.MODULE$.calculateChecksum(data));
                if (this.writtenBytes() != (long)dvRange.offset()) {
                    JFunction0.mcZ.sp & Serializable x$1 = (JFunction0.mcZ.sp & Serializable)() -> this.writtenBytes() == (long)dvRange.offset();
                    String x$2 = "dv.write.offsetMismatch";
                    String x$3 = "Offset mismatch while writing deletion vector to file";
                    scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.path$2.path().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reportedOffset"), (Object)BoxesRunTime.boxToInteger((int)dvRange.offset())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"calculatedOffset"), (Object)BoxesRunTime.boxToLong((long)this.writtenBytes()))}));
                    DeltaLog x$5 = this.$outer.deltaAssert$default$4();
                    Option<Path> x$6 = this.$outer.deltaAssert$default$6();
                    this.$outer.deltaAssert((Function0<Object>)x$1, "dv.write.offsetMismatch", "Offset mismatch while writing deletion vector to file", x$5, x$4, x$6);
                    throw DeltaErrors$.MODULE$.deletionVectorSizeMismatch();
                }
                this.$outer.log().debug(new StringBuilder(39).append("Writing DV range to file: Path=").append(this.path$2.path()).append(", Range=").append(dvRange).toString());
                this.outputStream().writeInt(data.length);
                this.outputStream().write(data);
                this.outputStream().writeInt(dvRange.checksum());
                this.writtenBytes_$eq(this.writtenBytes() + (long)DeletionVectorStore$.MODULE$.getTotalSizeOfDVFieldsInFile(data.length));
                return dvRange;
            }

            public byte[] serializedPath() {
                return this.serializedPath;
            }

            public void close() {
                if (this.outputStream() != null) {
                    this.outputStream().close();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$2 = path$2;
                this.writtenBytes = 0L;
                this.serializedPath = DeletionVectorStore$.MODULE$.pathToEscapedString(path$2.path()).getBytes(StandardCharsets.UTF_8);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$1(org.apache.spark.sql.delta.storage.dv.HadoopFileSystemDVStore$$anon$1 org.apache.spark.sql.delta.storage.dv.DeletionVectorStoreUtils$DVRangeDescriptor )}, serializedLambda);
            }
        };
    }

    @Override
    public PathWithFileSystem pathWithFileSystem(Path path) {
        return PathWithFileSystem$.MODULE$.withConf(path, this.hadoopConf);
    }

    public HadoopFileSystemDVStore(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeletionVectorStore.$init$(this);
    }
}

