/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.commit.uccommitcoordinator;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.delta.storage.commit.Commit;
import io.delta.storage.commit.actions.AbstractMetadata;
import io.delta.storage.commit.actions.AbstractProtocol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

class UCRestClientPayload {
    UCRestClientPayload() {
    }

    static class GetMetastoreSummaryResponse {
        String metastoreId;

        GetMetastoreSummaryResponse() {
        }
    }

    static class RestGetCommitsResponse {
        public List<CommitInfo> commits;
        public Long latestTableVersion;

        RestGetCommitsResponse() {
        }
    }

    static class GetCommitsRequest {
        String tableId;
        String tableUri;
        Long startVersion;
        Long endVersion;

        GetCommitsRequest() {
        }
    }

    static class CommitRequest {
        String tableId;
        String tableUri;
        CommitInfo commitInfo;
        Long latestBackfilledVersion;
        Metadata metadata;
        Protocol protocol;

        CommitRequest() {
        }
    }

    static class ColumnInfos {
        List<ColumnInfo> columns;

        ColumnInfos() {
        }

        static ColumnInfos fromSchemaString(String string) {
            return null;
        }

        static class ColumnInfo {
            String name;
            String type;
            Boolean nullable;

            ColumnInfo() {
            }

            static ColumnInfo fromColumnDetails(String string, String string2, Boolean bl) {
                if (string == null || string2 == null || bl == null) {
                    throw new IllegalArgumentException("Column details cannot be null");
                }
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.name = string;
                columnInfo.type = string2;
                columnInfo.nullable = bl;
                return columnInfo;
            }
        }
    }

    static class PropertiesKVPairs {
        Map<String, String> properties;

        PropertiesKVPairs() {
        }

        static PropertiesKVPairs fromProperties(Map<String, String> map) {
            if (map == null) {
                throw new IllegalArgumentException("externalProperties cannot be null");
            }
            PropertiesKVPairs propertiesKVPairs = new PropertiesKVPairs();
            propertiesKVPairs.properties = map;
            return propertiesKVPairs;
        }
    }

    static class OptionsKVPairs {
        Map<String, String> options;

        OptionsKVPairs() {
        }

        static OptionsKVPairs fromFormatOptions(Map<String, String> map) {
            if (map == null) {
                throw new IllegalArgumentException("externalOptions cannot be null");
            }
            OptionsKVPairs optionsKVPairs = new OptionsKVPairs();
            optionsKVPairs.options = map;
            return optionsKVPairs;
        }
    }

    static class Metadata {
        String deltaTableId;
        String name;
        String description;
        String provider;
        OptionsKVPairs formatOptions;
        ColumnInfos schema;
        List<String> partitionColumns;
        PropertiesKVPairs properties;
        String createdTime;

        Metadata() {
        }

        static Metadata fromAbstractMetadata(AbstractMetadata abstractMetadata) {
            if (abstractMetadata == null) {
                throw new IllegalArgumentException("externalMetadata cannot be null");
            }
            Metadata metadata = new Metadata();
            metadata.deltaTableId = abstractMetadata.getId();
            metadata.name = abstractMetadata.getName();
            metadata.description = abstractMetadata.getDescription();
            metadata.provider = abstractMetadata.getProvider();
            metadata.formatOptions = OptionsKVPairs.fromFormatOptions(abstractMetadata.getFormatOptions());
            metadata.schema = ColumnInfos.fromSchemaString(abstractMetadata.getSchemaString());
            metadata.partitionColumns = abstractMetadata.getPartitionColumns();
            metadata.properties = PropertiesKVPairs.fromProperties(abstractMetadata.getConfiguration());
            metadata.createdTime = abstractMetadata.getCreatedTime().toString();
            return metadata;
        }
    }

    static class Protocol {
        Integer minReaderVersion;
        Integer minWriterVersion;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<String> readerFeatures;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<String> writerFeatures;

        Protocol() {
        }

        static Protocol fromAbstractProtocol(AbstractProtocol abstractProtocol) {
            if (abstractProtocol == null) {
                throw new IllegalArgumentException("externalProtocol cannot be null");
            }
            Protocol protocol = new Protocol();
            protocol.minReaderVersion = abstractProtocol.getMinReaderVersion();
            protocol.minWriterVersion = abstractProtocol.getMinWriterVersion();
            protocol.readerFeatures = new ArrayList<String>(abstractProtocol.getReaderFeatures());
            protocol.writerFeatures = new ArrayList<String>(abstractProtocol.getWriterFeatures());
            return protocol;
        }
    }

    static class CommitInfo {
        Long version;
        Long timestamp;
        String fileName;
        Long fileSize;
        Long fileModificationTimestamp;
        Boolean isDisownCommit;

        CommitInfo() {
        }

        static CommitInfo fromCommit(Commit commit, boolean bl) {
            if (commit == null) {
                throw new IllegalArgumentException("externalCommit cannot be null");
            }
            if (commit.getFileStatus() == null) {
                throw new IllegalArgumentException("externalCommit.getFileStatus() cannot be null");
            }
            CommitInfo commitInfo = new CommitInfo();
            commitInfo.version = commit.getVersion();
            commitInfo.timestamp = commit.getCommitTimestamp();
            commitInfo.fileName = commit.getFileStatus().getPath().getName();
            commitInfo.fileSize = commit.getFileStatus().getLen();
            commitInfo.fileModificationTimestamp = commit.getFileStatus().getModificationTime();
            commitInfo.isDisownCommit = bl;
            return commitInfo;
        }

        static Commit toCommit(CommitInfo commitInfo, Path path) {
            FileStatus fileStatus = new FileStatus(commitInfo.fileSize.longValue(), false, 0, 0L, commitInfo.fileModificationTimestamp.longValue(), new Path(path, commitInfo.fileName));
            return new Commit(commitInfo.version, fileStatus, commitInfo.timestamp);
        }
    }
}

