/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.ForcedDiskCacheStorage;
import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiException;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiRetryStrategy;
import io.github.jeremylong.openvulnerability.client.nvd.RateLimitedCall;
import io.github.jeremylong.openvulnerability.client.nvd.RateMeter;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.CachingHttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.impl.schedule.ImmediateSchedulingStrategy;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.schedule.SchedulingStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimitedClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFutureResponse.class);
    private final CloseableHttpAsyncClient client;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private long lastRequest = 0L;
    private long delay;
    private final RateMeter meter;
    ForcedDiskCacheStorage cacheStorage = null;

    RateLimitedClient() {
        this(0L, 0, 0L);
    }

    RateLimitedClient(long minimumDelay, int requestsCount, long requestWindowMilliseconds) {
        this(minimumDelay, requestsCount > 0 && requestWindowMilliseconds > 0L ? new RateMeter(requestsCount, requestWindowMilliseconds) : new RateMeter(100, 5L));
    }

    RateLimitedClient(long minimumDelay, RateMeter meter) {
        this(10, minimumDelay, meter, null);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    RateLimitedClient(int maxRetries, long minimumDelay, RateMeter meter, HttpAsyncClientSupplier httpClientSupplier) {
        this(maxRetries, minimumDelay, meter, httpClientSupplier, null);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    RateLimitedClient(int maxRetries, long minimumDelay, RateMeter meter, HttpAsyncClientSupplier httpClientSupplier, Path cachePath) {
        this.meter = meter;
        this.delay = minimumDelay;
        if (LOG.isDebugEnabled()) {
            LOG.debug("rate limited call delay: {}", (Object)this.delay);
        }
        if (httpClientSupplier == null) {
            NvdApiRetryStrategy retryStrategy = new NvdApiRetryStrategy(maxRetries, minimumDelay);
            SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMinutes((long)1L)).setConnectTimeout(Timeout.ofMinutes((long)1L)).build()).useSystemProperties().build();
            if (cachePath == null) {
                this.client = HttpAsyncClients.custom().setRoutePlanner((HttpRoutePlanner)planner).setRetryStrategy((HttpRequestRetryStrategy)retryStrategy).setConnectionManager((AsyncClientConnectionManager)connectionManager).useSystemProperties().build();
            } else {
                File cacheDir = cachePath.toFile();
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    throw new NvdApiException("Unable to create http cache directory: " + cacheDir.getAbsolutePath());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using http cache directory: {}", (Object)cacheDir.getAbsolutePath());
                }
                CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(20000000L).setSharedCache(true).setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(TimeValue.of((Duration)Duration.ofHours(20L))).setNeverCacheHTTP10ResponsesWithQueryString(true).setNeverCacheHTTP11ResponsesWithQueryString(true).setWeakETagOnPutDeleteAllowed(true).build();
                try {
                    this.cacheStorage = new ForcedDiskCacheStorage(cacheDir.getAbsolutePath(), Duration.ofHours(20L));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.client = CachingHttpAsyncClients.custom().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)this.cacheStorage).setDeleteCache(false).setSchedulingStrategy((SchedulingStrategy)ImmediateSchedulingStrategy.INSTANCE).setRoutePlanner((HttpRoutePlanner)planner).setRetryStrategy((HttpRequestRetryStrategy)retryStrategy).useSystemProperties().setConnectionManager((AsyncClientConnectionManager)connectionManager).useSystemProperties().build();
            }
        } else {
            this.client = (CloseableHttpAsyncClient)httpClientSupplier.get();
        }
        this.client.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error closing RateLimitedClient during shutdown", (Throwable)e);
            }
        }));
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.executor.shutdown();
    }

    public long getDelay() {
        return this.delay;
    }

    void setDelay(long milliseconds) {
        this.delay = milliseconds;
        if (LOG.isDebugEnabled()) {
            LOG.debug("rate limited call delay: {}", (Object)this.delay);
        }
    }

    Future<RateLimitedCall> execute(SimpleHttpRequest request, int clientIndex, int startIndex) {
        return this.executor.submit(() -> this.delayedExecute(request, clientIndex, startIndex));
    }

    private RateLimitedCall delayedExecute(SimpleHttpRequest request, int clientIndex, int startIndex) throws ExecutionException, InterruptedException {
        RateLimitedCall rateLimitedCall;
        block18: {
            long now;
            long wait;
            request.addHeader("Cache-Control", (Object)"max-age=72000");
            if (this.cacheStorage != null) {
                HttpCacheEntry entry = null;
                try {
                    String key = CacheKeyGenerator.INSTANCE.generateKey(request.getUri());
                    entry = this.cacheStorage.getEntry(key);
                    if (entry != null) {
                        Future f = this.client.execute(request, (FutureCallback)new SimpleFutureResponse());
                        return new RateLimitedCall((SimpleHttpResponse)f.get(), clientIndex, startIndex);
                    }
                }
                catch (URISyntaxException | ResourceIOException key) {
                    // empty catch block
                }
            }
            if (this.lastRequest > 0L && this.delay > 0L && (wait = this.delay - ((now = ZonedDateTime.now().toInstant().toEpochMilli()) - this.lastRequest)) > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Rate Limited API call - waiting for {}ms", (Object)wait);
                }
                Thread.sleep(wait);
            }
            RateMeter.Ticket t = this.meter.getTicket();
            try {
                if (LOG.isDebugEnabled()) {
                    LocalTime time = LocalTime.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Requested At: {}; URI: {}", (Object)time.format(formatter), (Object)request.getRequestUri());
                    }
                }
                Future f = this.client.execute(request, (FutureCallback)new SimpleFutureResponse());
                this.lastRequest = ZonedDateTime.now().toInstant().toEpochMilli();
                rateLimitedCall = new RateLimitedCall((SimpleHttpResponse)f.get(), clientIndex, startIndex);
                if (t == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        throw (InterruptedException)e;
                    }
                    if (e instanceof ExecutionException) {
                        throw (ExecutionException)e;
                    }
                    throw new NvdApiException(e);
                }
            }
            t.close();
        }
        return rateLimitedCall;
    }

    static class SimpleFutureResponse
    implements FutureCallback<SimpleHttpResponse> {
        private final Logger log = LoggerFactory.getLogger(SimpleFutureResponse.class);

        SimpleFutureResponse() {
        }

        public void completed(SimpleHttpResponse result) {
        }

        public void failed(Exception ex) {
            this.log.debug("request failed", (Throwable)ex);
        }

        public void cancelled() {
        }
    }
}

