package io.vertx.mutiny.ext.auth.prng;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A secure non blocking random number generator isolated to the current context. The PRNG is bound to the vert.x
 * context and setup to close when the context shuts down.
 * <p>
 * When applicable, use of VertxContextPRNG rather than create new PRNG objects is helpful to keep the system entropy
 * usage to the minimum avoiding potential blocking across the application.
 * <p>
 * The use of VertxContextPRNG is particularly appropriate when multiple handlers use random numbers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.prng.VertxContextPRNG original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.prng.VertxContextPRNG.class)
public class VertxContextPRNG {

  public static final io.smallrye.mutiny.vertx.TypeArg<VertxContextPRNG> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new VertxContextPRNG((io.vertx.ext.auth.prng.VertxContextPRNG) obj),
    VertxContextPRNG::getDelegate
  );

  private final io.vertx.ext.auth.prng.VertxContextPRNG delegate;
  
  public VertxContextPRNG(io.vertx.ext.auth.prng.VertxContextPRNG delegate) {
    this.delegate = delegate;
  }

  public VertxContextPRNG(Object delegate) {
    this.delegate = (io.vertx.ext.auth.prng.VertxContextPRNG)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  VertxContextPRNG() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.prng.VertxContextPRNG getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxContextPRNG that = (VertxContextPRNG) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.mutiny.ext.auth.prng.VertxContextPRNG current() { 
    io.vertx.mutiny.ext.auth.prng.VertxContextPRNG ret = io.vertx.mutiny.ext.auth.prng.VertxContextPRNG.newInstance((io.vertx.ext.auth.prng.VertxContextPRNG)io.vertx.ext.auth.prng.VertxContextPRNG.current());
    return ret;
  }

  /**
   * @param vertx a Vert.x instance.
   * @return A secure non blocking random number generator.
   */
  public static io.vertx.mutiny.ext.auth.prng.VertxContextPRNG current(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.prng.VertxContextPRNG ret = io.vertx.mutiny.ext.auth.prng.VertxContextPRNG.newInstance((io.vertx.ext.auth.prng.VertxContextPRNG)io.vertx.ext.auth.prng.VertxContextPRNG.current(vertx.getDelegate()));
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @param length the desired string length before Base64 encoding.
   * @return A base 64 encoded string.
   */
  public String nextString(int length) { 
    String ret = delegate.nextString(length);
    return ret;
  }

  /**
   * @return random int.
   */
  public int nextInt() { 
    int ret = delegate.nextInt();
    return ret;
  }

  /**
   * @param bound the upper bound (exclusive), which must be positive.
   * @return random int.
   */
  public int nextInt(int bound) { 
    int ret = delegate.nextInt(bound);
    return ret;
  }

  /**
   * @return random boolean.
   */
  public boolean nextBoolean() { 
    boolean ret = delegate.nextBoolean();
    return ret;
  }

  /**
   * @return random long.
   */
  public long nextLong() { 
    long ret = delegate.nextLong();
    return ret;
  }

  /**
   * @return random float.
   */
  public float nextFloat() { 
    float ret = delegate.nextFloat();
    return ret;
  }

  /**
   * @return random double.
   */
  public double nextDouble() { 
    double ret = delegate.nextDouble();
    return ret;
  }

  /**
   * @return random double.
   */
  public double nextGaussian() { 
    double ret = delegate.nextGaussian();
    return ret;
  }

  /**
   * @param bytes a byte array.
   */
  public void nextBytes(byte[] bytes) { 
    delegate.nextBytes(bytes);
  }

  public static  VertxContextPRNG newInstance(io.vertx.ext.auth.prng.VertxContextPRNG arg) {
    return arg != null ? new VertxContextPRNG(arg) : null;
  }

}
