package io.vertx.mutiny.ext.web.handler.sockjs;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.Future;

/**
 * Represents an event that occurs on the event bus bridge.
 * <p>
 * Please consult the documentation for a full explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.BridgeEvent original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.sockjs.BridgeEvent.class)
public class BridgeEvent extends io.vertx.mutiny.ext.bridge.BaseBridgeEvent {

  public static final io.smallrye.mutiny.vertx.TypeArg<BridgeEvent> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new BridgeEvent((io.vertx.ext.web.handler.sockjs.BridgeEvent) obj),
    BridgeEvent::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.BridgeEvent delegate;
  
  public BridgeEvent(io.vertx.ext.web.handler.sockjs.BridgeEvent delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public BridgeEvent(Object delegate) {
    super((io.vertx.ext.web.handler.sockjs.BridgeEvent)delegate);
    this.delegate = (io.vertx.ext.web.handler.sockjs.BridgeEvent)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  BridgeEvent() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.sockjs.BridgeEvent getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BridgeEvent that = (BridgeEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void complete(Boolean result) { 
    delegate.complete(result);
  }

  public boolean tryComplete(Boolean arg0) { 
    boolean ret = delegate.tryComplete(arg0);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> future() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.future());}

  public Boolean futureAndAwait() { 
    return future().await().indefinitely();
  }


  public void futureAndForget() { 
    future().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @param message the raw message
   * @return this reference, so it can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.sockjs.BridgeEvent setRawMessage(JsonObject message) { 
    delegate.setRawMessage(message);
    return this;
  }

  /**
   * @return the SockJSSocket instance
   */
  public io.vertx.mutiny.ext.web.handler.sockjs.SockJSSocket socket() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.mutiny.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.socket());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.mutiny.ext.web.handler.sockjs.SockJSSocket cached_0;
  public static  BridgeEvent newInstance(io.vertx.ext.web.handler.sockjs.BridgeEvent arg) {
    return arg != null ? new BridgeEvent(arg) : null;
  }

}
