/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.SSLUtil;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);

    public static SSLSocketFactory createSSLFactory(Config config) {
        String truststore = config.getValue("oauth.ssl.truststore.location");
        String truststoreData = config.getValue("oauth.ssl.truststore.certificates");
        String password = config.getValue("oauth.ssl.truststore.password");
        String type = config.getValue("oauth.ssl.truststore.type");
        String rnd = config.getValue("oauth.ssl.secure.random.implementation");
        return SSLUtil.createSSLFactory(truststore, truststoreData, password, type, rnd);
    }

    public static HostnameVerifier createHostnameVerifier(Config config) {
        String hostCheck = config.getValue("oauth.ssl.endpoint.identification.algorithm", "HTTPS");
        return "".equals(hostCheck) ? SSLUtil.createAnyHostHostnameVerifier() : null;
    }

    public static void putIfNotNull(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    public static int getConnectTimeout(Config config) {
        return ConfigUtil.getTimeoutAppendingWarnings(config, "oauth.connect.timeout.seconds", null);
    }

    public static int getReadTimeout(Config config) {
        return ConfigUtil.getTimeoutAppendingWarnings(config, "oauth.read.timeout.seconds", null);
    }

    public static int getTimeoutAppendingWarnings(Config c, String key, List<String> warnings) {
        int timeout = c.getValueAsInt(key, 60);
        if (timeout <= 0) {
            String msg = "The configured value of `" + key + "` (" + timeout + ") is <= 0 and will be ignored. Default used: 60 seconds";
            if (warnings != null) {
                warnings.add(msg);
            } else {
                log.warn(msg);
            }
            timeout = 60;
        }
        return timeout;
    }

    public static int getTimeoutConfigWithFallbackLookup(Config c, String key, String fallbackKey, List<String> warnings) {
        String result = c.getValue(key);
        if (result == null) {
            return ConfigUtil.getTimeoutAppendingWarnings(c, fallbackKey, warnings);
        }
        return ConfigUtil.getTimeoutAppendingWarnings(c, key, warnings);
    }

    public static String getConfigWithFallbackLookup(Config c, String key, String fallbackKey) {
        String result = c.getValue(key);
        if (result == null) {
            result = c.getValue(fallbackKey);
        }
        return result;
    }

    public static Boolean getDefaultBooleanConfigWithFallbackLookup(Config c, String key, String fallbackKey, boolean defautValue) {
        String result = c.getValue(key);
        if (result == null) {
            return c.getValueAsBoolean(fallbackKey, defautValue);
        }
        return c.getValueAsBoolean(key, defautValue);
    }
}

