/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import org.slf4j.Logger;

public class DeprecationUtil {
    public static boolean isAccessTokenJwt(Config config, Logger log, String errorPrefix) {
        String legacy = config.getValue("oauth.tokens.not.jwt");
        if (legacy != null) {
            log.warn("Config option '{}' is deprecated. Use '{}' (with reverse meaning) instead.", (Object)"oauth.tokens.not.jwt", (Object)"oauth.access.token.is.jwt");
            if (config.getValue("oauth.access.token.is.jwt") != null) {
                throw new ConfigException((errorPrefix != null ? errorPrefix : "") + "Can't use both '" + "oauth.access.token.is.jwt" + "' and '" + "oauth.tokens.not.jwt" + "'");
            }
        }
        return legacy != null ? !Config.isTrue(legacy) : config.getValueAsBoolean("oauth.access.token.is.jwt", true);
    }
}

