/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.kafka.oauth.services.Credentials;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Principals;
import io.strimzi.kafka.oauth.services.Sessions;
import io.strimzi.kafka.oauth.services.Validators;
import java.util.Map;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class Services {
    private static Services services;
    private final Map<String, ?> configs;
    private final Sessions sessions = new Sessions();
    private final Validators validators = new Validators();
    private final Principals principals = new Principals();
    private final Credentials credentials = new Credentials();
    private volatile OAuthMetrics metrics;

    public static synchronized void configure(Map<String, ?> configs) {
        if (services == null) {
            services = new Services(configs);
        }
    }

    public static synchronized void close() {
        services = null;
    }

    public static Services getInstance() {
        if (services == null) {
            throw new IllegalStateException("Services object has not been properly initialised");
        }
        return services;
    }

    private Services(Map<String, ?> configs) {
        this.configs = configs;
    }

    public Validators getValidators() {
        return this.validators;
    }

    public static boolean isAvailable() {
        return services != null;
    }

    public Sessions getSessions() {
        return this.sessions;
    }

    public Principals getPrincipals() {
        return this.principals;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OAuthMetrics getMetrics() {
        if (this.metrics != null) return this.metrics;
        Class<Services> clazz = Services.class;
        synchronized (Services.class) {
            if (this.metrics != null) return this.metrics;
            this.metrics = new OAuthMetrics(this.configs);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.metrics;
        }
    }
}

