/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class OpenAPIParser {
    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readLocation(url, auth, options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readContents(swaggerAsString, auth, options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    protected List<SwaggerParserExtension> getExtensions() {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            extensions.add(itr.next());
        }
        extensions.add(0, (SwaggerParserExtension)new OpenAPIV3Parser());
        return extensions;
    }
}

