/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nz.ac.auckland.aem.lmz.core.ComponentBeanContext;
import nz.ac.auckland.aem.lmz.core.WidgetRenderContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMZWidgetRenderer {
    public static final String GROUP_ADMIN = "administrators";
    private static Logger logger = LoggerFactory.getLogger(LMZWidgetRenderer.class);
    public static final String METADATA_URL = "md_url";
    public static final String METADATA_VERSION = "md_version";
    private ComponentBeanContext context;

    public LMZWidgetRenderer(ComponentBeanContext context) {
        this.context = context;
    }

    public boolean isAdministrator() throws RepositoryException {
        UserManager usrMgr = (UserManager)this.context.getResourceResolver().adaptTo(UserManager.class);
        Session session = this.context.getCurrentNode().getSession();
        Authorizable auth = usrMgr.getAuthorizable(session.getUserID());
        Iterator authGroups = auth.memberOf();
        while (authGroups.hasNext()) {
            Group grp = (Group)authGroups.next();
            if (!grp.getID().equals(GROUP_ADMIN)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getConfigurationMap() {
        HashMap<String, String> confMap = new HashMap<String, String>();
        for (Map.Entry entry : this.context.getProperties().entrySet()) {
            if (!this.isConfigurationProperty((String)entry.getKey())) continue;
            confMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confMap;
    }

    protected boolean isConfigurationProperty(String propertyName) {
        return !propertyName.startsWith("jcr:") && !propertyName.startsWith("sling:") && !propertyName.startsWith("md_") && !propertyName.startsWith("cq:");
    }

    public WidgetRenderContext getRenderContext() {
        if (StringUtils.isBlank((CharSequence)this.getMetadataEndpointUrl())) {
            return null;
        }
        WidgetRenderContext rContext = new WidgetRenderContext(this.getMetadataEndpointUrl(), this.getConfigurationMap(), this.getWidgetVersionProperty());
        if (this.context.isAuthor()) {
            rContext.fetchWidgetContent();
        }
        return rContext;
    }

    public boolean isEsiInclude() {
        return this.context.isPublish();
    }

    public boolean isDisabled() {
        return (Boolean)this.context.getComponent().getProperties().get("maintenanceMode", (Object)false);
    }

    public String getMaintenanceMessage() {
        return (String)this.context.getComponent().getProperties().get("maintenanceMessage", (Object)null);
    }

    public String getMetadataEndpointUrl() {
        return (String)this.context.getProperties().get(METADATA_URL, String.class);
    }

    protected String getWidgetVersionProperty() {
        return (String)this.context.getProperties().get(METADATA_VERSION, (Object)"");
    }
}

