/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.helper;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import nz.ac.auckland.aem.lmz.helper.CatalogServletHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogServletHelperImpl
implements CatalogServletHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogServletHelperImpl.class);
    private SlingSettingsService settings;

    @Override
    public void outputError(SlingHttpServletResponse response, String msg) {
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.println("<html><body><h1>Error</h1><p>" + msg + "</p></body></html>");
        }
        catch (IOException ioEx) {
            LOG.error("Could not write to response object", (Throwable)ioEx);
        }
    }

    @Override
    public boolean isAuthoringEnvironment() {
        Set modes = this.settings.getRunModes();
        return modes.contains("author");
    }

    @Override
    public String getCatalogName(SlingHttpServletRequest request) {
        return request.getParameter("catalog");
    }

    @Override
    public String getRedirectTo(SlingHttpServletRequest request) {
        return request.getParameter("redirectTo");
    }

    @Override
    public boolean hasNecessaryRequestParameters(SlingHttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)this.getCatalogName(request)) && StringUtils.isNotBlank((CharSequence)this.getRedirectTo(request));
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }
}

