/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.helper;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nz.ac.auckland.aem.lmz.core.ComponentBeanContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMZCatalogHelper {
    public static final String PARAM_WIDGET_ENDPOINTS = "widgetEndpoints";
    public static final String PARAM_UUID = "catalog-uuid";
    private static final Logger LOG = LoggerFactory.getLogger(LMZCatalogHelper.class);
    private ComponentBeanContext context;

    public LMZCatalogHelper(ComponentBeanContext context) {
        this.context = context;
    }

    public String[] getWidgetList() throws RepositoryException {
        Node current = this.context.getCurrentNode();
        if (current == null || !current.hasProperty(PARAM_WIDGET_ENDPOINTS)) {
            return null;
        }
        Property prop = current.getProperty(PARAM_WIDGET_ENDPOINTS);
        if (prop.isMultiple()) {
            return (String[])this.context.getProperties().get(PARAM_WIDGET_ENDPOINTS, (Object)null);
        }
        return new String[]{(String)this.context.getProperties().get(PARAM_WIDGET_ENDPOINTS, (Object)null)};
    }

    public List<String> getCatalogResourceTypes(Session jcrSession, String catalogBasePath) throws RepositoryException {
        if (!jcrSession.nodeExists(catalogBasePath)) {
            LOG.error("No such node `{}`, returning empty list", (Object)catalogBasePath);
            return null;
        }
        Node baseNode = jcrSession.getNode(catalogBasePath);
        NodeIterator iterator = baseNode.getNodes();
        ArrayList<String> resourceTypes = new ArrayList<String>();
        while (iterator.hasNext()) {
            Node componentNode = iterator.nextNode();
            resourceTypes.add(componentNode.getPath().substring("/apps/".length()));
        }
        return resourceTypes;
    }

    public List<String> getCatalogResourceTypes() throws RepositoryException {
        return this.getCatalogResourceTypes(this.context.getCurrentNode().getSession(), this.getCatalogComponentBasePath(this.getUniqueCatalogIdentifier()));
    }

    public String getCatalogComponentBasePath(String uuid) {
        return "/apps/lmzconfig/components/" + uuid;
    }

    public String getUniqueCatalogIdentifier() {
        return (String)this.context.getProperties().get(PARAM_UUID, (Object)null);
    }
}

