/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.lmzconfigdialog;

import java.util.Arrays;
import java.util.Map;
import javax.jcr.Node;
import nz.ac.auckland.aem.beans.aem.CQDialog;
import nz.ac.auckland.aem.beans.aem.CQPanel;
import nz.ac.auckland.aem.beans.aem.CQTabPanel;
import nz.ac.auckland.aem.beans.aem.CQWidget;
import nz.ac.auckland.aem.beans.aem.CQWidgetCollection;
import nz.ac.auckland.aem.beans.aem.JCRProperty;
import nz.ac.auckland.aem.beans.aem.NTUnstructured;
import nz.ac.auckland.lmzwidget.configuration.model.WidgetConfiguration;
import nz.ac.auckland.lmzwidget.configuration.model.WidgetItem;
import nz.ac.auckland.lmzwidget.configuration.model.WidgetTab;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class LMZConfigDialogFactory {
    private WidgetConfiguration widgetConfiguration;
    private String widgetURL;
    private WidgetConfiguration wc;

    public WidgetConfiguration getWidgetConfiguration() {
        return this.widgetConfiguration;
    }

    public void setWidgetConfiguration(WidgetConfiguration widgetConfiguration) {
        this.widgetConfiguration = widgetConfiguration;
        this.wc = widgetConfiguration;
    }

    private CQDialog createCQDialog(Node node, String desc) {
        CQDialog fakeVal = new CQDialog(node);
        CQDialog retVal = new CQDialog(node);
        retVal.addProperty("title", "String", desc);
        retVal.addProperty("xtype", "String", "dialog");
        fakeVal.addChildWidget(retVal);
        return retVal;
    }

    public CQDialog createCQDialog(Node node) {
        CQDialog retVal = this.createCQDialog(node, this.wc.getWidget().getDescription());
        NTUnstructured listeners = new NTUnstructured("listeners");
        listeners.addProperty("loadcontent", "String", "function(dialog) {if (!UOA.IS_ADMIN) {var panels = dialog.findByType('tabpanel');panels[0].hideTabStripItem(panels[0].items.length - 1);}}");
        retVal.addChildWidget(listeners);
        CQWidgetCollection items = new CQWidgetCollection("items");
        retVal.addChildWidget(items);
        CQTabPanel tabs = new CQTabPanel("tabs");
        items.addChildWidget(tabs);
        CQWidgetCollection panelItems = new CQWidgetCollection("items");
        tabs.addChildWidget(panelItems);
        for (Map.Entry<String, WidgetTab> widgetTab : this.wc.getConfiguration().entrySet()) {
            if (widgetTab.getValue().getItems().isEmpty()) continue;
            CQPanel tabBasic = new CQPanel(widgetTab.getKey());
            tabBasic.addProperty("title", "String", widgetTab.getValue().getLabel());
            panelItems.addChildWidget(tabBasic);
            CQWidgetCollection widgetItems = new CQWidgetCollection("items");
            tabBasic.addChildWidget(widgetItems);
            for (Map.Entry<String, WidgetItem> widgetItem : widgetTab.getValue().getItems().entrySet()) {
                CQWidget cqWidget = this.createCQWidget(widgetItem.getKey(), widgetItem.getValue());
                widgetItems.addChildWidget(cqWidget);
                WidgetItem item = widgetItem.getValue();
                if (!this.hasOptions(item)) continue;
                this.createOptionsDropdown(cqWidget, item);
            }
        }
        this.addMetadataTab(panelItems);
        return retVal;
    }

    protected boolean hasOptions(WidgetItem item) {
        return item.getOptions() != null && !item.getOptions().isEmpty();
    }

    protected void createOptionsDropdown(CQWidget cqWidget, WidgetItem item) {
        CQWidgetCollection options = new CQWidgetCollection("options");
        cqWidget.addChildWidget(options);
        int count = 0;
        for (Map.Entry<String, String> option : item.getOptions().entrySet()) {
            String optName = "option" + ++count;
            NTUnstructured ntu = new NTUnstructured(optName);
            ntu.addProperty("text", new JCRProperty("text", "String", option.getKey()));
            ntu.addProperty("value", new JCRProperty("value", "String", option.getValue()));
            options.addChildWidget(ntu);
        }
    }

    protected void addMetadataTab(CQWidgetCollection panelItems) {
        CQPanel tabMetadata = new CQPanel("metadata");
        tabMetadata.addProperty("title", "String", "Metadata");
        panelItems.addChildWidget(tabMetadata);
        CQWidgetCollection mdWidgetItems = new CQWidgetCollection("items");
        tabMetadata.addChildWidget(mdWidgetItems);
        mdWidgetItems.addChildWidget(this.readOnly(this.createCQWidget("md_name", "Name", this.widgetConfiguration.getWidget().getName())));
        mdWidgetItems.addChildWidget(this.readOnly(this.createCQWidget("md_description", "Description", this.widgetConfiguration.getWidget().getDescription())));
        mdWidgetItems.addChildWidget(this.readOnly(this.createCQWidget("md_version", "Version", this.widgetConfiguration.getWidget().getVersion())));
        mdWidgetItems.addChildWidget(this.readOnly(this.createCQWidget("md_url", "URL", this.getWidgetURL())));
    }

    public CQWidget readOnly(CQWidget inputWidget) {
        inputWidget.addProperty("readOnly", "Boolean", "{Boolean}true");
        return inputWidget;
    }

    public CQWidget createCQWidget(String name, String stringValue) {
        return this.createCQWidget(name, name, stringValue);
    }

    public CQWidget createCQWidget(String name, String label, String stringValue) {
        CQWidget retVal = new CQWidget(name);
        retVal.addProperty("defaultValue", "String", stringValue);
        retVal.addProperty("fieldLabel", "String", label);
        retVal.addProperty("name", "String", "./" + name);
        retVal.addProperty("xtype", "String", "textfield");
        return retVal;
    }

    public CQWidget createCQWidget(String name, WidgetItem item) {
        Object[] VALID_TYPES = new String[]{"bool", "dropdown", "number", "string", "textarea"};
        String[] X_TYPES = new String[]{"selection", "selection", "numberfield", "textfield", "textarea"};
        String[] TYPES = new String[]{"checkbox", "select", null, null, null};
        int type = Arrays.binarySearch(VALID_TYPES, item.getType());
        if (StringUtils.isBlank((CharSequence)name)) {
            name = LMZConfigDialogFactory.camelCaseString(item.getLabel());
        }
        CQWidget retVal = new CQWidget(name);
        retVal.addProperty("defaultValue", "String", item.getDefaultValue());
        retVal.addProperty("fieldDescription", "String", item.getDescription());
        retVal.addProperty("fieldLabel", "String", item.getLabel());
        retVal.addProperty("allowBlank", "Boolean", item.isRequired() ? "false" : "true");
        retVal.addProperty("name", "String", "./" + name);
        if ("number".equals(item.getType())) {
            retVal.addProperty("minValue", "String", "-2147483648");
            retVal.addProperty("maxValue", "String", "2147483648");
        }
        if (item.getPattern() != null) {
            retVal.addProperty("regex", "String", WidgetItem.PATTERNS.get(item.getPattern()));
            retVal.addProperty("regexText", "String", "Please enter a valid " + item.getPattern() + " address.");
        }
        retVal.addProperty("xtype", "String", X_TYPES[type]);
        retVal.addProperty("type", "String", TYPES[type]);
        return retVal;
    }

    public static String camelCaseString(String text) {
        return StringUtils.uncapitalize((String)StringUtils.remove((String)WordUtils.capitalizeFully((String)StringUtils.stripToEmpty((String)text)), (String)" "));
    }

    public String getWidgetURL() {
        return this.widgetURL;
    }

    public void setWidgetURL(String widgetURL) {
        this.widgetURL = widgetURL;
    }
}

