/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.replication;

import com.day.cq.replication.ReplicationException;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import nz.ac.auckland.aem.lmz.helper.CatalogServletHelper;
import nz.ac.auckland.aem.lmz.services.CatalogService;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogDeleteServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogDeleteServlet.class);
    private CatalogServletHelper servlet;
    private CatalogService catalog;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.servlet.isAuthoringEnvironment()) {
            LOG.info("This servlet can only called on the authoring environment");
        }
        if (!this.servlet.hasNecessaryRequestParameters(request)) {
            LOG.warn("The request parameters are insufficient, aborting.");
            response.setStatus(406);
            return;
        }
        String catalogIdentifier = this.servlet.getCatalogName(request);
        if (!this.catalog.exists(catalogIdentifier)) {
            this.servlet.outputError(response, "No such catalog found: " + catalogIdentifier);
            return;
        }
        Session jcrSession = (Session)request.getResourceResolver().adaptTo(Session.class);
        try {
            if (this.isNodePathIdentifier(catalogIdentifier)) {
                this.deleteUnconfiguredCatalogComponent(catalogIdentifier, jcrSession);
            } else {
                this.deleteCatalogAndGeneratedComponents(catalogIdentifier, jcrSession);
            }
        }
        catch (RepositoryException rEx) {
            LOG.error("A repository exception occurred", (Throwable)rEx);
        }
        catch (ReplicationException rEx) {
            LOG.error("A replication exception occurred", (Throwable)rEx);
        }
        response.sendRedirect(this.servlet.getRedirectTo(request));
    }

    protected boolean isNodePathIdentifier(String catalogIdentifier) {
        return catalogIdentifier.startsWith("/");
    }

    protected void deleteCatalogAndGeneratedComponents(String catalogIdentifier, Session jcrSession) throws RepositoryException, ReplicationException {
        Node catalogComponent = this.catalog.findCatalogComponentWithUuid(jcrSession, catalogIdentifier);
        LOG.info("Found catalog component on path: `{}`", (Object)catalogComponent.getPath());
        this.catalog.replicateRemove(catalogIdentifier);
        this.catalog.replicateRemovePath(jcrSession, catalogComponent.getPath());
        catalogComponent.remove();
        jcrSession.getNode("/apps/lmzconfig/components/" + catalogIdentifier).remove();
        jcrSession.save();
    }

    protected void deleteUnconfiguredCatalogComponent(String nodePath, Session jcrSession) throws RepositoryException {
        LOG.info("Deleting catalog node at `{}`", (Object)nodePath);
        jcrSession.getNode(nodePath).remove();
        jcrSession.save();
    }

    protected void bindServlet(CatalogServletHelper catalogServletHelper) {
        this.servlet = catalogServletHelper;
    }

    protected void unbindServlet(CatalogServletHelper catalogServletHelper) {
        if (this.servlet == catalogServletHelper) {
            this.servlet = null;
        }
    }

    protected void bindCatalog(CatalogService catalogService) {
        this.catalog = catalogService;
    }

    protected void unbindCatalog(CatalogService catalogService) {
        if (this.catalog == catalogService) {
            this.catalog = null;
        }
    }
}

