/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.replication;

import java.io.IOException;
import javax.servlet.ServletException;
import nz.ac.auckland.aem.lmz.helper.CatalogServletHelper;
import nz.ac.auckland.aem.lmz.services.CatalogService;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogReplicationServlet
extends SlingAllMethodsServlet {
    public static final Logger LOG = LoggerFactory.getLogger(CatalogReplicationServlet.class);
    private CatalogService catalog;
    private CatalogServletHelper servletHelper;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        LOG.info("Entering 'replicateWidgetCatalog' servlet");
        if (!this.servletHelper.isAuthoringEnvironment()) {
            response.setStatus(404);
            LOG.info("Cannot run this on the publication environment, returning 404.");
            return;
        }
        if (!this.servletHelper.hasNecessaryRequestParameters(request)) {
            LOG.warn("The request parameters are insufficient, aborting.");
            response.setStatus(406);
            return;
        }
        String catalogName = this.servletHelper.getCatalogName(request);
        if (!this.catalog.exists(catalogName)) {
            this.servletHelper.outputError(response, "No such catalog found: " + catalogName);
            return;
        }
        this.catalog.replicate(catalogName);
        response.sendRedirect(this.servletHelper.getRedirectTo(request));
    }

    protected void bindCatalog(CatalogService catalogService) {
        this.catalog = catalogService;
    }

    protected void unbindCatalog(CatalogService catalogService) {
        if (this.catalog == catalogService) {
            this.catalog = null;
        }
    }

    protected void bindServletHelper(CatalogServletHelper catalogServletHelper) {
        this.servletHelper = catalogServletHelper;
    }

    protected void unbindServletHelper(CatalogServletHelper catalogServletHelper) {
        if (this.servletHelper == catalogServletHelper) {
            this.servletHelper = null;
        }
    }
}

