/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.aem.lmz.services;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import nz.ac.auckland.aem.lmz.core.LMZCatalogUsage;
import nz.ac.auckland.aem.lmz.dto.UsageLocation;
import nz.ac.auckland.aem.lmz.helper.LMZCatalogHelper;
import nz.ac.auckland.aem.lmz.services.CatalogService;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogServiceImpl
implements CatalogService {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogServiceImpl.class);
    public static final String CATALOG_RESOURCETYPE = "lmz-integration/components/lmzcatalogcomponent";
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver resourceResolver;
    private Replicator replicator;

    @Override
    public boolean exists(String catalogName) {
        if (catalogName.startsWith("/")) {
            Resource catalogResource = this.getResourceResolver().getResource(catalogName);
            if (catalogResource == null || !CATALOG_RESOURCETYPE.equals(catalogResource.getResourceType())) {
                LOG.error("Node at path `{}` does not exist, or is not of type {}", (Object)catalogName, (Object)CATALOG_RESOURCETYPE);
                return false;
            }
            return true;
        }
        return this.getCatalogResourceByUuid(catalogName) != null;
    }

    @Override
    public void replicate(String catalogName) {
        Resource catalog = this.getCatalogResourceByUuid(catalogName);
        if (catalog == null) {
            LOG.warn("Cannot replicate a catalog that does not exist, aborting.");
            return;
        }
        List<Node> allNodes = this.getRecursiveChildren((Node)catalog.adaptTo(Node.class));
        try {
            this.replicateRemove(catalogName);
            for (Node node : allNodes) {
                LOG.info("Replicating catalog element at: " + node.getPath());
                this.replicator.replicate(((Node)catalog.adaptTo(Node.class)).getSession(), ReplicationActionType.ACTIVATE, node.getPath(), this.getReplicationOptions());
            }
        }
        catch (ReplicationException repEx) {
            LOG.error("An exception during replication happened", (Throwable)repEx);
        }
        catch (RepositoryException repEx) {
            LOG.error("An exception during repository access happened", (Throwable)repEx);
        }
    }

    protected ReplicationOptions getReplicationOptions() {
        ReplicationOptions repOpts = new ReplicationOptions();
        repOpts.setSuppressStatusUpdate(true);
        repOpts.setSuppressVersions(true);
        return repOpts;
    }

    @Override
    public void replicatePages(String catalogUuid) {
        LOG.info("Trying to replicate the elements in catalog with UUID: `{}`", (Object)catalogUuid);
        try {
            LMZCatalogUsage usage = this.setupLMZCatalogUsageInstance();
            LMZCatalogHelper helper = new LMZCatalogHelper(null);
            List<String> resourcesForCatalog = helper.getCatalogResourceTypes(usage.getJcrSessionInstance(), helper.getCatalogComponentBasePath(catalogUuid));
            List<UsageLocation> locations = usage.getLocations(resourcesForCatalog);
            for (UsageLocation location : locations) {
                LOG.info("Found usage of component in page `{}`, replicating it.", (Object)location.getUrl());
                this.replicator.replicate(usage.getJcrSessionInstance(), ReplicationActionType.ACTIVATE, location.getPath());
            }
            LOG.info("Finished replicating the pages that belong to the catalog");
        }
        catch (Exception ex) {
            LOG.error("Couldn't replicate the pages for catalog `{}`, caused by:", (Object)catalogUuid, (Object)ex);
        }
    }

    @Override
    public void replicateRemove(String catalogName) throws ReplicationException, RepositoryException {
        Resource catalog = this.getCatalogResourceByUuid(catalogName);
        if (catalog == null) {
            LOG.warn("Cannot replicate a catalog that does not exist, aborting.");
            return;
        }
        this.replicateRemovePath(((Node)catalog.adaptTo(Node.class)).getSession(), catalog.getPath());
    }

    @Override
    public void replicateRemovePath(Session session, String path) throws ReplicationException, RepositoryException {
        this.replicator.replicate(session, ReplicationActionType.DELETE, path);
    }

    @Override
    public Node findCatalogComponentWithUuid(Session session, String uuid) throws RepositoryException {
        QueryManager qMgr = session.getWorkspace().getQueryManager();
        Query query = qMgr.createQuery("SELECT child.* FROM [nt:unstructured] as child WHERE child.[catalog-uuid] = '" + uuid + "'", "JCR-SQL2");
        QueryResult qResult = query.execute();
        NodeIterator nodeIterator = qResult.getNodes();
        if (nodeIterator.getSize() == 0L) {
            LOG.error("There is no node with this uuid, aborting");
            return null;
        }
        if (nodeIterator.getSize() > 1L) {
            LOG.error("There were multiple catalogs with the same UUID `{}` (shouldn't happen), aborting", (Object)uuid);
            return null;
        }
        return nodeIterator.nextNode();
    }

    protected List<Node> getRecursiveChildren(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.isPolicyNode(node)) {
            return list;
        }
        list.add(node);
        try {
            if (node.hasNodes()) {
                NodeIterator nIt = node.getNodes();
                while (nIt.hasNext()) {
                    Node childNode = nIt.nextNode();
                    list.addAll(this.getRecursiveChildren(childNode));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("An error occurred when retrieving child nodes", (Throwable)ex);
        }
        return list;
    }

    protected boolean isPolicyNode(Node node) {
        try {
            return "rep:policy".equals(node.getName());
        }
        catch (RepositoryException repEx) {
            LOG.error("Couldn't check node name", (Throwable)repEx);
            return false;
        }
    }

    protected Resource getCatalogResourceByUuid(String catalogName) {
        return this.getResourceResolver().getResource("/apps/lmzconfig/components/" + catalogName);
    }

    protected ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            try {
                this.resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            }
            catch (Exception ex) {
                LOG.error("Could not retrieve the resource resolver", (Throwable)ex);
                return null;
            }
        }
        return this.resourceResolver;
    }

    protected LMZCatalogUsage setupLMZCatalogUsageInstance() throws RepositoryException {
        LMZCatalogUsage usage = new LMZCatalogUsage();
        ResourceResolver resolver = this.getResourceResolver();
        Session jcrSession = (Session)resolver.adaptTo(Session.class);
        QueryManager queryManager = jcrSession.getWorkspace().getQueryManager();
        usage.setResourceResolverInstance(resolver);
        usage.setJcrSessionInstance(jcrSession);
        usage.setQueryManagerInstance(queryManager);
        return usage;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

