/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.auckland.lmzwidget.configuration.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import nz.ac.auckland.lmzwidget.configuration.model.WidgetConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetConfigurationParser {
    private static final Logger LOG = LoggerFactory.getLogger(WidgetConfigurationParser.class);

    public WidgetConfiguration parse(String json) {
        if (StringUtils.isEmpty((String)json)) {
            throw new IllegalArgumentException("Expected json, empty string found.");
        }
        try {
            ObjectMapper objMapper = new ObjectMapper();
            WidgetConfiguration config = objMapper.readValue(json, WidgetConfiguration.class);
            return config;
        }
        catch (IOException ioEx) {
            LOG.error("Unable to parse widget configuration", (Throwable)ioEx);
            return null;
        }
    }
}

