/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.shaded.org.jboss.logmanager.ExtHandler;
import org.apache.activemq.artemis.shaded.org.jboss.logmanager.ExtLogRecord;

public class AssertionLoggerHandler
extends ExtHandler {
    private static final Map<String, ExtLogRecord> messages = new ConcurrentHashMap<String, ExtLogRecord>();
    private static boolean capture = false;

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    protected void doPublish(ExtLogRecord record) {
        if (capture) {
            messages.put(record.getFormattedMessage(), record);
        }
    }

    public static boolean hasLevel(Level level) {
        for (ExtLogRecord record : messages.values()) {
            if (!record.getLevel().equals(level)) continue;
            return true;
        }
        return false;
    }

    public static boolean findText(long mstimeout, String ... text) {
        long timeMax = System.currentTimeMillis() + mstimeout;
        do {
            if (!AssertionLoggerHandler.findText(text)) continue;
            return true;
        } while (timeMax > System.currentTimeMillis());
        return false;
    }

    public static boolean findText(String ... text) {
        for (Map.Entry<String, ExtLogRecord> entry : messages.entrySet()) {
            Throwable throwable;
            String txtCheck;
            String key = entry.getKey();
            boolean found = true;
            String[] stringArray = text;
            int n = stringArray.length;
            for (int i = 0; i < n && ((found = key.contains(txtCheck = stringArray[i])) || (throwable = entry.getValue().getThrown()) != null && throwable.getMessage() != null && (found = throwable.getMessage().contains(txtCheck))); ++i) {
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean matchText(String pattern) {
        Pattern r = Pattern.compile(pattern);
        for (Map.Entry<String, ExtLogRecord> entry : messages.entrySet()) {
            if (r.matcher(entry.getKey()).matches()) {
                return true;
            }
            Throwable throwable = entry.getValue().getThrown();
            if (throwable == null || throwable.getMessage() == null || !r.matcher(throwable.getMessage()).matches()) continue;
            return true;
        }
        return false;
    }

    public static final void clear() {
        messages.clear();
    }

    public static final void startCapture() {
        AssertionLoggerHandler.clear();
        capture = true;
    }

    public static final void stopCapture() {
        capture = false;
        AssertionLoggerHandler.clear();
    }
}

