/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonArrayImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonLongImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonNumberImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonStringImpl;

class JsonArrayBuilderImpl
implements JsonArrayBuilder,
Serializable {
    private List<JsonValue> tmpList;

    JsonArrayBuilderImpl() {
    }

    @Override
    public JsonArrayBuilder add(JsonValue value) {
        this.addValue(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value) {
        this.addValue(new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value) {
        this.addValue(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value) {
        this.addValue(new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value) {
        this.addValue(new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value) {
        this.addValue(new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value) {
        this.addValue(new JsonDoubleImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value) {
        this.addValue(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.addValue(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.addValue(builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.addValue(builder.build());
        return this;
    }

    private void addValue(JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(value);
    }

    @Override
    public JsonArray build() {
        if (this.tmpList == null) {
            return new JsonArrayImpl(Collections.EMPTY_LIST);
        }
        List<JsonValue> dump = Collections.unmodifiableList(this.tmpList);
        this.tmpList = null;
        return new JsonArrayImpl(dump);
    }

    private static NullPointerException npe() {
        throw new NullPointerException("value/builder must not be null");
    }
}

