/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Buffer;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataInputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Headers;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Message
implements Streamable {
    protected Address dest_addr;
    protected Address src_addr;
    protected byte[] buf;
    protected int offset;
    protected int length;
    protected volatile Header[] headers;
    protected volatile short flags;
    protected volatile byte transient_flags;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    @Deprecated
    public static final Flag OOB = Flag.OOB;
    @Deprecated
    public static final Flag DONT_BUNDLE = Flag.DONT_BUNDLE;
    @Deprecated
    public static final Flag NO_FC = Flag.NO_FC;
    @Deprecated
    public static final Flag SCOPED = Flag.SCOPED;
    @Deprecated
    public static final Flag NO_RELIABILITY = Flag.NO_RELIABILITY;
    @Deprecated
    public static final Flag NO_TOTAL_ORDER = Flag.NO_TOTAL_ORDER;
    @Deprecated
    public static final Flag NO_RELAY = Flag.NO_RELAY;
    @Deprecated
    public static final Flag RSVP = Flag.RSVP;
    @Deprecated
    public static final TransientFlag OOB_DELIVERED = TransientFlag.OOB_DELIVERED;

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(Util.DEFAULT_HEADERS);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf);
    }

    public Message(Address dest, byte[] buf) {
        this(dest, (Address)null, buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, byte[] buf, int offset, int length) {
        this(dest, null, buf, offset, length);
    }

    public Message(Address dest, Address src, Object obj) {
        this(dest);
        this.setSrc(src);
        this.setObject(obj);
    }

    public Message(Address dest, Object obj) {
        this(dest, null, obj);
    }

    public Message() {
        this.headers = Message.createHeaders(Util.DEFAULT_HEADERS);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(Util.DEFAULT_HEADERS);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public Address dest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Message dest(Address new_dest) {
        this.dest_addr = new_dest;
        return this;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public Address src() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public Message src(Address new_src) {
        this.src_addr = new_src;
        return this;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final Message setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public final Message setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public final Message setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map<Short, Header> getHeaders() {
        return Headers.getHeaders(this.headers);
    }

    public String printHeaders() {
        return Headers.printHeaders(this.headers);
    }

    public int getNumHeaders() {
        return Headers.size(this.headers);
    }

    public final Message setObject(Object obj) {
        if (obj == null) {
            return this;
        }
        if (obj instanceof byte[]) {
            return this.setBuffer((byte[])obj);
        }
        if (obj instanceof Buffer) {
            return this.setBuffer((Buffer)obj);
        }
        try {
            return this.setBuffer(Util.objectToByteBuffer(obj));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public final Object getObject() {
        return this.getObject(null);
    }

    public final Object getObject(ClassLoader loader) {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length, loader);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Message setFlag(Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    public Message setTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    public Message setFlag(short flag) {
        short tmp = this.flags;
        this.flags = tmp = (short)(tmp | flag);
        return this;
    }

    public Message setTransientFlag(short flag) {
        short tmp = this.transient_flags;
        tmp = (short)(tmp | flag);
        this.transient_flags = (byte)tmp;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getTransientFlags() {
        return this.transient_flags;
    }

    public Message clearFlag(Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    public Message clearTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    public static boolean isFlagSet(short flags, Flag flag) {
        return flag != null && (flags & flag.value()) == flag.value();
    }

    public boolean isFlagSet(Flag flag) {
        return Message.isFlagSet(this.flags, flag);
    }

    public static boolean isTransientFlagSet(short flags, TransientFlag flag) {
        return flag != null && (flags & flag.value()) == flag.value();
    }

    public boolean isTransientFlagSet(TransientFlag flag) {
        return Message.isTransientFlagSet(this.transient_flags, flag);
    }

    public synchronized boolean setTransientFlagIfAbsent(TransientFlag flag) {
        if (this.isTransientFlagSet(flag)) {
            return false;
        }
        this.setTransientFlag(flag);
        return true;
    }

    public Message setScope(short scope) {
        Util.setScope(this, scope);
        return this;
    }

    public short getScope() {
        return Util.getScope(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message putHeader(short id, Header hdr) {
        if (id < 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        if (hdr != null) {
            hdr.setProtId(id);
        }
        Message message = this;
        synchronized (message) {
            Header[] resized_array = Headers.putHeader(this.headers, id, hdr, true);
            if (resized_array != null) {
                this.headers = resized_array;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message putHeaderIfAbsent(short id, Header hdr) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        if (hdr != null) {
            hdr.setProtId(id);
        }
        Message message = this;
        synchronized (message) {
            Header[] resized_array = Headers.putHeader(this.headers, id, hdr, false);
            if (resized_array != null) {
                this.headers = resized_array;
            }
        }
        return this;
    }

    public Header getHeader(short id) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid. Add the protocol which calls " + "getHeader() to jg-protocol-ids.xml");
        }
        return Headers.getHeader(this.headers, id);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        return this.copy(copy_buffer, true);
    }

    public Message copy(boolean copy_buffer, boolean copy_headers) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        short tmp_flags = this.flags;
        byte tmp_tflags = this.transient_flags;
        retval.flags = tmp_flags;
        retval.transient_flags = tmp_tflags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = copy_headers && this.headers != null ? Headers.copy(this.headers) : Message.createHeaders(Util.DEFAULT_HEADERS);
        return retval;
    }

    public Message copy(boolean copy_buffer, short starting_id) {
        return this.copy(copy_buffer, starting_id, (short[])null);
    }

    public Message copy(boolean copy_buffer, short starting_id, short ... copy_only_ids) {
        Message retval = this.copy(copy_buffer, false);
        for (Map.Entry<Short, Header> entry : this.getHeaders().entrySet()) {
            short id = entry.getKey();
            if (id < starting_id && !Util.containsId(id, copy_only_ids)) continue;
            retval.putHeader(id, entry.getValue());
        }
        return retval;
    }

    public Message makeReply() {
        Message retval = new Message(this.src_addr);
        if (this.dest_addr != null) {
            retval.setSrc(this.dest_addr);
        }
        return retval;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        int size = this.getNumHeaders();
        if (size > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size=");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        if (this.flags > 0) {
            ret.append(", flags=").append(Message.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            ret.append(", transient_flags=" + Message.transientFlagsToString(this.transient_flags));
        }
        ret.append(']');
        return ret.toString();
    }

    public String printObjectHeaders() {
        return Headers.printObjectHeaders(this.headers);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        byte leading = 0;
        if (this.dest_addr != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.src_addr != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (this.dest_addr != null) {
            Util.writeAddress(this.dest_addr, out);
        }
        if (this.src_addr != null) {
            Util.writeAddress(this.src_addr, out);
        }
        Header[] hdrs = this.headers;
        int size = Headers.size(hdrs);
        out.writeShort(size);
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            out.writeShort(hdr.getProtId());
            Message.writeHeader(hdr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
    }

    public void writeToNoAddrs(Address src, DataOutput out, short ... excluded_headers) throws Exception {
        boolean write_src_addr;
        byte leading = 0;
        boolean bl = write_src_addr = src == null || this.src_addr != null && !this.src_addr.equals(src);
        if (write_src_addr) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (write_src_addr) {
            Util.writeAddress(this.src_addr, out);
        }
        Header[] hdrs = this.headers;
        int size = Headers.size(hdrs, excluded_headers);
        out.writeShort(size);
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            short id = hdr.getProtId();
            if (excluded_headers != null && Util.containsId(id, excluded_headers)) continue;
            out.writeShort(id);
            Message.writeHeader(hdr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.src_addr = Util.readAddress(in);
        }
        int len = in.readShort();
        this.headers = Message.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            Header hdr;
            short id = in.readShort();
            this.headers[i] = hdr = Message.readHeader(in).setProtId(id);
        }
        if (Util.isFlagSet(leading, (byte)4)) {
            len = in.readInt();
            this.buf = new byte[len];
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
    }

    public int readFromSkipPayload(ByteArrayDataInputStream in) throws Exception {
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.src_addr = Util.readAddress(in);
        }
        int len = in.readShort();
        this.headers = Message.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            Header hdr;
            short id = in.readShort();
            this.headers[i] = hdr = Message.readHeader(in).setProtId(id);
        }
        if (!Util.isFlagSet(leading, (byte)4)) {
            return -1;
        }
        this.length = in.readInt();
        return in.position();
    }

    public long size() {
        long retval = 3L;
        if (this.dest_addr != null) {
            retval += (long)Util.size(this.dest_addr);
        }
        if (this.src_addr != null) {
            retval += (long)Util.size(this.src_addr);
        }
        retval += 2L;
        retval += (long)Headers.marshalledSize(this.headers);
        if (this.buf != null) {
            retval += (long)(4 + this.length);
        }
        return retval;
    }

    public static String flagsToString(short flags) {
        Flag[] all_flags;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Flag flag : all_flags = Flag.values()) {
            if (!Message.isFlagSet(flags, flag)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((Object)flag);
        }
        return sb.toString();
    }

    public static String transientFlagsToString(short flags) {
        TransientFlag[] all_flags;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TransientFlag flag : all_flags = TransientFlag.values()) {
            if (!Message.isTransientFlagSet(flags, flag)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((Object)flag);
        }
        return sb.toString();
    }

    protected static void writeHeader(Header hdr, DataOutput out) throws Exception {
        short magic_number = ClassConfigurator.getMagicNumber(hdr.getClass());
        out.writeShort(magic_number);
        hdr.writeTo(out);
    }

    protected static Header readHeader(DataInput in) throws Exception {
        short magic_number = in.readShort();
        Class<?> clazz = ClassConfigurator.get(magic_number);
        if (clazz == null) {
            throw new IllegalArgumentException("magic number " + magic_number + " is not available in magic map");
        }
        Header hdr = (Header)clazz.newInstance();
        hdr.readFrom(in);
        return hdr;
    }

    protected static Header[] createHeaders(int size) {
        return size > 0 ? new Header[size] : new Header[3];
    }

    public static enum TransientFlag {
        OOB_DELIVERED(1),
        DONT_LOOPBACK(2);

        final short value;

        private TransientFlag(short flag) {
            this.value = flag;
        }

        public short value() {
            return this.value;
        }
    }

    public static enum Flag {
        OOB(1),
        DONT_BUNDLE(2),
        NO_FC(4),
        SCOPED(8),
        NO_RELIABILITY(16),
        NO_TOTAL_ORDER(32),
        NO_RELAY(64),
        RSVP(128),
        RSVP_NB(256),
        INTERNAL(512),
        SKIP_BARRIER(1024);

        final short value;

        private Flag(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }
    }
}

