/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.auth.sasl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.auth.sasl.SaslContext;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.SASL;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.SaslHeader;

public class SaslClientContext
implements SaslContext {
    private static final byte[] EMPTY_CHALLENGE = new byte[0];
    SaslClient client;
    Subject subject;

    public SaslClientContext(final SaslClientFactory saslClientFactory, final String mech, final String server_name, final CallbackHandler callback_handler, final Map<String, String> props, Subject subject) throws SaslException {
        this.subject = subject;
        if (this.subject != null) {
            try {
                this.client = Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslClient>(){

                    @Override
                    public SaslClient run() throws Exception {
                        return saslClientFactory.createSaslClient(new String[]{mech}, null, "jgroups", server_name, props, callback_handler);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SaslException)e.getCause();
            }
        } else {
            this.client = saslClientFactory.createSaslClient(new String[]{mech}, null, "jgroups", server_name, props, callback_handler);
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.client.isComplete();
    }

    @Override
    public boolean needsWrapping() {
        if (this.client.isComplete()) {
            String qop = (String)this.client.getNegotiatedProperty("javax.security.sasl.qop");
            return qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"));
        }
        return false;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.client.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.client.unwrap(incoming, offset, len);
    }

    @Override
    public Message nextMessage(Address address, SaslHeader header) throws SaslException {
        Message message = new Message(address).setFlag(Message.Flag.OOB);
        return this.addHeader(message, header.getPayload());
    }

    @Override
    public void dispose() {
        try {
            this.client.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    public Message addHeader(Message msg, byte[] payload) throws SaslException {
        byte[] response = payload == null ? (this.client.hasInitialResponse() ? this.evaluateChallenge(EMPTY_CHALLENGE) : EMPTY_CHALLENGE) : this.evaluateChallenge(payload);
        if (response != null) {
            return msg.putHeader(SASL.SASL_ID, new SaslHeader(SaslHeader.Type.RESPONSE, response));
        }
        return null;
    }

    private byte[] evaluateChallenge(final byte[] challenge) throws SaslException {
        if (this.subject != null) {
            try {
                return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return SaslClientContext.this.client.evaluateChallenge(challenge);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SaslException) {
                    throw (SaslException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return this.client.evaluateChallenge(challenge);
    }
}

