/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux;

import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.UpHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.MuxHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.MuxRequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.Muxer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.NoMuxHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ImmutableReference;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MuxUpHandler
implements UpHandler,
Muxer<UpHandler> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Map<Short, UpHandler> handlers = Util.createConcurrentMap();
    private volatile UpHandler defaultHandler;
    private volatile Event lastFlushEvent;
    private final Object flushMutex = new Object();

    public MuxUpHandler() {
        this.defaultHandler = null;
    }

    public MuxUpHandler(UpHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(short id, UpHandler handler) {
        Object object = this.flushMutex;
        synchronized (object) {
            if (this.lastFlushEvent != null) {
                handler.up(this.lastFlushEvent);
            }
            this.handlers.put(id, handler);
        }
    }

    @Override
    public UpHandler get(short id) {
        return this.handlers.get(id);
    }

    @Override
    public void remove(short id) {
        this.handlers.remove(id);
    }

    @Override
    public UpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    @Override
    public void setDefaultHandler(UpHandler handler) {
        this.defaultHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MuxHeader hdr = (MuxHeader)msg.getHeader(MuxRequestCorrelator.MUX_ID);
                if (hdr == null) break;
                short id = hdr.getId();
                UpHandler handler = this.handlers.get(id);
                return handler != null ? handler.up(evt) : new NoMuxHandler(id);
            }
            case 17: 
            case 20: 
            case 71: 
            case 72: {
                ImmutableReference<Object> wrapper = this.handleStateTransferEvent(evt);
                if (wrapper == null) break;
                return wrapper.get();
            }
            case 10: 
            case 75: {
                Object object = this.flushMutex;
                synchronized (object) {
                    this.lastFlushEvent = evt;
                    this.passToAllHandlers(evt);
                    break;
                }
            }
            case 6: 
            case 8: 
            case 9: {
                this.passToAllHandlers(evt);
                break;
            }
            default: {
                this.passToAllHandlers(evt);
            }
        }
        return this.defaultHandler != null ? this.defaultHandler.up(evt) : null;
    }

    protected ImmutableReference<Object> handleStateTransferEvent(Event evt) {
        return null;
    }

    private void passToAllHandlers(Event evt) {
        for (UpHandler handler : this.handlers.values()) {
            handler.up(evt);
        }
    }
}

