/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.nio.ByteBuffer;

class TotOrderRequest {
    public static final byte STOP = 0;
    public static final byte ADDITION = 1;
    public static final byte SUBTRACTION = 2;
    public static final byte MULTIPLICATION = 3;
    public static final byte DIVISION = 4;
    static final int SIZE = 13;
    public byte type = 1;
    public int x = 0;
    public int y = 0;
    public int val = 0;

    public TotOrderRequest() {
    }

    TotOrderRequest(byte type, int x, int y, int val) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.val = val;
    }

    public String printType() {
        switch (this.type) {
            case 0: {
                return "STOP";
            }
            case 1: {
                return "ADDITION";
            }
            case 2: {
                return "SUBTRACTION";
            }
            case 3: {
                return "MULTIPLICATION";
            }
            case 4: {
                return "DIVISION";
            }
        }
        return "<unknown>";
    }

    public byte[] toBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(13);
        buf.put(this.type);
        buf.putInt(this.x);
        buf.putInt(this.y);
        buf.putInt(this.val);
        return buf.array();
    }

    public void init(ByteBuffer buf) {
        this.type = buf.get();
        this.x = buf.getInt();
        this.y = buf.getInt();
        this.val = buf.getInt();
    }

    public String toString() {
        return "[" + this.x + ',' + this.y + ": " + this.printType() + '(' + this.val + ")]";
    }
}

