/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;

public class FragHeader
extends Header {
    public long id;
    public int frag_id;
    public int num_frags;

    public FragHeader() {
    }

    public FragHeader(long id, int frag_id, int num_frags) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", frag_id=" + this.frag_id + ", num_frags=" + this.num_frags + ']';
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Bits.writeLong(this.id, out);
        out.writeInt(this.frag_id);
        out.writeInt(this.num_frags);
    }

    @Override
    public int size() {
        return Bits.size(this.id) + 8;
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.id = Bits.readLong(in);
        this.frag_id = in.readInt();
        this.num_frags = in.readInt();
    }
}

