/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.locking.AwaitInfo;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.locking.LockInfo;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.locking.LockNotification;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Owner;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Based class for locking functionality")
public abstract class Locking
extends Protocol {
    @Property(description="bypasses message bundling if set")
    protected boolean bypass_bundling = true;
    @Property(description="Number of locks to be used for lock striping (for synchronized access to the server_lock entries)")
    protected int lock_striping_size = 10;
    protected Address local_addr;
    protected View view;
    protected final ConcurrentMap<String, ServerLock> server_locks = Util.createConcurrentMap(20);
    protected Lock[] lock_stripes;
    protected final ClientLockTable client_lock_table = new ClientLockTable();
    protected final Set<LockNotification> lock_listeners = new CopyOnWriteArraySet<LockNotification>();
    protected static final AtomicInteger current_lock_id = new AtomicInteger(1);

    public boolean getBypassBundling() {
        return this.bypass_bundling;
    }

    public void setBypassBundling(boolean bypass_bundling) {
        this.bypass_bundling = bypass_bundling;
    }

    public void addLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.add(listener);
        }
    }

    public void removeLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.remove(listener);
        }
    }

    @ManagedAttribute
    public String getAddress() {
        return this.local_addr != null ? this.local_addr.toString() : null;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : null;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.lock_stripes = new Lock[this.lock_striping_size];
        for (int i = 0; i < this.lock_stripes.length; ++i) {
            this.lock_stripes[i] = new ReentrantLock();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 95: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName());
                if (!info.isTrylock()) {
                    if (info.isLockInterruptibly()) {
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        lock.lock();
                    }
                } else if (info.isUseTimeout()) {
                    try {
                        return lock.tryLock(info.getTimeout(), info.getTimeUnit());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    return lock.tryLock();
                }
                return null;
            }
            case 96: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock != null) {
                    lock.unlock();
                }
                return null;
            }
            case 97: {
                this.unlockAll();
                return null;
            }
            case 98: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                Condition condition = lock.newCondition();
                if (info.isUseTimeout()) {
                    try {
                        return condition.awaitNanos(info.getTimeUnit().toNanos(info.getTimeout()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else if (info.isLockInterruptibly()) {
                    try {
                        condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    condition.awaitUninterruptibly();
                }
                return null;
            }
            case 99: {
                AwaitInfo awaitInfo = (AwaitInfo)evt.getArg();
                ClientLock lock = this.getLock(awaitInfo.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                this.sendSignalConditionRequest(awaitInfo.getName(), awaitInfo.isAll());
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                LockingHeader hdr = (LockingHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                if (null != this.view && !this.view.containsMember(msg.getSrc())) {
                    this.log.error("Received locking event from '%s' but member is not present in the current view - ignoring request", msg.getSrc());
                    return null;
                }
                Request req = null;
                try {
                    req = Util.streamableFromBuffer(Request.class, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                }
                catch (Exception ex) {
                    this.log.error("failed deserializng request", ex);
                    return null;
                }
                this.log.trace("[%s] <-- [%s] %s", this.local_addr, msg.getSrc(), req);
                switch (req.type) {
                    case GRANT_LOCK: 
                    case RELEASE_LOCK: {
                        this.handleLockRequest(req);
                        break;
                    }
                    case LOCK_GRANTED: {
                        this.handleLockGrantedResponse(req.lock_name, req.lock_id, req.owner);
                        break;
                    }
                    case LOCK_DENIED: {
                        this.handleLockDeniedResponse(req.lock_name, req.lock_id, req.owner);
                        break;
                    }
                    case CREATE_LOCK: {
                        this.handleCreateLockRequest(req.lock_name, req.owner);
                        break;
                    }
                    case DELETE_LOCK: {
                        this.handleDeleteLockRequest(req.lock_name);
                        break;
                    }
                    case COND_SIG: 
                    case COND_SIG_ALL: {
                        this.handleSignalRequest(req);
                        break;
                    }
                    case LOCK_AWAIT: {
                        this.handleAwaitRequest(req.lock_name, req.owner);
                        this.handleLockRequest(req);
                        break;
                    }
                    case DELETE_LOCK_AWAIT: {
                        this.handleDeleteAwaitRequest(req.lock_name, req.owner);
                        break;
                    }
                    case SIG_RET: {
                        this.handleSignalResponse(req.lock_name, req.owner);
                        break;
                    }
                    case CREATE_AWAITER: {
                        this.handleCreateAwaitingRequest(req.lock_name, req.owner);
                        break;
                    }
                    case DELETE_AWAITER: {
                        this.handleDeleteAwaitingRequest(req.lock_name, req.owner);
                        break;
                    }
                    default: {
                        this.log.error("Request of type %s not known", new Object[]{req.type});
                    }
                }
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected ClientLock getLock(String name) {
        return this.client_lock_table.getLock(name, this.getOwner(), true);
    }

    protected ClientLock getLock(String name, boolean create_if_absent) {
        return this.client_lock_table.getLock(name, this.getOwner(), create_if_absent);
    }

    @ManagedOperation(description="Unlocks all currently held locks")
    public void unlockAll() {
        this.client_lock_table.unlockAll();
    }

    @ManagedOperation(description="Dumps all locks")
    public String printLocks() {
        StringBuilder sb = new StringBuilder();
        sb.append("server locks:\n");
        for (Map.Entry entry : this.server_locks.entrySet()) {
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("\nmy locks: ").append(this.client_lock_table.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleView(View view) {
        this.view = view;
        this.log.debug("view=%s", view);
        List<Address> members = view.getMembers();
        ArrayList<Response> responses = new ArrayList<Response>();
        for (Map.Entry entry : this.server_locks.entrySet()) {
            String lock_name = (String)entry.getKey();
            ServerLock server_lock = (ServerLock)entry.getValue();
            Lock lock = this._getLock(lock_name);
            lock.lock();
            try {
                Response rsp = server_lock.handleView(members);
                if (rsp != null) {
                    responses.add(rsp);
                }
                if (!server_lock.isEmpty() || server_lock.current_owner != null || !server_lock.condition.queue.isEmpty()) continue;
                this.server_locks.remove(lock_name);
            }
            finally {
                lock.unlock();
            }
        }
        for (Response rsp : responses) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    protected ClientLock createLock(String lock_name, Owner owner) {
        return new ClientLock(lock_name, owner);
    }

    protected Lock _getLock(String lock_name) {
        int index = lock_name != null ? Math.abs(lock_name.hashCode() % this.lock_stripes.length) : 0;
        return this.lock_stripes[index];
    }

    protected Owner getOwner() {
        return new Owner(this.local_addr, Thread.currentThread().getId());
    }

    protected abstract void sendGrantLockRequest(String var1, int var2, Owner var3, long var4, boolean var6);

    protected abstract void sendReleaseLockRequest(String var1, Owner var2);

    protected abstract void sendAwaitConditionRequest(String var1, Owner var2);

    protected abstract void sendSignalConditionRequest(String var1, boolean var2);

    protected abstract void sendDeleteAwaitConditionRequest(String var1, Owner var2);

    protected void sendRequest(Address dest, Type type, String lock_name, Owner owner, long timeout, boolean is_trylock) {
        this.send(dest, new Request(type, lock_name, owner, timeout, is_trylock));
    }

    protected void sendRequest(Address dest, Type type, String lock_name, int lock_id, Owner owner, long timeout, boolean is_trylock) {
        this.send(dest, new Request(type, lock_name, owner, timeout, is_trylock).lockId(lock_id));
    }

    protected void sendLockResponse(Type type, Owner dest, String lock_name, int lock_id) {
        this.send(dest.getAddress(), new Request(type, lock_name, dest, 0L).lockId(lock_id));
    }

    protected void sendSignalResponse(Owner dest, String lock_name) {
        this.send(dest.getAddress(), new Request(Type.SIG_RET, lock_name, dest, 0L));
    }

    protected void send(Address dest, Request req) {
        Message msg = new Message(dest, Util.streamableToBuffer(req)).putHeader(this.id, new LockingHeader());
        if (this.bypass_bundling) {
            msg.setFlag(Message.Flag.DONT_BUNDLE);
        }
        this.log.trace("[%s] --> %s] %s", this.local_addr, dest == null ? "ALL" : dest, req);
        try {
            this.down_prot.down(new Event(1, msg));
        }
        catch (Exception ex) {
            this.log.error("failed sending %s request: %s", new Object[]{req.type, ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLockRequest(Request req) {
        Response rsp = null;
        Lock lock = this._getLock(req.lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(req.lock_name);
            if (server_lock == null) {
                server_lock = new ServerLock(req.lock_name);
                ServerLock tmp = this.server_locks.putIfAbsent(req.lock_name, server_lock);
                if (tmp != null) {
                    server_lock = tmp;
                } else {
                    this.notifyLockCreated(req.lock_name);
                }
            }
            rsp = server_lock.handleRequest(req);
            if (server_lock.isEmpty() && server_lock.current_owner == null && server_lock.condition.queue.isEmpty()) {
                this.server_locks.remove(req.lock_name);
            }
        }
        finally {
            lock.unlock();
        }
        if (rsp != null) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    protected void handleLockGrantedResponse(String lock_name, int lock_id, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.handleLockGrantedResponse(lock_id);
        }
    }

    protected void handleLockDeniedResponse(String lock_name, int lock_id, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.lockDenied(lock_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAwaitRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.addWaiter(owner);
            } else {
                this.log.error(Util.getMessage("ConditionAwaitWasReceivedButLockWasNotCreatedWaiterMayBlockForever"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteAwaitRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.removeWaiter(owner);
            } else {
                this.log.error(Util.getMessage("ConditionAwaitDeleteWasReceivedButLockWasGone"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void handleSignalResponse(String lock_name, Owner owner) {
        ClientLock lock = this.client_lock_table.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.condition.signaled();
        } else {
            this.log.error(Util.getMessage("ConditionResponseWasClientLockWasNotPresentIgnoredSignal"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSignalRequest(Request req) {
        Response rsp = null;
        Lock lock = this._getLock(req.lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(req.lock_name);
            if (server_lock != null) {
                rsp = server_lock.handleRequest(req);
            } else {
                this.log.error(Util.getMessage("ConditionSignalWasReceivedButLockWasNotCreatedCouldnTNotifyAnyone"));
            }
        }
        finally {
            lock.unlock();
        }
        if (rsp != null) {
            this.sendLockResponse(rsp.type, rsp.owner, rsp.lock_name, rsp.lock_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateLockRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            this.server_locks.put(lock_name, new ServerLock(lock_name, owner));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteLockRequest(String lock_name) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock == null) {
                return;
            }
            if (server_lock.condition.queue.isEmpty()) {
                this.server_locks.remove(lock_name);
            } else {
                server_lock.current_owner = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateAwaitingRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock tmp;
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock == null && (tmp = this.server_locks.putIfAbsent(lock_name, server_lock = new ServerLock(lock_name))) != null) {
                server_lock = tmp;
            }
            server_lock.condition.queue.add(owner);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteAwaitingRequest(String lock_name, Owner owner) {
        Lock lock = this._getLock(lock_name);
        lock.lock();
        try {
            ServerLock server_lock = (ServerLock)this.server_locks.get(lock_name);
            if (server_lock != null) {
                server_lock.condition.queue.remove(owner);
                if (server_lock.condition.queue.isEmpty() && server_lock.current_owner == null) {
                    this.server_locks.remove(lock_name);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void notifyLockCreated(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockCreated(lock_name);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    protected void notifyLockDeleted(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockDeleted(lock_name);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    protected void notifyLocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.locked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    protected void notifyUnlocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.unlocked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    protected void notifyAwaiting(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaiting(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    protected void notifyAwaited(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaited(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying %s: %s", listener, t.toString());
            }
        }
    }

    public static class LockingHeader
    extends Header {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
        }
    }

    protected static class Response {
        protected final Type type;
        protected final Owner owner;
        protected final String lock_name;
        protected final int lock_id;

        public Response(Type type, Owner owner, String lock_name, int lock_id) {
            this.type = type;
            this.owner = owner;
            this.lock_name = lock_name;
            this.lock_id = lock_id;
        }
    }

    protected static class Request
    implements Streamable {
        protected Type type;
        protected String lock_name;
        protected int lock_id;
        protected Owner owner;
        protected long timeout;
        protected boolean is_trylock;

        public Request() {
        }

        public Request(Type type, String lock_name, Owner owner, long timeout) {
            this.type = type;
            this.lock_name = lock_name;
            this.owner = owner;
            this.timeout = timeout;
        }

        public Request(Type type, String lock_name, Owner owner, long timeout, boolean is_trylock) {
            this(type, lock_name, owner, timeout);
            this.is_trylock = is_trylock;
        }

        public Request lockId(int lock_id) {
            this.lock_id = lock_id;
            return this;
        }

        public int lockId() {
            return this.lock_id;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type.ordinal());
            Bits.writeString(this.lock_name, out);
            out.writeInt(this.lock_id);
            Util.writeStreamable(this.owner, out);
            out.writeLong(this.timeout);
            out.writeBoolean(this.is_trylock);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = Type.values()[in.readByte()];
            this.lock_name = Bits.readString(in);
            this.lock_id = in.readInt();
            this.owner = (Owner)Util.readStreamable(Owner.class, in);
            this.timeout = in.readLong();
            this.is_trylock = in.readBoolean();
        }

        public String toString() {
            return this.type.name() + " [" + this.lock_name + ", lock_id=" + this.lock_id + ", owner=" + this.owner + (this.is_trylock ? ", trylock " : " ") + (this.timeout > 0L ? "(timeout=" + this.timeout + ")" : "]");
        }

        public String toStringShort() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case RELEASE_LOCK: {
                    sb.append("U");
                    break;
                }
                case GRANT_LOCK: {
                    sb.append(this.is_trylock ? "TL" : "L");
                    break;
                }
                default: {
                    sb.append("N/A");
                }
            }
            sb.append("(").append(this.lock_name).append(",").append(this.owner);
            if (this.timeout > 0L) {
                sb.append(",").append(this.timeout);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    protected class ClientCondition
    implements Condition {
        protected final ClientLock lock;
        protected final AtomicBoolean signaled = new AtomicBoolean(false);
        protected volatile AtomicReference<Thread> parker = new AtomicReference();

        public ClientCondition(ClientLock lock) {
            this.lock = lock;
        }

        @Override
        public void await() throws InterruptedException {
            InterruptedException ex = null;
            try {
                this.await(true);
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitUninterruptibly() {
            try {
                this.await(false);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.lock();
            }
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            InterruptedException ex = null;
            try {
                long l = this.await(nanosTimeout);
                return l;
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.awaitNanos(unit.toNanos(time)) > 0L;
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            long currentTime;
            long waitUntilTime = deadline.getTime();
            long waitTime = waitUntilTime - (currentTime = System.currentTimeMillis());
            if (waitTime > 0L) {
                return this.await(waitTime, TimeUnit.MILLISECONDS);
            }
            return false;
        }

        protected void await(boolean throwInterrupt) throws InterruptedException {
            if (!this.signaled.get()) {
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get()) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.signaled.set(false);
        }

        protected long await(long nanoSeconds) throws InterruptedException {
            long start = System.nanoTime();
            if (!this.signaled.get()) {
                long wait_nano;
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get() && (wait_nano = nanoSeconds - (System.nanoTime() - start)) > 0L) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.parkNanos(this, wait_nano);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.signaled.getAndSet(false)) {
                Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
            }
            return nanoSeconds - (System.nanoTime() - start);
        }

        @Override
        public void signal() {
            Locking.this.sendSignalConditionRequest(this.lock.name, false);
        }

        @Override
        public void signalAll() {
            Locking.this.sendSignalConditionRequest(this.lock.name, true);
        }

        protected void signaled() {
            this.signaled.set(true);
            Thread thread = this.parker.getAndSet(null);
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }
    }

    protected class ClientLockTable {
        protected final ConcurrentMap<String, Map<Owner, ClientLock>> table = Util.createConcurrentMap(20);

        protected ClientLockTable() {
        }

        protected synchronized ClientLock getLock(String name, Owner owner, boolean create_if_absent) {
            ClientLock lock;
            Map<Owner, ClientLock> owners = (HashMap<Owner, ClientLock>)this.table.get(name);
            if (owners == null) {
                if (!create_if_absent) {
                    return null;
                }
                owners = new HashMap<Owner, ClientLock>();
                Map existing = this.table.putIfAbsent(name, owners);
                if (existing != null) {
                    owners = existing;
                }
            }
            if ((lock = (ClientLock)owners.get(owner)) == null) {
                if (!create_if_absent) {
                    return null;
                }
                lock = Locking.this.createLock(name, owner);
                owners.put(owner, lock);
            }
            return lock;
        }

        protected synchronized void removeClientLock(String lock_name, Owner owner) {
            ClientLock lock;
            Map owners = (Map)this.table.get(lock_name);
            if (owners != null && (lock = (ClientLock)owners.remove(owner)) != null && owners.isEmpty()) {
                this.table.remove(lock_name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unlockAll() {
            ArrayList lock_list = new ArrayList();
            ClientLockTable clientLockTable = this;
            synchronized (clientLockTable) {
                Collection maps = this.table.values();
                for (Map map : maps) {
                    lock_list.addAll(map.values());
                }
            }
            for (ClientLock lock : lock_list) {
                lock.unlock();
            }
        }

        protected void resendPendingLockRequests() {
            if (!this.table.isEmpty()) {
                for (Map map : this.table.values()) {
                    for (ClientLock lock : map.values()) {
                        if (lock.acquired || lock.denied) continue;
                        Locking.this.sendGrantLockRequest(lock.name, lock.lock_id, lock.owner, lock.timeout, lock.is_trylock);
                    }
                }
            }
        }

        protected synchronized Collection<Map<Owner, ClientLock>> values() {
            return this.table.values();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first_element = true;
            for (Map.Entry entry : this.table.entrySet()) {
                if (first_element) {
                    first_element = false;
                } else {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey()).append(" (");
                Map owners = (Map)entry.getValue();
                boolean first = true;
                for (Map.Entry entry2 : owners.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(entry2.getKey());
                    ClientLock cl = (ClientLock)entry2.getValue();
                    if (cl.acquired && !cl.denied) continue;
                    sb.append(", unlocked");
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }

    protected class ClientLock
    implements Lock {
        protected final String name;
        protected Owner owner;
        protected volatile boolean acquired;
        protected volatile boolean denied;
        protected volatile boolean is_trylock;
        protected long timeout;
        protected final ClientCondition condition;
        protected final int lock_id = current_lock_id.getAndIncrement();

        public ClientLock(String name) {
            this.name = name;
            this.condition = new ClientCondition(this);
        }

        public ClientLock(String name, Owner owner) {
            this(name);
            this.owner = owner;
        }

        @Override
        public void lock() {
            try {
                this.acquire(false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.acquire(true);
        }

        @Override
        public boolean tryLock() {
            try {
                return this.acquireTryLock(0L, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.acquireTryLock(TimeUnit.MILLISECONDS.convert(time, unit), true);
        }

        @Override
        public synchronized void unlock() {
            this._unlock(false);
        }

        @Override
        public Condition newCondition() {
            return this.condition;
        }

        public String toString() {
            return this.name + " (id=" + this.lock_id + ", locked=" + this.acquired + ")";
        }

        protected synchronized void lockGranted(int lock_id) {
            if (this.lock_id != lock_id) {
                Locking.this.log.error(Util.getMessage("DiscardedLOCKGRANTEDResponseWithLockId") + lock_id + ", my lock-id=" + this.lock_id);
                return;
            }
            this.acquired = true;
            this.notifyAll();
        }

        protected synchronized void lockDenied(int lock_id) {
            if (this.lock_id != lock_id) {
                Locking.this.log.error(Util.getMessage("DiscardedLOCKDENIEDResponseWithLockId") + lock_id + ", my lock_id=" + this.lock_id);
                return;
            }
            this.denied = true;
            this.notifyAll();
        }

        protected void handleLockGrantedResponse(int lock_id) {
            this.lockGranted(lock_id);
        }

        protected synchronized void acquire(boolean throwInterrupt) throws InterruptedException {
            if (this.acquired) {
                return;
            }
            if (throwInterrupt && Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.owner = Locking.this.getOwner();
            Locking.this.sendGrantLockRequest(this.name, this.lock_id, this.owner, 0L, false);
            boolean interrupted = false;
            while (!this.acquired) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (throwInterrupt && !this.acquired) {
                        this._unlock(true);
                        throw e;
                    }
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        protected synchronized void _unlock(boolean force) {
            if (!(this.acquired || this.denied || force)) {
                return;
            }
            this.timeout = 0L;
            this.is_trylock = false;
            if (!this.denied) {
                Locking.this.sendReleaseLockRequest(this.name, this.owner);
            }
            this.denied = false;
            this.acquired = false;
            this.notifyAll();
            Locking.this.client_lock_table.removeClientLock(this.name, this.owner);
            Locking.this.notifyLockDeleted(this.name);
            this.owner = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized boolean acquireTryLock(long timeout, boolean use_timeout) throws InterruptedException {
            boolean retval;
            if (this.denied) {
                return false;
            }
            if (!this.acquired) {
                if (use_timeout && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.is_trylock = true;
                this.timeout = timeout;
                if (this.owner == null) {
                    this.owner = Locking.this.getOwner();
                }
                Locking.this.sendGrantLockRequest(this.name, this.lock_id, this.owner, timeout, true);
                boolean interrupted = false;
                block8: while (!this.acquired && !this.denied) {
                    if (use_timeout) {
                        long timeout_ns;
                        long wait_time = timeout_ns = TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
                        long start = System.nanoTime();
                        while (wait_time > 0L && !this.acquired && !this.denied) {
                            try {
                                long wait_ms = TimeUnit.MILLISECONDS.convert(wait_time, TimeUnit.NANOSECONDS);
                                if (wait_ms <= 0L) break block8;
                                this.wait(wait_ms);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            finally {
                                wait_time = timeout_ns - (System.nanoTime() - start);
                                this.timeout = TimeUnit.MILLISECONDS.convert(wait_time, TimeUnit.NANOSECONDS);
                            }
                        }
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = retval = this.acquired && !this.denied;
            if (!this.acquired || this.denied) {
                this._unlock(true);
            }
            return retval;
        }
    }

    protected class ServerCondition {
        protected final ServerLock lock;
        protected final Queue<Owner> queue = new ArrayDeque<Owner>();

        public ServerCondition(ServerLock lock) {
            this.lock = lock;
        }

        public void addWaiter(Owner waiter) {
            Locking.this.notifyAwaiting(this.lock.lock_name, waiter);
            Locking.this.log.trace("Waiter [%s] was added for %s", waiter, this.lock.lock_name);
            this.queue.add(waiter);
        }

        public void removeWaiter(Owner waiter) {
            Locking.this.notifyAwaited(this.lock.lock_name, waiter);
            Locking.this.log.trace("Waiter [%s] was removed for %s", waiter, this.lock.lock_name);
            this.queue.remove(waiter);
        }

        public void signal(boolean all) {
            if (this.queue.isEmpty()) {
                Locking.this.log.trace("Signal for [%s] ignored since, no one is waiting in queue", this.lock.lock_name);
            }
            if (all) {
                Owner entry;
                while ((entry = this.queue.poll()) != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    Locking.this.log.trace("Signalled %s for %s", entry, this.lock.lock_name);
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            } else {
                Owner entry = this.queue.poll();
                if (entry != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    Locking.this.log.trace("Signalled %s for %s", entry, this.lock.lock_name);
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            }
        }
    }

    protected class ServerLock {
        protected final String lock_name;
        protected Owner current_owner;
        protected final List<Request> queue = new ArrayList<Request>();
        protected final ServerCondition condition;

        public ServerLock(String lock_name) {
            this.lock_name = lock_name;
            this.condition = new ServerCondition(this);
        }

        protected ServerLock(String lock_name, Owner owner) {
            this.lock_name = lock_name;
            this.current_owner = owner;
            this.condition = new ServerCondition(this);
        }

        protected Response handleRequest(Request req) {
            switch (req.type) {
                case GRANT_LOCK: {
                    if (this.current_owner == null) {
                        this.setOwner(req.owner);
                        return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
                    }
                    if (this.current_owner.equals(req.owner)) {
                        return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
                    }
                    if (req.is_trylock && req.timeout <= 0L) {
                        return new Response(Type.LOCK_DENIED, req.owner, req.lock_name, req.lock_id);
                    }
                    this.addToQueue(req);
                    break;
                }
                case RELEASE_LOCK: 
                case LOCK_AWAIT: {
                    if (this.current_owner == null) break;
                    if (this.current_owner.equals(req.owner)) {
                        this.setOwner(null);
                        break;
                    }
                    this.addToQueue(req);
                    break;
                }
                case COND_SIG: {
                    this.condition.signal(false);
                    break;
                }
                case COND_SIG_ALL: {
                    this.condition.signal(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type " + (Object)((Object)req.type) + " is invalid here");
                }
            }
            return this.processQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Response handleView(List<Address> members) {
            Object tmp;
            if (this.current_owner != null && !members.contains(this.current_owner.getAddress())) {
                tmp = this.current_owner;
                this.setOwner(null);
                Locking.this.log.debug("unlocked \"%s\" because owner %s left", this.lock_name, tmp);
            }
            tmp = this.queue;
            synchronized (tmp) {
                Iterator<Request> it = this.queue.iterator();
                while (it.hasNext()) {
                    Request req = it.next();
                    if (members.contains(req.owner.getAddress())) continue;
                    it.remove();
                }
            }
            Iterator it = this.condition.queue.iterator();
            while (it.hasNext()) {
                Owner own = (Owner)it.next();
                if (members.contains(own.getAddress())) continue;
                it.remove();
            }
            return this.processQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToQueue(Request req) {
            List<Request> list = this.queue;
            synchronized (list) {
                if (this.queue.isEmpty()) {
                    if (req.type == Type.GRANT_LOCK) {
                        this.queue.add(req);
                    }
                    return;
                }
            }
            switch (req.type) {
                case GRANT_LOCK: {
                    list = this.queue;
                    synchronized (list) {
                        if (!this.isRequestPresent(Type.GRANT_LOCK, req.owner)) {
                            this.queue.add(req);
                        }
                        break;
                    }
                }
                case RELEASE_LOCK: {
                    this.removeRequest(Type.GRANT_LOCK, req.owner);
                }
            }
        }

        protected boolean isRequestPresent(Type type, Owner owner) {
            for (Request req : this.queue) {
                if (req.type != type || !req.owner.equals(owner)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeRequest(Type type, Owner owner) {
            List<Request> list = this.queue;
            synchronized (list) {
                Iterator<Request> it = this.queue.iterator();
                while (it.hasNext()) {
                    Request req = it.next();
                    if (req.type != type || !req.owner.equals(owner)) continue;
                    it.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request getNextRequest() {
            List<Request> list = this.queue;
            synchronized (list) {
                return !this.queue.isEmpty() ? this.queue.remove(0) : null;
            }
        }

        protected Response processQueue() {
            Request req;
            if (this.current_owner != null) {
                return null;
            }
            while ((req = this.getNextRequest()) != null) {
                if (req.type != Type.GRANT_LOCK) continue;
                this.setOwner(req.owner);
                return new Response(Type.LOCK_GRANTED, req.owner, req.lock_name, req.lock_id);
            }
            return null;
        }

        protected void setOwner(Owner owner) {
            if (owner == null) {
                if (this.current_owner != null) {
                    Owner tmp = this.current_owner;
                    this.current_owner = null;
                    Locking.this.notifyUnlocked(this.lock_name, tmp);
                }
            } else {
                this.current_owner = owner;
                Locking.this.notifyLocked(this.lock_name, owner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            List<Request> list = this.queue;
            synchronized (list) {
                return this.queue.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.current_owner);
            List<Request> list = this.queue;
            synchronized (list) {
                if (!this.queue.isEmpty()) {
                    sb.append(", queue: ");
                    for (Request req : this.queue) {
                        sb.append(req.toStringShort()).append(" ");
                    }
                }
            }
            return sb.toString();
        }
    }

    protected static enum Type {
        GRANT_LOCK,
        LOCK_GRANTED,
        LOCK_DENIED,
        RELEASE_LOCK,
        CREATE_LOCK,
        DELETE_LOCK,
        LOCK_AWAIT,
        COND_SIG,
        COND_SIG_ALL,
        SIG_RET,
        DELETE_LOCK_AWAIT,
        CREATE_AWAITER,
        DELETE_AWAITER;

    }
}

