/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.BaseBundler;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;

public class TransferQueueBundler
extends BaseBundler
implements Runnable {
    protected BlockingQueue<Message> queue;
    protected List<Message> remove_queue;
    protected volatile Thread bundler_thread;
    protected volatile boolean running = true;
    protected static final String THREAD_NAME = "TransferQueueBundler";

    public TransferQueueBundler() {
        this.remove_queue = new ArrayList<Message>(16);
    }

    protected TransferQueueBundler(BlockingQueue<Message> queue) {
        this.queue = queue;
        this.remove_queue = new ArrayList<Message>(16);
    }

    public TransferQueueBundler(int capacity) {
        this(new ArrayBlockingQueue<Message>(TransferQueueBundler.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    public Thread getThread() {
        return this.bundler_thread;
    }

    public int getBufferSize() {
        return this.queue.size();
    }

    public int removeQueueSize() {
        return this.remove_queue.size();
    }

    public TransferQueueBundler removeQueueSize(int size) {
        this.remove_queue = new ArrayList<Message>(size);
        return this;
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        if (this.queue == null) {
            this.queue = new ArrayBlockingQueue<Message>(TransferQueueBundler.assertPositive(transport.getBundlerCapacity(), "bundler capacity cannot be " + transport.getBundlerCapacity()));
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.bundler_thread = this.transport.getThreadFactory().newThread(this, THREAD_NAME);
        this.running = true;
        this.bundler_thread.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.bundler_thread;
        this.bundler_thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.queue.clear();
    }

    @Override
    public int size() {
        return super.size() + this.removeQueueSize() + this.getBufferSize();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (this.running) {
            this.queue.put(msg);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = this.queue.take();
                if (msg == null) continue;
                long size = msg.size();
                if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
                    this.sendBundledMessages();
                }
                this.addMessage(msg, size);
                block3: while (true) {
                    this.remove_queue.clear();
                    int num_msgs = this.queue.drainTo(this.remove_queue);
                    if (num_msgs <= 0) break;
                    int i = 0;
                    while (true) {
                        if (i >= this.remove_queue.size()) continue block3;
                        msg = this.remove_queue.get(i);
                        size = msg.size();
                        if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
                            this.sendBundledMessages();
                        }
                        this.addMessage(msg, size);
                        ++i;
                    }
                    break;
                }
                if (this.count <= 0L) continue;
                this.sendBundledMessages();
            }
            catch (Throwable throwable) {}
        }
    }

    protected static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

