/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CheckToaOrder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        if (args.length == 0) {
            System.err.println("usage: [-threads value] <files...>");
            System.exit(1);
        }
        int numberOfThreads = 2;
        int startIdx = 0;
        if (args[0].equals("-threads")) {
            startIdx = 2;
            try {
                numberOfThreads = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.err.println("Error parsing number of threads: " + e.getLocalizedMessage());
                numberOfThreads = 2;
            }
            finally {
                if (numberOfThreads < 1) {
                    numberOfThreads = 2;
                }
            }
        }
        System.out.println("--------------------------------------------------------------------");
        System.out.println("----------------------- CHECK TOA ORDER ----------------------------");
        System.out.println("--------------------------------------------------------------------");
        System.out.println("analyze " + CheckToaOrder.printArgs(args) + " using " + numberOfThreads + " threads");
        ComparingFiles[] threads = new ComparingFiles[numberOfThreads];
        LinkedList<Pair> allCombinations = new LinkedList<Pair>();
        for (int x = startIdx; x < args.length; ++x) {
            for (int y = x + 1; y < args.length; ++y) {
                if (x == y) continue;
                allCombinations.add(new Pair(x, y));
            }
        }
        System.out.println("Collection for the threads is " + allCombinations);
        Iterator iterator = allCombinations.iterator();
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new ComparingFiles(iterator, args, "Comparator-" + i);
            threads[i].start();
        }
        for (ComparingFiles comparingFiles : threads) {
            comparingFiles.join();
        }
        System.out.println("=========== FINISHED! ==============");
    }

    private static String printArgs(String[] args) {
        StringBuilder sb = new StringBuilder(args[0]);
        for (int i = 1; i < args.length; ++i) {
            sb.append(",").append(args[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareFiles(String filePath1, String filePath2, List<String> messageDeliverOrder) {
        System.out.println("Comparing " + filePath1 + " and " + filePath2 + " by thread " + Thread.currentThread().getName());
        try {
            String message;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath1));
            while ((message = bufferedReader.readLine()) != null) {
                messageDeliverOrder.add(message);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new FileReader(filePath2));
            int msgExpectedIdx = 0;
            while ((message = bufferedReader.readLine()) != null) {
                if (msgExpectedIdx >= messageDeliverOrder.size()) {
                    messageDeliverOrder.add(message);
                    ++msgExpectedIdx;
                    continue;
                }
                String otherMessage = messageDeliverOrder.get(msgExpectedIdx);
                if (otherMessage.equals(message)) {
                    ++msgExpectedIdx;
                    continue;
                }
                int realMsgIdx = messageDeliverOrder.indexOf(message);
                if (realMsgIdx == -1) continue;
                if (realMsgIdx < msgExpectedIdx) {
                    System.err.println("[" + Thread.currentThread().getName() + "] Message deliver out of order: " + message);
                }
                msgExpectedIdx = realMsgIdx + 1;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("Finished comparing this files");
        }
    }

    private static class ComparingFiles
    extends Thread {
        private final Iterator<Pair> filesToCompare;
        private ArrayList<String> messageDeliverOrder = new ArrayList();
        private String[] args;

        private ComparingFiles(Iterator<Pair> filesToCompare, String[] args, String threadName) {
            super(threadName);
            this.filesToCompare = filesToCompare;
            this.args = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Pair p;
                Iterator<Pair> iterator = this.filesToCompare;
                synchronized (iterator) {
                    if (!this.filesToCompare.hasNext()) {
                        break;
                    }
                    p = this.filesToCompare.next();
                }
                CheckToaOrder.compareFiles(this.args[p.getX()], this.args[p.getY()], this.messageDeliverOrder);
                int size = this.messageDeliverOrder.size();
                this.messageDeliverOrder.clear();
                this.messageDeliverOrder.ensureCapacity(size);
            }
            System.out.println(this.getName() + " finished!");
        }
    }

    private static class Pair {
        private final int x;
        private final int y;

        private Pair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "Pair{y=" + this.y + ", x=" + this.x + '}';
        }
    }
}

