/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Metadata;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallHeaders;

public class MetadataAdapter
implements CallHeaders {
    private final Metadata metadata;

    public MetadataAdapter(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public String get(String key) {
        return this.metadata.get(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER));
    }

    @Override
    public byte[] getByte(String key) {
        if (key.endsWith("-bin")) {
            return this.metadata.get(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER));
        }
        return this.get(key).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Iterable<String> getAll(String key) {
        return this.metadata.getAll(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER));
    }

    @Override
    public Iterable<byte[]> getAllByte(String key) {
        if (key.endsWith("-bin")) {
            return this.metadata.getAll(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER));
        }
        return StreamSupport.stream(this.getAll(key).spliterator(), false).map(String::getBytes).collect(Collectors.toList());
    }

    @Override
    public void insert(String key, String value) {
        this.metadata.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
    }

    @Override
    public void insert(String key, byte[] value) {
        this.metadata.put(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER), value);
    }

    @Override
    public Set<String> keys() {
        return new HashSet<String>(this.metadata.keys());
    }

    @Override
    public boolean containsKey(String key) {
        if (key.endsWith("-bin")) {
            Metadata.Key<byte[]> grpcKey = Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER);
            return this.metadata.containsKey(grpcKey);
        }
        Metadata.Key<String> grpcKey = Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER);
        return this.metadata.containsKey(grpcKey);
    }

    public String toString() {
        return this.metadata.toString();
    }
}

