/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.AlgorithmNameFinder;

public class DefaultAlgorithmNameFinder
implements AlgorithmNameFinder {
    private static final Map algorithms = new HashMap();

    private static void addAlgorithm(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (algorithms.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalStateException("algOid already present in addAlgorithm");
        }
        algorithms.put(aSN1ObjectIdentifier, string);
    }

    @Override
    public boolean hasAlgorithmName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return algorithms.containsKey(aSN1ObjectIdentifier);
    }

    @Override
    public String getAlgorithmName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = (String)algorithms.get(aSN1ObjectIdentifier);
        return string != null ? string : aSN1ObjectIdentifier.getId();
    }

    @Override
    public String getAlgorithmName(AlgorithmIdentifier algorithmIdentifier) {
        return this.getAlgorithmName(algorithmIdentifier.getAlgorithm());
    }

    public Set<ASN1ObjectIdentifier> getOIDSet() {
        return algorithms.keySet();
    }

    static {
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_RIPEMD160, "RIPEMD160WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_SHA1, "SHA1WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_SHA224, "SHA224WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_SHA256, "SHA256WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_SHA384, "SHA384WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BSIObjectIdentifiers.ecdsa_plain_SHA512, "SHA512WITHPLAIN-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410-2001");
        DefaultAlgorithmNameFinder.addAlgorithm(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410-94");
        DefaultAlgorithmNameFinder.addAlgorithm(CryptoProObjectIdentifiers.gostR3411, "GOST3411");
        DefaultAlgorithmNameFinder.addAlgorithm(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, "GOST3411WITHECGOST3410-2012-256");
        DefaultAlgorithmNameFinder.addAlgorithm(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, "GOST3411WITHECGOST3410-2012-512");
        DefaultAlgorithmNameFinder.addAlgorithm(EACObjectIdentifiers.id_TA_ECDSA_SHA_1, "SHA1WITHCVC-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(EACObjectIdentifiers.id_TA_ECDSA_SHA_224, "SHA224WITHCVC-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(EACObjectIdentifiers.id_TA_ECDSA_SHA_256, "SHA256WITHCVC-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(EACObjectIdentifiers.id_TA_ECDSA_SHA_384, "SHA384WITHCVC-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(EACObjectIdentifiers.id_TA_ECDSA_SHA_512, "SHA512WITHCVC-ECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.falcon_512, "FALCON");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.falcon_1024, "FALCON");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, "LMS");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ml_dsa_44, "ML-DSA-44");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ml_dsa_65, "ML-DSA-65");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ml_dsa_87, "ML-DSA-87");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_ml_dsa_44_with_sha512, "ML-DSA-44-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_ml_dsa_65_with_sha512, "ML-DSA-65-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_ml_dsa_87_with_sha512, "ML-DSA-87-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_128s, "SLH-DSA-SHA2-128S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_128f, "SLH-DSA-SHA2-128F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_192s, "SLH-DSA-SHA2-192S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_192f, "SLH-DSA-SHA2-192F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_256s, "SLH-DSA-SHA2-256S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_sha2_256f, "SLH-DSA-SHA2-256F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_128s, "SLH-DSA-SHAKE-128S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_128f, "SLH-DSA-SHAKE-128F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_192s, "SLH-DSA-SHAKE-192S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_192f, "SLH-DSA-SHAKE-192F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_256s, "SLH-DSA-SHAKE-256S");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_slh_dsa_shake_256f, "SLH-DSA-SHAKE-256F");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_128s_with_sha256, "SLH-DSA-SHA2-128S-WITH-SHA256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_128f_with_sha256, "SLH-DSA-SHA2-128F-WITH-SHA256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_192s_with_sha512, "SLH-DSA-SHA2-192S-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_192f_with_sha512, "SLH-DSA-SHA2-192F-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_256s_with_sha512, "SLH-DSA-SHA2-256S-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_sha2_256f_with_sha512, "SLH-DSA-SHA2-256F-WITH-SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_128s_with_shake128, "SLH-DSA-SHAKE-128S-WITH-SHAKE128");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_128f_with_shake128, "SLH-DSA-SHAKE-128F-WITH-SHAKE128");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_192s_with_shake256, "SLH-DSA-SHAKE-192S-WITH-SHAKE256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_192f_with_shake256, "SLH-DSA-SHAKE-192F-WITH-SHAKE256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_256s_with_shake256, "SLH-DSA-SHAKE-256S-WITH-SHAKE256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_hash_slh_dsa_shake_256f_with_shake256, "SLH-DSA-SHAKE-256F-WITH-SHAKE256");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, "SPHINCS+");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha224, "SHA224");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha256, "SHA256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha384, "SHA384");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha512, "SHA512");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha3_224, "SHA3-224");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha3_256, "SHA3-256");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha3_384, "SHA3-384");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_sha3_512, "SHA3-512");
        DefaultAlgorithmNameFinder.addAlgorithm(OIWObjectIdentifiers.dsaWithSHA1, "SHA1WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(OIWObjectIdentifiers.elGamalAlgorithm, "ELGAMAL");
        DefaultAlgorithmNameFinder.addAlgorithm(OIWObjectIdentifiers.idSHA1, "SHA1");
        DefaultAlgorithmNameFinder.addAlgorithm(OIWObjectIdentifiers.md5WithRSA, "MD5WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.id_RSAES_OAEP, "RSAOAEP");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.id_RSASSA_PSS, "RSAPSS");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.md5, "MD5");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, "SHA3-224WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, "SHA3-256WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, "SHA3-384WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, "SHA3-512WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128, "RIPEMD128WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160, "RIPEMD160WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256, "RIPEMD256WITHRSA");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA1, "ECDSAWITHSHA1");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, "SHA3-224WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, "SHA3-256WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, "SHA3-384WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, "SHA3-512WITHECDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.dsa_with_sha224, "SHA224WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.dsa_with_sha256, "SHA256WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.dsa_with_sha384, "SHA384WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.dsa_with_sha512, "SHA512WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_dsa_with_sha3_224, "SHA3-224WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_dsa_with_sha3_256, "SHA3-256WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_dsa_with_sha3_384, "SHA3-384WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_dsa_with_sha3_512, "SHA3-512WITHDSA");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Tiger_192, "Tiger");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.RC2_CBC, "RC2/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(PKCSObjectIdentifiers.des_EDE3_CBC, "DESEDE-3KEY/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes128_ECB, "AES-128/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes192_ECB, "AES-192/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes256_ECB, "AES-256/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes128_CBC, "AES-128/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes192_CBC, "AES-192/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes256_CBC, "AES-256/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes128_CFB, "AES-128/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes192_CFB, "AES-192/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes256_CFB, "AES-256/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes128_OFB, "AES-128/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes192_OFB, "AES-192/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NISTObjectIdentifiers.id_aes256_OFB, "AES-256/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA-128/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA-192/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA-256/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(KISAObjectIdentifiers.id_seedCBC, "SEED/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, "IDEA/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.cast5CBC, "CAST5/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB, "Blowfish/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "Blowfish/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB, "Blowfish/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB, "Blowfish/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_128_ECB, "Serpent-128/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_128_CBC, "Serpent-128/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_128_CFB, "Serpent-128/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_128_OFB, "Serpent-128/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_192_ECB, "Serpent-192/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_192_CBC, "Serpent-192/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_192_CFB, "Serpent-192/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_192_OFB, "Serpent-192/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_256_ECB, "Serpent-256/ECB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_256_CBC, "Serpent-256/CBC");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_256_CFB, "Serpent-256/CFB");
        DefaultAlgorithmNameFinder.addAlgorithm(GNUObjectIdentifiers.Serpent_256_OFB, "Serpent-256/OFB");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2b160, "BLAKE2b-160");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2b256, "BLAKE2b-256");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2b384, "BLAKE2b-384");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2b512, "BLAKE2b-512");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2s128, "BLAKE2s-128");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2s160, "BLAKE2s-160");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2s224, "BLAKE2s-224");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.id_blake2s256, "BLAKE2s-256");
        DefaultAlgorithmNameFinder.addAlgorithm(MiscObjectIdentifiers.blake3_256, "BLAKE3-256");
    }
}

