/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.fhir.FhirComponent;
import org.apache.camel.component.fhir.FhirConfiguration;

public interface FhirComponentBuilderFactory {
    public static FhirComponentBuilder fhir() {
        return new FhirComponentBuilderImpl();
    }

    public static class FhirComponentBuilderImpl
    extends AbstractComponentBuilder<FhirComponent>
    implements FhirComponentBuilder {
        @Override
        protected FhirComponent buildConcreteComponent() {
            return new FhirComponent();
        }

        private FhirConfiguration getOrCreateConfiguration(FhirComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new FhirConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "encoding": {
                    this.getOrCreateConfiguration((FhirComponent)component).setEncoding((String)value);
                    return true;
                }
                case "fhirVersion": {
                    this.getOrCreateConfiguration((FhirComponent)component).setFhirVersion((String)value);
                    return true;
                }
                case "log": {
                    this.getOrCreateConfiguration((FhirComponent)component).setLog(((Boolean)value).booleanValue());
                    return true;
                }
                case "prettyPrint": {
                    this.getOrCreateConfiguration((FhirComponent)component).setPrettyPrint(((Boolean)value).booleanValue());
                    return true;
                }
                case "serverUrl": {
                    this.getOrCreateConfiguration((FhirComponent)component).setServerUrl((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((FhirComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((FhirComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((FhirComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "client": {
                    this.getOrCreateConfiguration((FhirComponent)component).setClient((IGenericClient)value);
                    return true;
                }
                case "clientFactory": {
                    this.getOrCreateConfiguration((FhirComponent)component).setClientFactory((IRestfulClientFactory)value);
                    return true;
                }
                case "compress": {
                    this.getOrCreateConfiguration((FhirComponent)component).setCompress(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((FhirComponent)component).setConfiguration((FhirConfiguration)value);
                    return true;
                }
                case "connectionTimeout": {
                    this.getOrCreateConfiguration((FhirComponent)component).setConnectionTimeout((Integer)value);
                    return true;
                }
                case "deferModelScanning": {
                    this.getOrCreateConfiguration((FhirComponent)component).setDeferModelScanning(((Boolean)value).booleanValue());
                    return true;
                }
                case "fhirContext": {
                    this.getOrCreateConfiguration((FhirComponent)component).setFhirContext((FhirContext)value);
                    return true;
                }
                case "forceConformanceCheck": {
                    this.getOrCreateConfiguration((FhirComponent)component).setForceConformanceCheck(((Boolean)value).booleanValue());
                    return true;
                }
                case "sessionCookie": {
                    this.getOrCreateConfiguration((FhirComponent)component).setSessionCookie((String)value);
                    return true;
                }
                case "socketTimeout": {
                    this.getOrCreateConfiguration((FhirComponent)component).setSocketTimeout((Integer)value);
                    return true;
                }
                case "summary": {
                    this.getOrCreateConfiguration((FhirComponent)component).setSummary((String)value);
                    return true;
                }
                case "validationMode": {
                    this.getOrCreateConfiguration((FhirComponent)component).setValidationMode((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((FhirComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPassword": {
                    this.getOrCreateConfiguration((FhirComponent)component).setProxyPassword((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((FhirComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyUser": {
                    this.getOrCreateConfiguration((FhirComponent)component).setProxyUser((String)value);
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((FhirComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((FhirComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((FhirComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface FhirComponentBuilder
    extends ComponentBuilder<FhirComponent> {
        default public FhirComponentBuilder encoding(String encoding) {
            this.doSetProperty("encoding", encoding);
            return this;
        }

        default public FhirComponentBuilder fhirVersion(String fhirVersion) {
            this.doSetProperty("fhirVersion", fhirVersion);
            return this;
        }

        default public FhirComponentBuilder log(boolean log) {
            this.doSetProperty("log", log);
            return this;
        }

        default public FhirComponentBuilder prettyPrint(boolean prettyPrint) {
            this.doSetProperty("prettyPrint", prettyPrint);
            return this;
        }

        default public FhirComponentBuilder serverUrl(String serverUrl) {
            this.doSetProperty("serverUrl", serverUrl);
            return this;
        }

        default public FhirComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public FhirComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public FhirComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public FhirComponentBuilder client(IGenericClient client) {
            this.doSetProperty("client", client);
            return this;
        }

        default public FhirComponentBuilder clientFactory(IRestfulClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public FhirComponentBuilder compress(boolean compress) {
            this.doSetProperty("compress", compress);
            return this;
        }

        default public FhirComponentBuilder configuration(FhirConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public FhirComponentBuilder connectionTimeout(Integer connectionTimeout) {
            this.doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }

        default public FhirComponentBuilder deferModelScanning(boolean deferModelScanning) {
            this.doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }

        default public FhirComponentBuilder fhirContext(FhirContext fhirContext) {
            this.doSetProperty("fhirContext", fhirContext);
            return this;
        }

        default public FhirComponentBuilder forceConformanceCheck(boolean forceConformanceCheck) {
            this.doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }

        default public FhirComponentBuilder sessionCookie(String sessionCookie) {
            this.doSetProperty("sessionCookie", sessionCookie);
            return this;
        }

        default public FhirComponentBuilder socketTimeout(Integer socketTimeout) {
            this.doSetProperty("socketTimeout", socketTimeout);
            return this;
        }

        default public FhirComponentBuilder summary(String summary) {
            this.doSetProperty("summary", summary);
            return this;
        }

        default public FhirComponentBuilder validationMode(String validationMode) {
            this.doSetProperty("validationMode", validationMode);
            return this;
        }

        default public FhirComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public FhirComponentBuilder proxyPassword(String proxyPassword) {
            this.doSetProperty("proxyPassword", proxyPassword);
            return this;
        }

        default public FhirComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public FhirComponentBuilder proxyUser(String proxyUser) {
            this.doSetProperty("proxyUser", proxyUser);
            return this;
        }

        default public FhirComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public FhirComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public FhirComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

