/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.knative.KnativeComponent;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.component.knative.spi.KnativeSinkBinding;

public interface KnativeComponentBuilderFactory {
    public static KnativeComponentBuilder knative() {
        return new KnativeComponentBuilderImpl();
    }

    public static class KnativeComponentBuilderImpl
    extends AbstractComponentBuilder<KnativeComponent>
    implements KnativeComponentBuilder {
        @Override
        protected KnativeComponent buildConcreteComponent() {
            return new KnativeComponent();
        }

        private KnativeConfiguration getOrCreateConfiguration(KnativeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KnativeConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "ceOverride": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setCeOverride((Map)value);
                    return true;
                }
                case "cloudEventsSpecVersion": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setCloudEventsSpecVersion((String)value);
                    return true;
                }
                case "cloudEventsType": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setCloudEventsType((String)value);
                    return true;
                }
                case "configuration": {
                    ((KnativeComponent)component).setConfiguration((KnativeConfiguration)value);
                    return true;
                }
                case "consumerFactory": {
                    ((KnativeComponent)component).setConsumerFactory((KnativeConsumerFactory)value);
                    return true;
                }
                case "environment": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setEnvironment((KnativeEnvironment)value);
                    return true;
                }
                case "environmentPath": {
                    ((KnativeComponent)component).setEnvironmentPath((String)value);
                    return true;
                }
                case "filters": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setFilters((Map)value);
                    return true;
                }
                case "producerFactory": {
                    ((KnativeComponent)component).setProducerFactory((KnativeProducerFactory)value);
                    return true;
                }
                case "sinkBinding": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setSinkBinding((KnativeSinkBinding)value);
                    return true;
                }
                case "transportOptions": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setTransportOptions((Map)value);
                    return true;
                }
                case "typeId": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setTypeId((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KnativeComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyWithCloudEvent": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setReplyWithCloudEvent(((Boolean)value).booleanValue());
                    return true;
                }
                case "reply": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setReply((Boolean)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KnativeComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "apiVersion": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setApiVersion((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((KnativeComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "kind": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setKind((String)value);
                    return true;
                }
                case "name": {
                    this.getOrCreateConfiguration((KnativeComponent)component).setName((String)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((KnativeComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((KnativeComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface KnativeComponentBuilder
    extends ComponentBuilder<KnativeComponent> {
        default public KnativeComponentBuilder ceOverride(Map<String, String> ceOverride) {
            this.doSetProperty("ceOverride", ceOverride);
            return this;
        }

        default public KnativeComponentBuilder cloudEventsSpecVersion(String cloudEventsSpecVersion) {
            this.doSetProperty("cloudEventsSpecVersion", cloudEventsSpecVersion);
            return this;
        }

        default public KnativeComponentBuilder cloudEventsType(String cloudEventsType) {
            this.doSetProperty("cloudEventsType", cloudEventsType);
            return this;
        }

        default public KnativeComponentBuilder configuration(KnativeConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public KnativeComponentBuilder consumerFactory(KnativeConsumerFactory consumerFactory) {
            this.doSetProperty("consumerFactory", consumerFactory);
            return this;
        }

        default public KnativeComponentBuilder environment(KnativeEnvironment environment) {
            this.doSetProperty("environment", environment);
            return this;
        }

        default public KnativeComponentBuilder environmentPath(String environmentPath) {
            this.doSetProperty("environmentPath", environmentPath);
            return this;
        }

        default public KnativeComponentBuilder filters(Map<String, String> filters) {
            this.doSetProperty("filters", filters);
            return this;
        }

        default public KnativeComponentBuilder producerFactory(KnativeProducerFactory producerFactory) {
            this.doSetProperty("producerFactory", producerFactory);
            return this;
        }

        default public KnativeComponentBuilder sinkBinding(KnativeSinkBinding sinkBinding) {
            this.doSetProperty("sinkBinding", sinkBinding);
            return this;
        }

        default public KnativeComponentBuilder transportOptions(Map<String, Object> transportOptions) {
            this.doSetProperty("transportOptions", transportOptions);
            return this;
        }

        default public KnativeComponentBuilder typeId(String typeId) {
            this.doSetProperty("typeId", typeId);
            return this;
        }

        default public KnativeComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public KnativeComponentBuilder replyWithCloudEvent(boolean replyWithCloudEvent) {
            this.doSetProperty("replyWithCloudEvent", replyWithCloudEvent);
            return this;
        }

        default public KnativeComponentBuilder reply(Boolean reply) {
            this.doSetProperty("reply", reply);
            return this;
        }

        default public KnativeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KnativeComponentBuilder apiVersion(String apiVersion) {
            this.doSetProperty("apiVersion", apiVersion);
            return this;
        }

        default public KnativeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public KnativeComponentBuilder kind(String kind) {
            this.doSetProperty("kind", kind);
            return this;
        }

        default public KnativeComponentBuilder name(String name) {
            this.doSetProperty("name", name);
            return this;
        }

        default public KnativeComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public KnativeComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }
}

