/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Route;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="debug", description="Camel route debugger")
public class DebugDevConsole
extends AbstractDevConsole {
    public static final String COMMAND = "command";
    public static final String BREAKPOINT = "breakpoint";
    public static final String POSITION = "position";
    public static final String CODE_LIMIT = "codeLimit";
    public static final String HISTORY = "history";

    public DebugDevConsole() {
        super("camel", "debug", "Debug", "Camel route debugger");
    }

    protected String doCallText(Map<String, Object> options) {
        int num;
        String command = (String)options.get(COMMAND);
        String breakpoint = (String)options.get(BREAKPOINT);
        String position = (String)options.get(POSITION);
        int n = num = position == null || position.isBlank() ? 0 : Integer.parseInt(position);
        if (ObjectHelper.isNotEmpty((String)command)) {
            this.doCommand(command, breakpoint, num);
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog != null) {
            sb.append("Settings:");
            sb.append(String.format("\n    Enabled: %s", backlog.isEnabled()));
            sb.append(String.format("\n    Standby: %s", backlog.isStandby()));
            sb.append(String.format("\n    Suspended Mode: %s", backlog.isSuspendMode()));
            sb.append(String.format("\n    Fallback Timeout: %ss", backlog.getFallbackTimeout()));
            sb.append(String.format("\n    Logging Level: %s", backlog.getLoggingLevel()));
            sb.append(String.format("\n    Include Exchange Properties: %s", backlog.isIncludeExchangeProperties()));
            sb.append(String.format("\n    Include Files: %s", backlog.isBodyIncludeFiles()));
            sb.append(String.format("\n    Include Streams: %s", backlog.isBodyIncludeStreams()));
            sb.append(String.format("\n    Max Chars: %s", backlog.getBodyMaxChars()));
            sb.append("\n\nBreakpoints:");
            sb.append(String.format("\n    Debug Counter: %s", backlog.getDebugCounter()));
            sb.append(String.format("\n    Single Step Mode: %s", backlog.isSingleStepMode()));
            for (String n2 : backlog.getBreakpoints()) {
                boolean suspended = backlog.getSuspendedBreakpointNodeIds().contains(n2);
                if (suspended) {
                    sb.append(String.format("\n    Breakpoint: %s (suspended)", n2));
                    continue;
                }
                sb.append(String.format("\n    Breakpoint: %s", n2));
            }
            sb.append("\n\nSuspended:");
            for (String n2 : backlog.getSuspendedBreakpointNodeIds()) {
                sb.append(String.format("\n    Node: %s (suspended)", n2));
                BacklogTracerEventMessage trace = backlog.getSuspendedBreakpointMessage(n2);
                if (trace == null) continue;
                sb.append("\n");
                sb.append(trace.toXml(4));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void doCommand(String command, String breakpoint, int position) {
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog == null) {
            return;
        }
        if ("enable".equalsIgnoreCase(command)) {
            backlog.enableDebugger();
        } else if ("disable".equalsIgnoreCase(command)) {
            backlog.disableDebugger();
        } else if ("attach".equalsIgnoreCase(command)) {
            backlog.attach();
        } else if ("detach".equalsIgnoreCase(command)) {
            backlog.detach();
        } else if ("resume".equalsIgnoreCase(command)) {
            backlog.resumeAll();
        } else if ("step".equalsIgnoreCase(command)) {
            if (ObjectHelper.isNotEmpty((String)breakpoint)) {
                backlog.stepBreakpoint(breakpoint);
            } else if (position < 1 || !this.stepToPosition(backlog, position)) {
                backlog.stepBreakpoint();
            }
        } else if ("stepover".equalsIgnoreCase(command)) {
            backlog.stepOver();
        } else if ("skipover".equalsIgnoreCase(command)) {
            backlog.skipOver();
        } else if ("add".equalsIgnoreCase(command) && ObjectHelper.isNotEmpty((String)breakpoint)) {
            backlog.addBreakpoint(breakpoint);
        } else if ("remove".equalsIgnoreCase(command)) {
            if (ObjectHelper.isNotEmpty((String)breakpoint)) {
                backlog.removeBreakpoint(breakpoint);
            } else {
                backlog.removeAllBreakpoints();
            }
        }
    }

    private boolean stepToPosition(BacklogDebugger backlog, int position) {
        if (position < 1) {
            return false;
        }
        if (!backlog.isSingleStepMode()) {
            return false;
        }
        if (backlog.getSuspendedBreakpointNodeIds().size() != 1) {
            return false;
        }
        String id = (String)backlog.getSuspendedBreakpointNodeIds().iterator().next();
        Exchange exchange = backlog.getSuspendedExchange(id);
        if (exchange == null) {
            return false;
        }
        List list = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
        if (list == null) {
            return false;
        }
        int diff = position - list.size() + 1;
        if (diff <= 0) {
            return false;
        }
        StopWatch watch = new StopWatch();
        for (int i = 0; i < diff; ++i) {
            if (backlog.getSuspendedBreakpointNodeIds().isEmpty()) {
                return true;
            }
            id = (String)backlog.getSuspendedBreakpointNodeIds().iterator().next();
            BacklogTracerEventMessage msg = backlog.getSuspendedBreakpointMessage(id);
            if (msg.isLast()) {
                return true;
            }
            watch.restart();
            backlog.stepBreakpoint();
            while (backlog.isSingleStepMode() && backlog.getSuspendedBreakpointNodeIds().isEmpty()) {
                if (watch.taken() > 10000L) {
                    return false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        int num;
        JsonObject root = new JsonObject();
        String command = (String)options.get(COMMAND);
        String breakpoint = (String)options.get(BREAKPOINT);
        String codeLimit = (String)options.getOrDefault(CODE_LIMIT, "5");
        boolean history = "true".equals(options.getOrDefault(HISTORY, "true"));
        String repeat = (String)options.get(POSITION);
        int n = num = repeat == null || repeat.isBlank() ? 0 : Integer.parseInt(repeat);
        if (ObjectHelper.isNotEmpty((String)command)) {
            this.doCommand(command, breakpoint, num);
            return root;
        }
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog != null) {
            root.put((Object)"version", (Object)this.getCamelContext().getVersion());
            root.put((Object)"enabled", (Object)backlog.isEnabled());
            root.put((Object)"standby", (Object)backlog.isStandby());
            root.put((Object)"suspendedMode", (Object)backlog.isSuspendMode());
            root.put((Object)"fallbackTimeout", (Object)backlog.getFallbackTimeout());
            root.put((Object)"loggingLevel", (Object)backlog.getLoggingLevel());
            root.put((Object)"includeExchangeProperties", (Object)backlog.isIncludeExchangeProperties());
            root.put((Object)"includeFiles", (Object)backlog.isBodyIncludeFiles());
            root.put((Object)"includeStreams", (Object)backlog.isBodyIncludeStreams());
            root.put((Object)"maxChars", (Object)backlog.getBodyMaxChars());
            root.put((Object)"debugCounter", (Object)backlog.getDebugCounter());
            root.put((Object)"singleStepMode", (Object)backlog.isSingleStepMode());
            JsonArray arr = new JsonArray();
            for (String n2 : backlog.getBreakpoints()) {
                JsonObject jo = new JsonObject();
                jo.put((Object)"nodeId", (Object)n2);
                boolean suspended = backlog.getSuspendedBreakpointNodeIds().contains(n2);
                jo.put((Object)"suspended", (Object)suspended);
                arr.add((Object)jo);
            }
            if (!arr.isEmpty()) {
                root.put((Object)"breakpoints", (Object)arr);
            }
            arr = new JsonArray();
            for (String n2 : backlog.getSuspendedBreakpointNodeIds()) {
                List<JsonObject> steps;
                BacklogTracerEventMessage t = backlog.getSuspendedBreakpointMessage(n2);
                if (t == null) continue;
                JsonObject to = (JsonObject)t.asJSon();
                arr.add((Object)to);
                int limit = Integer.parseInt(codeLimit);
                if (limit > 0) {
                    List<JsonObject> code;
                    String rid = to.getString("routeId");
                    String loc = to.getString("location");
                    if (rid != null && (code = this.enrichSourceCode(rid, loc, limit)) != null && !code.isEmpty()) {
                        to.put((Object)"code", code);
                    }
                }
                if (!history || (steps = this.enrichHistory(backlog, n2)).isEmpty()) continue;
                to.put((Object)HISTORY, steps);
            }
            if (!arr.isEmpty()) {
                root.put((Object)"suspended", (Object)arr);
            }
        }
        return root;
    }

    private List<JsonObject> enrichHistory(BacklogDebugger backlog, String id) {
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        Exchange exchange = backlog.getSuspendedExchange(id);
        if (exchange == null) {
            return arr;
        }
        List list = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
        if (list == null) {
            return arr;
        }
        int counter = 0;
        for (MessageHistory h : list) {
            NamedRoute nr;
            JsonObject jo = new JsonObject();
            if (h.getNode() != null && (nr = CamelContextHelper.getRoute((NamedNode)h.getNode())) != null) {
                boolean skip;
                boolean bl = skip = nr.isCreatedFromRest() || nr.isCreatedFromTemplate();
                if (skip) continue;
            }
            jo.put((Object)"index", (Object)counter++);
            if (h.getRouteId() != null) {
                jo.put((Object)"routeId", (Object)h.getRouteId());
            }
            jo.put((Object)"elapsed", (Object)h.getElapsed());
            jo.put((Object)"acceptDebugger", (Object)h.isAcceptDebugger());
            jo.put((Object)"skipOver", (Object)h.isDebugSkipOver());
            if (h.getNode() != null) {
                String t;
                jo.put((Object)"nodeId", (Object)h.getNode().getId());
                if (h.getNode().getLocation() != null) {
                    String loc = h.getNode().getLocation();
                    if (loc.contains(":")) {
                        loc = StringHelper.after((String)loc, (String)":");
                    }
                    jo.put((Object)"location", (Object)loc);
                }
                if (h.getNode().getLineNumber() != -1) {
                    jo.put((Object)"line", (Object)h.getNode().getLineNumber());
                }
                if ((t = ConsoleHelper.loadSourceLine(this.getCamelContext(), h.getNode().getLocation(), h.getNode().getLineNumber())) != null) {
                    jo.put((Object)"code", (Object)Jsoner.escape((String)t));
                }
            }
            arr.add(jo);
        }
        return arr;
    }

    private List<JsonObject> enrichSourceCode(String routeId, String location, int lines) {
        Route route = this.getCamelContext().getRoute(routeId);
        if (route == null) {
            return null;
        }
        Resource resource = route.getSourceResource();
        if (resource == null) {
            return null;
        }
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        location = StringHelper.afterLast((String)location, (String)":");
        int line = 0;
        try {
            if (location != null) {
                line = Integer.parseInt(location);
            }
            LineNumberReader reader = new LineNumberReader(resource.getReader());
            for (int i = 1; i <= line + lines; ++i) {
                String t = reader.readLine();
                if (t == null) continue;
                int low = line - lines + 2;
                int high = line + lines + 1 + 2;
                if (i < low || i > high) continue;
                JsonObject c = new JsonObject();
                c.put((Object)"line", (Object)i);
                if (line == i) {
                    c.put((Object)"match", (Object)true);
                }
                c.put((Object)"code", (Object)Jsoner.escape((String)t));
                code.add(c);
            }
            IOHelper.close((Closeable)reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }
}

