/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetConstants;
import org.apache.camel.component.dataset.DataSetConsumer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.ThroughputLogger;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.3.0", scheme="dataset", title="Dataset", syntax="dataset:name", remote=false, category={Category.CORE, Category.TESTING}, lenientProperties=true, headersClass=DataSetConstants.class)
public class DataSetEndpoint
extends MockEndpoint
implements Service {
    private final transient Logger log;
    private final AtomicInteger receivedCounter = new AtomicInteger();
    @UriPath(name="name", description="Name of DataSet to lookup in the registry")
    @Metadata(required=true)
    private volatile DataSet dataSet;
    @UriParam(label="consumer", defaultValue="0")
    private int minRate;
    @UriParam(label="consumer", defaultValue="3", javaType="java.time.Duration")
    private long produceDelay = 3L;
    @UriParam(label="producer", defaultValue="0", javaType="java.time.Duration")
    private long consumeDelay;
    @UriParam(label="consumer", defaultValue="0")
    private long preloadSize;
    @UriParam(label="consumer", defaultValue="1000", javaType="java.time.Duration")
    private long initialDelay = 1000L;
    @UriParam(enums="strict,lenient,off", defaultValue="lenient")
    private String dataSetIndex = "lenient";

    public DataSetEndpoint(String endpointUri, Component component, DataSet dataSet) {
        super(endpointUri, component);
        this.dataSet = dataSet;
        this.log = LoggerFactory.getLogger((String)endpointUri);
        this.setCopyOnExchange(false);
    }

    public boolean isRemote() {
        return false;
    }

    public static void assertEquals(String description, Object expected, Object actual, Exchange exchange) {
        if (!ObjectHelper.equal((Object)expected, (Object)actual)) {
            throw new AssertionError((Object)(description + " does not match. Expected: " + String.valueOf(expected) + " but was: " + String.valueOf(actual) + " on " + String.valueOf(exchange) + " with headers: " + String.valueOf(exchange.getIn().getHeaders())));
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DataSetConsumer answer = new DataSetConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        Producer answer = super.createProducer();
        long size = this.getDataSet().getSize();
        this.expectedMessageCount((int)size);
        return answer;
    }

    public void reset() {
        super.reset();
        if (this.receivedCounter != null) {
            this.receivedCounter.set(0);
        }
    }

    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public Exchange createExchange(long messageIndex) throws Exception {
        Exchange exchange = this.createExchange();
        this.getDataSet().populateMessage(exchange, messageIndex);
        if (!this.getDataSetIndex().equals("off")) {
            Message in = exchange.getIn();
            in.setHeader("CamelDataSetIndex", (Object)messageIndex);
        }
        return exchange;
    }

    protected void waitForCompleteLatch(long timeout) throws InterruptedException {
        super.waitForCompleteLatch(timeout);
        if (this.minRate > 0) {
            int count = this.getReceivedCounter();
            do {
                super.waitForCompleteLatch(1000L);
            } while ((count = this.getReceivedCounter() - count) >= this.minRate);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public int getMinRate() {
        return this.minRate;
    }

    public void setMinRate(int minRate) {
        this.minRate = minRate;
    }

    public long getPreloadSize() {
        return this.preloadSize;
    }

    public void setPreloadSize(long preloadSize) {
        this.preloadSize = preloadSize;
    }

    public long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public long getProduceDelay() {
        return this.produceDelay;
    }

    public void setProduceDelay(long produceDelay) {
        this.produceDelay = produceDelay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setDataSetIndex(String dataSetIndex) {
        switch (dataSetIndex) {
            case "off": 
            case "lenient": 
            case "strict": {
                this.dataSetIndex = dataSetIndex;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value specified for the dataSetIndex URI parameter:" + dataSetIndex + "Supported values are strict, lenient and off ");
            }
        }
    }

    public String getDataSetIndex() {
        return this.dataSetIndex;
    }

    protected void performAssertions(Exchange actual, Exchange copy) throws Exception {
        int receivedCount = this.receivedCounter.incrementAndGet();
        long index = receivedCount - 1;
        Exchange expected = this.createExchange(index);
        if (this.log.isDebugEnabled()) {
            if (copy.getIn().getHeader("CamelDataSetIndex") != null) {
                this.log.debug("Received message: {} (DataSet index={}) = {}", new Object[]{index, copy.getIn().getHeader("CamelDataSetIndex", Integer.class), copy});
            } else {
                this.log.debug("Received message: {} = {}", (Object)index, (Object)copy);
            }
        }
        this.assertMessageExpected(index, expected, copy);
        if (this.consumeDelay > 0L) {
            Thread.sleep(this.consumeDelay);
        }
    }

    protected void assertMessageExpected(long index, Exchange expected, Exchange actual) throws Exception {
        switch (this.getDataSetIndex()) {
            case "off": {
                break;
            }
            case "strict": {
                long actualCounter = (Long)ExchangeHelper.getMandatoryHeader((Exchange)actual, (String)"CamelDataSetIndex", Long.class);
                DataSetEndpoint.assertEquals("Header: CamelDataSetIndex", index, actualCounter, actual);
                break;
            }
            default: {
                Long dataSetIndexHeaderValue = (Long)actual.getIn().getHeader("CamelDataSetIndex", Long.class);
                if (dataSetIndexHeaderValue != null) {
                    DataSetEndpoint.assertEquals("Header: CamelDataSetIndex", index, dataSetIndexHeaderValue, actual);
                    break;
                }
                actual.getIn().setHeader("CamelDataSetIndex", (Object)index);
            }
        }
        this.getDataSet().assertMessageExpected(this, expected, actual, index);
    }

    protected ThroughputLogger createReporter() {
        String uri = URISupport.sanitizeUri((String)this.getEndpointUri());
        CamelLogger logger = new CamelLogger(uri);
        ThroughputLogger answer = new ThroughputLogger(logger, Integer.valueOf((int)this.getDataSet().getReportCount()));
        answer.setAction("Received");
        return answer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        this.log.debug("{} expecting {} messages", (Object)this, (Object)this.getExpectedCount());
    }
}

