/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.lambda.LambdaClient;

public interface Lambda2EndpointBuilderFactory {
    public static Lambda2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Lambda2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Lambda2EndpointBuilder,
        AdvancedLambda2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public Lambda2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new Lambda2EndpointBuilderImpl(path, componentName);
    }

    public static class Lambda2HeaderNameBuilder {
        private static final Lambda2HeaderNameBuilder INSTANCE = new Lambda2HeaderNameBuilder();

        public String awsLambdaOperation() {
            return "CamelAwsLambdaOperation";
        }

        public String awsLambdaS3Bucket() {
            return "CamelAwsLambdaS3Bucket";
        }

        public String awsLambdaS3Key() {
            return "CamelAwsLambdaS3Key";
        }

        public String awsLambdaS3ObjectVersion() {
            return "CamelAwsLambdaS3ObjectVersion";
        }

        public String awsLambdaZipFile() {
            return "CamelAwsLambdaZipFile";
        }

        public String awsLambdaDescription() {
            return "CamelAwsLambdaDescription";
        }

        public String awsLambdaRole() {
            return "CamelAwsLambdaRole";
        }

        public String awsLambdaRuntime() {
            return "CamelAwsLambdaRuntime";
        }

        public String awsLambdaHandler() {
            return "CamelAwsLambdaHandler";
        }

        public String awsLambdaTargetArn() {
            return "CamelAwsLambdaTargetArn";
        }

        public String awsLambdaMemorySize() {
            return "CamelAwsLambdaMemorySize";
        }

        public String awsLambdaKMSKeyArn() {
            return "CamelAwsLambdaKMSKeyArn";
        }

        public String awsLambdaEnvironmentVariables() {
            return "CamelAwsLambdaEnvironmentVariables";
        }

        public String awsLambdaPublish() {
            return "CamelAwsLambdaPublish";
        }

        public String awsLambdaTimeout() {
            return "CamelAwsLambdaTimeout";
        }

        public String awsLambdaTags() {
            return "CamelAwsLambdaTags";
        }

        public String awsLambdaTracingConfig() {
            return "CamelAwsLambdaTracingConfig";
        }

        public String awsLambdaSecurityGroupIds() {
            return "CamelAwsLambdaSecurityGroupIds";
        }

        public String awsLambdaSubnetIds() {
            return "CamelAwsLambdaSubnetIds";
        }

        public String awsLambdaEventSourceArn() {
            return "CamelAwsLambdaEventSourceArn";
        }

        public String awsLambdaEventSourceBatchSize() {
            return "CamelAwsLambdaEventSourceBatchSize";
        }

        public String awsLambdaEventSourceUuid() {
            return "CamelAwsLambdaEventSourceUuid";
        }

        public String awsLambdaResourceArn() {
            return "CamelAwsLambdaResourceArn";
        }

        public String awsLambdaResourceTags() {
            return "CamelAwsLambdaResourceTags";
        }

        public String awsLambdaResourceTagKeys() {
            return "CamelAwsLambdaResourceTagKeys";
        }

        public String awsLambdaVersionDescription() {
            return "CamelAwsLambdaVersionDescription";
        }

        public String awsLambdaVersionRevisionId() {
            return "CamelAwsLambdaVersionRevisionId";
        }

        public String awsLambdaFunctionVersion() {
            return "CamelAwsLambdaFunctionVersion";
        }

        public String awsLambdaAliasFunctionName() {
            return "CamelAwsLambdaAliasFunctionName";
        }

        public String awsLambdaAliasFunctionDescription() {
            return "CamelAwsLambdaAliasFunctionDescription";
        }
    }

    public static interface Lambda2Builders {
        default public Lambda2HeaderNameBuilder aws2Lambda() {
            return Lambda2HeaderNameBuilder.INSTANCE;
        }

        default public Lambda2EndpointBuilder aws2Lambda(String path) {
            return Lambda2EndpointBuilderFactory.endpointBuilder("aws2-lambda", path);
        }

        default public Lambda2EndpointBuilder aws2Lambda(String componentName, String path) {
            return Lambda2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedLambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public Lambda2EndpointBuilder basic() {
            return (Lambda2EndpointBuilder)((Object)this);
        }

        default public AdvancedLambda2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(LambdaClient awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(String awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }
    }

    public static interface Lambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedLambda2EndpointBuilder advanced() {
            return (AdvancedLambda2EndpointBuilder)((Object)this);
        }

        default public Lambda2EndpointBuilder operation(Lambda2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Lambda2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Lambda2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Lambda2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Lambda2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Lambda2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Lambda2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Lambda2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Lambda2EndpointBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Lambda2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Lambda2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Lambda2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public Lambda2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

