/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelException;
import org.apache.camel.component.salesforce.api.dto.RestError;

public class SalesforceException
extends CamelException {
    private static final long serialVersionUID = 1L;
    private final List<RestError> errors;
    private final int statusCode;
    private final InputStream responseContent;

    public SalesforceException(String message) {
        this(message, null);
    }

    public SalesforceException(Throwable cause) {
        this(null, 0, null, cause);
    }

    public SalesforceException(String message, Throwable cause) {
        this(null, 0, message, cause);
    }

    public SalesforceException(String message, int statusCode) {
        this(null, statusCode, message, (InputStream)null);
    }

    public SalesforceException(String message, int statusCode, Throwable cause) {
        this(null, statusCode, message, cause);
    }

    public SalesforceException(List<RestError> errors, int statusCode) {
        this(errors, statusCode, null, (InputStream)null);
    }

    public SalesforceException(List<RestError> errors, int statusCode, Throwable cause) {
        this(errors, statusCode, null, cause);
    }

    public SalesforceException(List<RestError> errors, int statusCode, String message) {
        this(errors, statusCode, message, null, null);
    }

    public SalesforceException(List<RestError> errors, int statusCode, String message, InputStream responseContent) {
        this(errors, statusCode, message, responseContent, null);
    }

    public SalesforceException(List<RestError> errors, int statusCode, String message, Throwable cause) {
        this(errors, statusCode, message, null, cause);
    }

    public SalesforceException(List<RestError> errors, int statusCode, String message, InputStream responseContent, Throwable cause) {
        super(message == null ? SalesforceException.toErrorMessage(errors, statusCode) : message, cause);
        this.errors = errors;
        this.statusCode = statusCode;
        this.responseContent = responseContent;
    }

    public List<RestError> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getResponseContent() {
        return this.responseContent;
    }

    private static String toErrorMessage(List<RestError> errors, int statusCode) {
        StringBuilder builder = new StringBuilder("{");
        if (errors != null) {
            builder.append("errors:[");
            for (RestError error : errors) {
                builder.append(error.toString());
            }
            builder.append("],");
        }
        builder.append("statusCode:");
        builder.append(statusCode);
        builder.append("}");
        return builder.toString();
    }
}

