/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.approval;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class Approvals
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<Info>> approvals;

    @JsonCreator
    Approvals(@JsonProperty(value="approvals") Map<String, List<Info>> approvals) {
        this.approvals = Optional.ofNullable(approvals).orElse(Collections.emptyMap());
    }

    public List<Info> approvalsFor(String object) {
        return this.approvals.getOrDefault(object, Collections.emptyList());
    }

    public Map<String, List<Info>> getApprovals() {
        return this.approvals;
    }

    public String toString() {
        return this.approvals.toString();
    }

    public static final class Info
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String description;
        private final String id;
        private final String name;
        private final String object;
        private final int sortOrder;

        @JsonCreator
        Info(@JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="object") String object, @JsonProperty(value="sortOrder") int sortOrder) {
            this.description = description;
            this.id = id;
            this.name = name;
            this.object = object;
            this.sortOrder = sortOrder;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getObject() {
            return this.object;
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public String toString() {
            StringBuilder buildy = new StringBuilder();
            buildy.append("Id: ").append(this.id);
            buildy.append(", Name: ").append(this.name);
            buildy.append(", Object: ").append(this.object);
            buildy.append(", Description: ").append(this.description);
            buildy.append(", SortOrder: ").append(this.sortOrder);
            return buildy.toString();
        }
    }
}

