/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.util;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.StubComponentAutowireStrategy;
import org.apache.camel.test.junit5.StubComponentResolver;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelContextTestHelper {
    public static final String ROUTE_COVERAGE_ENABLED = "CamelTestRouteCoverage";
    public static final String ROUTE_DUMP_ENABLED = "CamelTestRouteDump";
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextTestHelper.class);

    private CamelContextTestHelper() {
    }

    public static CamelContext createCamelContext(Registry registry) throws Exception {
        DefaultCamelContext retContext = registry != null ? new DefaultCamelContext(registry) : new DefaultCamelContext();
        return retContext;
    }

    public static void setupDebugger(CamelContext context, Breakpoint breakpoint) {
        assert (context != null) : "You cannot set a debugger on a null context";
        assert (breakpoint != null) : "You cannot set a debugger using a null debug breakpoint";
        if (context.getStatus().equals((Object)ServiceStatus.Started)) {
            LOG.info("Cannot setting the Debugger to the starting CamelContext, stop the CamelContext now.");
            context.stop();
        }
        context.setDebugging(Boolean.valueOf(true));
        DefaultDebugger defaultDebugger = new DefaultDebugger();
        context.setDebugger((Debugger)defaultDebugger);
        defaultDebugger.addBreakpoint(breakpoint);
    }

    public static void setupRoutes(CamelContext context, RoutesBuilder[] builders) throws Exception {
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder routeConfigurationsBuilder = (RouteConfigurationsBuilder)builder;
            LOG.debug("Using created route configuration: {}", (Object)builder);
            context.addRoutesConfigurations(routeConfigurationsBuilder);
        }
        for (RoutesBuilder builder : builders) {
            LOG.debug("Using created route builder to add routes: {}", (Object)builder);
            context.addRoutes(builder);
        }
        for (RoutesBuilder builder : builders) {
            LOG.debug("Using created route builder to add templated routes: {}", (Object)builder);
            context.addTemplatedRoutes(builder);
        }
    }

    public static MockEndpoint lookupEndpoint(CamelContext context, String uri, boolean create, String target) {
        MockEndpoint found = context.getEndpointRegistry().values().stream().filter(MockEndpoint.class::isInstance).filter(e -> {
            String t = e.getEndpointUri();
            int idx2 = t.indexOf(63);
            if (idx2 != -1) {
                t = t.substring(0, idx2);
            }
            return t.equals(target);
        }).findFirst().orElse(null);
        if (found != null) {
            return found;
        }
        if (create) {
            return TestSupport.resolveMandatoryEndpoint(context, uri, MockEndpoint.class);
        }
        throw new NoSuchEndpointException(String.format("MockEndpoint %s does not exist.", uri));
    }

    public static void enableAutoMocking(CamelContext context, String pattern, String mockAndSkipPattern) {
        if (pattern != null) {
            context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        if (mockAndSkipPattern != null) {
            context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockAndSkipPattern, true));
        }
    }

    public static void enableAutoStub(CamelContext context, String pattern) {
        if (pattern != null) {
            StubComponent stub = (StubComponent)context.getComponent("stub", StubComponent.class);
            stub.setShadow(true);
            stub.setShadowPattern(pattern);
            stub.setAutowiredEnabled(false);
            context.getCamelContextExtension().addContextPlugin(ComponentResolver.class, (Object)new StubComponentResolver(pattern));
            context.getLifecycleStrategies().removeIf(s -> s.getClass().getSimpleName().equals("DefaultAutowiredLifecycleStrategy"));
            context.getLifecycleStrategies().add(new StubComponentAutowireStrategy(context, pattern));
        }
    }

    public static void configurePropertiesComponent(CamelContext context, Properties extra, PropertiesSource propertiesSource, Boolean ignore) {
        PropertiesComponent pc = context.getPropertiesComponent();
        if (extra != null && !extra.isEmpty()) {
            pc.setOverrideProperties(extra);
        }
        pc.addPropertiesSource(propertiesSource);
        if (ignore != null) {
            pc.setIgnoreMissingLocation(ignore.booleanValue());
        }
    }

    public static void configureIncludeExcludePatterns(CamelContext context, String include, String exclude) {
        if (include != null || exclude != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)include, (Object)exclude);
            ((Model)context.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(include, exclude);
        }
    }

    public static void startCamelContext(CamelContext context) throws Exception {
        if (context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            context.start();
        }
    }

    public static void startCamelContextOrService(CamelContext context, Service camelContextService) throws Exception {
        if (camelContextService != null) {
            camelContextService.start();
        } else {
            CamelContextTestHelper.startCamelContext(context);
        }
    }

    public static void replaceFromEndpoints(ModelCamelContext context, Map<String, String> fromEndpoints) throws Exception {
        for (final Map.Entry<String, String> entry : fromEndpoints.entrySet()) {
            AdviceWith.adviceWith((RouteDefinition)context.getRouteDefinition(entry.getKey()), (CamelContext)context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() {
                    this.replaceFromWith((String)entry.getValue());
                }
            });
        }
    }

    public static boolean isSkipAutoStartContext(TestExecutionConfiguration configuration) {
        return Boolean.parseBoolean(System.getProperty("skipStartingCamelContext")) || !configuration.autoStartContext();
    }

    public static boolean isRouteCoverageEnabled(boolean legacyDumpCoverage) {
        String p = System.getProperty(ROUTE_COVERAGE_ENABLED);
        if (p != null) {
            boolean valid;
            boolean bl = valid = "true".equals(p = p.trim().toLowerCase()) || "false".equals(p);
            if (!valid) {
                throw new IllegalArgumentException("RouteCoverage must be: true or false");
            }
            return Boolean.parseBoolean(p);
        }
        return legacyDumpCoverage;
    }

    public static String getRouteDump(String legacyDumpRoute) {
        String p = System.getProperty(ROUTE_DUMP_ENABLED);
        if (p == null || p.isBlank()) {
            p = legacyDumpRoute;
        }
        if (p != null) {
            boolean valid;
            if ("true".equals(p = p.trim().toLowerCase())) {
                p = "xml";
            }
            boolean bl = valid = "xml".equals(p) || "yaml".equals(p) || "false".equals(p);
            if (!valid) {
                throw new IllegalArgumentException("RouteDump must be: xml, yaml, true, or false");
            }
        }
        return p;
    }
}

