/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc;

import java.io.Serializable;
import java.util.function.Function;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class JdbcRowOutputFormat
extends JdbcOutputFormat<Row, Row, JdbcBatchStatementExecutor<Row>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRowOutputFormat.class);

    private JdbcRowOutputFormat(JdbcConnectionProvider connectionProvider, String sql, int[] typesArray, int batchSize) {
        super(connectionProvider, new JdbcExecutionOptions.Builder().withBatchSize(batchSize).build(), (JdbcOutputFormat.StatementExecutorFactory & Serializable)ctx -> JdbcRowOutputFormat.createRowExecutor(sql, typesArray, ctx), JdbcOutputFormat.RecordExtractor.identity());
    }

    private static JdbcBatchStatementExecutor<Row> createRowExecutor(String sql, int[] typesArray, RuntimeContext ctx) {
        JdbcStatementBuilder statementBuilder = (st, record) -> JdbcUtils.setRecordToStatement(st, typesArray, record);
        return JdbcBatchStatementExecutor.simple(sql, statementBuilder, ctx.getExecutionConfig().isObjectReuseEnabled() ? Row::copy : Function.identity());
    }

    public static JdbcOutputFormatBuilder buildJdbcOutputFormat() {
        return new JdbcOutputFormatBuilder();
    }

    public static class JdbcOutputFormatBuilder {
        private String username;
        private String password;
        private String drivername;
        private String dbURL;
        private String query;
        private int batchSize = 5000;
        private int[] typesArray;

        private JdbcOutputFormatBuilder() {
        }

        public JdbcOutputFormatBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public JdbcOutputFormatBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public JdbcOutputFormatBuilder setDrivername(String drivername) {
            this.drivername = drivername;
            return this;
        }

        public JdbcOutputFormatBuilder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public JdbcOutputFormatBuilder setQuery(String query) {
            this.query = query;
            return this;
        }

        public JdbcOutputFormatBuilder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public JdbcOutputFormatBuilder setSqlTypes(int[] typesArray) {
            this.typesArray = typesArray;
            return this;
        }

        public JdbcRowOutputFormat finish() {
            return new JdbcRowOutputFormat(new SimpleJdbcConnectionProvider(this.buildConnectionOptions()), this.query, this.typesArray, this.batchSize);
        }

        public JdbcConnectionOptions buildConnectionOptions() {
            if (this.username == null) {
                LOG.info("Username was not supplied.");
            }
            if (this.password == null) {
                LOG.info("Password was not supplied.");
            }
            return new JdbcConnectionOptions.JdbcConnectionOptionsBuilder().withUrl(this.dbURL).withDriverName(this.drivername).withUsername(this.username).withPassword(this.password).build();
        }
    }
}

