/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.crc;

import org.apache.pulsar.shade.com.scurrilous.circe.crc.AbstractLongCrc;

final class NormalLongCrc
extends AbstractLongCrc {
    private final long widthMask;
    private final long[] table = new long[256];

    NormalLongCrc(String algorithm, int bitWidth, long poly, long init, long xorOut) {
        super(algorithm, bitWidth, init, xorOut);
        if (bitWidth < 8) {
            throw new IllegalArgumentException("invalid CRC width");
        }
        this.widthMask = bitWidth < 64 ? (1L << bitWidth) - 1L : -1L;
        long top = 1L << bitWidth - 1;
        for (int i = 0; i < 256; ++i) {
            long crc = (long)i << bitWidth - 8;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & top) != 0L ? crc << 1 ^ poly : crc << 1;
            }
            this.table[i] = crc & this.widthMask;
        }
    }

    @Override
    protected long resumeRaw(long crc, byte[] input, int index, int length) {
        for (int i = 0; i < length; ++i) {
            crc = this.table[(int)(crc >>> this.bitWidth - 8 ^ (long)input[index + i]) & 0xFF] ^ crc << 8;
        }
        return crc & this.widthMask;
    }
}

