/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilterBase;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
extends WALEntryFilterBase
implements WALCellFilter {
    private final BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        NavigableMap<byte[], Integer> scopes = entry.getKey().getReplicationScopes();
        if (MapUtils.isNotEmpty(scopes)) {
            return entry;
        }
        return this.clearOrNull(entry);
    }

    private static boolean hasGlobalScope(NavigableMap<byte[], Integer> scopes, byte[] family) {
        Integer scope = (Integer)scopes.get(family);
        return scope != null && scope == 1;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        final NavigableMap<byte[], Integer> scopes = entry.getKey().getReplicationScopes();
        if (MapUtils.isEmpty(scopes)) {
            return null;
        }
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
            return this.bulkLoadFilter.filterCell(cell, new Predicate<byte[]>(){

                public boolean apply(byte[] family) {
                    return !ScopeWALEntryFilter.hasGlobalScope(scopes, family);
                }
            });
        }
        return ScopeWALEntryFilter.hasGlobalScope(scopes, family) ? cell : null;
    }
}

