/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeleteNamespaceProcedure
extends AbstractStateMachineNamespaceProcedure<MasterProcedureProtos.DeleteNamespaceState> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteNamespaceProcedure.class);
    private NamespaceDescriptor nsDescriptor;
    private String namespaceName;
    private Boolean traceEnabled;

    public DeleteNamespaceProcedure() {
        this.nsDescriptor = null;
        this.traceEnabled = null;
    }

    public DeleteNamespaceProcedure(MasterProcedureEnv env, String namespaceName) {
        this(env, namespaceName, null);
    }

    public DeleteNamespaceProcedure(MasterProcedureEnv env, String namespaceName, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.namespaceName = namespaceName;
        this.nsDescriptor = null;
        this.traceEnabled = null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteNamespaceState state) throws InterruptedException {
        LOG.info(this.toString());
        try {
            switch (state) {
                case DELETE_NAMESPACE_PREPARE: {
                    boolean present = this.prepareDelete(env);
                    this.releaseSyncLatch();
                    if (!present) {
                        assert (this.isFailed()) : "Delete namespace should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_DELETE_FROM_NS_TABLE);
                    break;
                }
                case DELETE_NAMESPACE_DELETE_FROM_NS_TABLE: {
                    DeleteNamespaceProcedure.deleteFromNSTable(env, this.namespaceName);
                    this.setNextState(MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_REMOVE_FROM_ZK);
                    break;
                }
                case DELETE_NAMESPACE_REMOVE_FROM_ZK: {
                    DeleteNamespaceProcedure.removeFromZKNamespaceManager(env, this.namespaceName);
                    this.setNextState(MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_DELETE_DIRECTORIES);
                    break;
                }
                case DELETE_NAMESPACE_DELETE_DIRECTORIES: {
                    DeleteNamespaceProcedure.deleteDirectory(env, this.namespaceName);
                    this.setNextState(MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_REMOVE_NAMESPACE_QUOTA);
                    break;
                }
                case DELETE_NAMESPACE_REMOVE_NAMESPACE_QUOTA: {
                    DeleteNamespaceProcedure.removeNamespaceQuota(env, this.namespaceName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-delete-namespace", e);
            }
            LOG.warn("Retriable error trying to delete namespace " + this.namespaceName + " (in state=" + state + ")", (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DeleteNamespaceState state) throws IOException {
        if (state == MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_PREPARE) {
            this.releaseSyncLatch();
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.DeleteNamespaceState state) {
        switch (state) {
            case DELETE_NAMESPACE_PREPARE: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.DeleteNamespaceState getState(int stateId) {
        return MasterProcedureProtos.DeleteNamespaceState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DeleteNamespaceState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DeleteNamespaceState getInitialState() {
        return MasterProcedureProtos.DeleteNamespaceState.DELETE_NAMESPACE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.DeleteNamespaceStateData.Builder deleteNamespaceMsg = MasterProcedureProtos.DeleteNamespaceStateData.newBuilder().setNamespaceName(this.namespaceName);
        if (this.nsDescriptor != null) {
            deleteNamespaceMsg.setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.nsDescriptor));
        }
        serializer.serialize((Message)deleteNamespaceMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.DeleteNamespaceStateData deleteNamespaceMsg = (MasterProcedureProtos.DeleteNamespaceStateData)serializer.deserialize(MasterProcedureProtos.DeleteNamespaceStateData.class);
        this.namespaceName = deleteNamespaceMsg.getNamespaceName();
        if (deleteNamespaceMsg.hasNamespaceDescriptor()) {
            this.nsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)deleteNamespaceMsg.getNamespaceDescriptor());
        }
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    protected String getNamespaceName() {
        return this.namespaceName;
    }

    private boolean prepareDelete(MasterProcedureEnv env) throws IOException {
        if (!DeleteNamespaceProcedure.getTableNamespaceManager(env).doesNamespaceExist(this.namespaceName)) {
            this.setFailure("master-delete-namespace", (Throwable)new NamespaceNotFoundException(this.namespaceName));
            return false;
        }
        if (NamespaceDescriptor.RESERVED_NAMESPACES.contains(this.namespaceName)) {
            this.setFailure("master-delete-namespace", (Throwable)((Object)new ConstraintException("Reserved namespace " + this.namespaceName + " cannot be removed.")));
            return false;
        }
        int tableCount = 0;
        try {
            tableCount = env.getMasterServices().listTableDescriptorsByNamespace(this.namespaceName).size();
        }
        catch (FileNotFoundException fnfe) {
            this.setFailure("master-delete-namespace", (Throwable)new NamespaceNotFoundException(this.namespaceName));
            return false;
        }
        if (tableCount > 0) {
            this.setFailure("master-delete-namespace", (Throwable)((Object)new ConstraintException("Only empty namespaces can be removed. Namespace " + this.namespaceName + " has " + tableCount + " tables")));
            return false;
        }
        this.nsDescriptor = DeleteNamespaceProcedure.getTableNamespaceManager(env).get(this.namespaceName);
        return true;
    }

    protected static void deleteFromNSTable(MasterProcedureEnv env, String namespaceName) throws IOException {
        DeleteNamespaceProcedure.getTableNamespaceManager(env).removeFromNSTable(namespaceName);
    }

    private void undoDeleteFromNSTable(MasterProcedureEnv env) {
        try {
            if (this.nsDescriptor != null) {
                CreateNamespaceProcedure.insertIntoNSTable(env, this.nsDescriptor);
            }
        }
        catch (Exception e) {
            LOG.debug("Rollback of deleteFromNSTable throws exception: " + e);
        }
    }

    protected static void removeFromZKNamespaceManager(MasterProcedureEnv env, String namespaceName) throws IOException {
        DeleteNamespaceProcedure.getTableNamespaceManager(env).removeFromZKNamespaceManager(namespaceName);
    }

    private void undoRemoveFromZKNamespaceManager(MasterProcedureEnv env) {
        try {
            if (this.nsDescriptor != null) {
                CreateNamespaceProcedure.updateZKNamespaceManager(env, this.nsDescriptor);
            }
        }
        catch (Exception e) {
            LOG.debug("Rollback of removeFromZKNamespaceManager throws exception: " + e);
        }
    }

    protected static void deleteDirectory(MasterProcedureEnv env, String namespaceName) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        FileSystem fs = mfs.getFileSystem();
        Path p = CommonFSUtils.getNamespaceDir((Path)mfs.getRootDir(), (String)namespaceName);
        try {
            for (FileStatus status : fs.listStatus(p)) {
                if (HConstants.HBASE_NON_TABLE_DIRS.contains(status.getPath().getName())) continue;
                throw new IOException("Namespace directory contains table dir: " + status.getPath());
            }
            if (!fs.delete(CommonFSUtils.getNamespaceDir((Path)mfs.getRootDir(), (String)namespaceName), true)) {
                throw new IOException("Failed to remove namespace: " + namespaceName);
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("deleteDirectory throws exception: " + e);
        }
    }

    private void rollbackDeleteDirectory(MasterProcedureEnv env) throws IOException {
        try {
            CreateNamespaceProcedure.createDirectory(env, this.nsDescriptor);
        }
        catch (Exception e) {
            LOG.debug("Rollback of deleteDirectory throws exception: " + e);
        }
    }

    protected static void removeNamespaceQuota(MasterProcedureEnv env, String namespaceName) throws IOException {
        env.getMasterServices().getMasterQuotaManager().removeNamespaceQuota(namespaceName);
    }

    private void rollbacRemoveNamespaceQuota(MasterProcedureEnv env) throws IOException {
        try {
            CreateNamespaceProcedure.setNamespaceQuota(env, this.nsDescriptor);
        }
        catch (Exception e) {
            LOG.debug("Rollback of removeNamespaceQuota throws exception: " + e);
        }
    }

    private static TableNamespaceManager getTableNamespaceManager(MasterProcedureEnv env) {
        return env.getMasterServices().getClusterSchema().getTableNamespaceManager();
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }
}

