/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.regionserver.CustomTieringMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.DataTiering;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CustomTiering
implements DataTiering {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTiering.class);

    private long getMaxTSFromTimeRange(byte[] hFileTimeRange, String hFileName) {
        try {
            if (hFileTimeRange == null) {
                LOG.debug("Custom cell-based timestamp information not found for file: {}", (Object)hFileName);
                return Long.MAX_VALUE;
            }
            long parsedValue = TimeRangeTracker.parseFrom(hFileTimeRange).getMax();
            LOG.debug("Max TS for file {} is {}", (Object)hFileName, (Object)new Date(parsedValue));
            return parsedValue;
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading the Custom cell-based timestamp metadata of file: {}", (Object)hFileName, (Object)e);
            return Long.MAX_VALUE;
        }
    }

    @Override
    public long getTimestamp(HStoreFile hStoreFile) {
        return this.getMaxTSFromTimeRange(hStoreFile.getMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE), hStoreFile.getPath().getName());
    }

    @Override
    public long getTimestamp(HFileInfo hFileInfo) {
        return this.getMaxTSFromTimeRange(hFileInfo.get(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE), hFileInfo.getHFileContext().getHFileName());
    }
}

