/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.regionserver.CustomTieringMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CustomDateTieredCompactionPolicy
extends DateTieredCompactionPolicy {
    public static final String AGE_LIMIT_MILLIS = "hbase.hstore.compaction.date.tiered.custom.age.limit.millis";
    public static final long DEFAULT_AGE_LIMIT_MILLIS = 315576000000L;
    private static final Logger LOG = LoggerFactory.getLogger(CustomDateTieredCompactionPolicy.class);
    private long cutOffTimestamp;

    public CustomDateTieredCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) throws IOException {
        super(conf, storeConfigInfo);
        this.cutOffTimestamp = EnvironmentEdgeManager.currentTime() - conf.getLong(AGE_LIMIT_MILLIS, 315576000000L);
    }

    @Override
    protected List<Long> getCompactBoundariesForMajor(Collection<HStoreFile> filesToCompact, long now) {
        MutableLong min = new MutableLong(Long.MAX_VALUE);
        MutableLong max = new MutableLong(0L);
        filesToCompact.forEach(f -> {
            byte[] timeRangeBytes = f.getMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE);
            long minCurrent = Long.MAX_VALUE;
            long maxCurrent = 0L;
            if (timeRangeBytes != null) {
                try {
                    TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom(timeRangeBytes);
                    timeRangeTracker.getMin();
                    minCurrent = timeRangeTracker.getMin();
                    maxCurrent = timeRangeTracker.getMax();
                }
                catch (IOException e) {
                    LOG.warn("Got TIERING_CELL_TIME_RANGE info from file, but failed to parse it:", (Throwable)e);
                }
            }
            if (minCurrent < min.getValue()) {
                min.setValue(minCurrent);
            }
            if (maxCurrent > max.getValue()) {
                max.setValue(maxCurrent);
            }
        });
        ArrayList<Long> boundaries = new ArrayList<Long>();
        boundaries.add(Long.MIN_VALUE);
        if (min.getValue() < this.cutOffTimestamp) {
            boundaries.add(min.getValue());
            if (max.getValue() > this.cutOffTimestamp) {
                boundaries.add(this.cutOffTimestamp);
            }
        }
        return boundaries;
    }

    @Override
    public CompactionRequestImpl selectMinorCompaction(ArrayList<HStoreFile> candidateSelection, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        ArrayList<HStoreFile> filteredByPolicy = this.compactionPolicyPerWindow.applyCompactionPolicy(candidateSelection, mayUseOffPeak, mayBeStuck);
        return this.selectMajorCompaction(filteredByPolicy);
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<HStoreFile> filesToCompact) throws IOException {
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = EnvironmentEdgeManager.currentTime();
        if (this.isMajorCompactionTime(filesToCompact, now, lowTimestamp)) {
            long cfTTL = this.storeConfigInfo.getStoreFileTtl();
            int countLower = 0;
            int countHigher = 0;
            HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
            for (HStoreFile f : filesToCompact) {
                if (this.checkForTtl(cfTTL, f)) {
                    return true;
                }
                if (this.isMajorOrBulkloadResult(f, now - lowTimestamp)) {
                    return true;
                }
                byte[] timeRangeBytes = f.getMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE);
                TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom(timeRangeBytes);
                if (timeRangeTracker.getMin() < this.cutOffTimestamp) {
                    if (timeRangeTracker.getMax() > this.cutOffTimestamp) {
                        return true;
                    }
                    ++countLower;
                } else {
                    ++countHigher;
                }
                hdfsBlocksDistribution.add(f.getHDFSBlockDistribution());
            }
            if (countLower > 1 || countHigher > 1) {
                return true;
            }
            return this.checkBlockLocality(hdfsBlocksDistribution);
        }
        return false;
    }
}

