/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import java.io.IOException;
import java.io.InputStream;

final class SnappyInternalUtils {
    private SnappyInternalUtils() {
    }

    static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static void checkPositionIndexes(int start2, int end, int size) {
        if (start2 < 0 || end < start2 || end > size) {
            throw new IndexOutOfBoundsException(SnappyInternalUtils.badPositionIndexes(start2, end, size));
        }
    }

    static String badPositionIndexes(int start2, int end, int size) {
        if (start2 < 0 || start2 > size) {
            return SnappyInternalUtils.badPositionIndex(start2, size, "start index");
        }
        if (end < 0 || end > size) {
            return SnappyInternalUtils.badPositionIndex(end, size, "end index");
        }
        return String.format("end index (%s) must not be less than start index (%s)", end, start2);
    }

    static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return String.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    static int readBytes(InputStream source, byte[] dest, int offset, int length) throws IOException {
        int lastRead;
        SnappyInternalUtils.checkNotNull(source, "source is null", new Object[0]);
        SnappyInternalUtils.checkNotNull(dest, "dest is null", new Object[0]);
        int totalRead = lastRead = source.read(dest, offset, length);
        if (lastRead < length) {
            while (totalRead < length && lastRead != -1) {
                lastRead = source.read(dest, offset + totalRead, length - totalRead);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        return totalRead;
    }

    static int skip(InputStream source, int skip) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        int toSkip = skip - (int)source.skip(skip);
        boolean more = true;
        while (toSkip > 0 && more) {
            int read = source.read();
            if (read == -1) {
                more = false;
                continue;
            }
            --toSkip;
            toSkip = (int)((long)toSkip - source.skip(toSkip));
        }
        int skipped = skip - toSkip;
        return skipped;
    }
}

