/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter;

import io.prometheus.client.exporter.DefaultHttpConnectionFactory;
import io.prometheus.client.exporter.HttpConnectionFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import javax.xml.bind.DatatypeConverter;

public class BasicAuthHttpConnectionFactory
implements HttpConnectionFactory {
    private final HttpConnectionFactory originConnectionFactory;
    private final String basicAuthHeader;

    public BasicAuthHttpConnectionFactory(HttpConnectionFactory connectionFactory, String user, String password) {
        this.originConnectionFactory = connectionFactory;
        this.basicAuthHeader = this.encode(user, password);
    }

    public BasicAuthHttpConnectionFactory(String user, String password) {
        this(new DefaultHttpConnectionFactory(), user, password);
    }

    @Override
    public HttpURLConnection create(String url2) throws IOException {
        HttpURLConnection connection = this.originConnectionFactory.create(url2);
        connection.setRequestProperty("Authorization", this.basicAuthHeader);
        return connection;
    }

    private String encode(String user, String password) {
        try {
            byte[] credentialsBytes = (user + ":" + password).getBytes("UTF-8");
            String encoded = DatatypeConverter.printBase64Binary((byte[])credentialsBytes);
            return String.format("Basic %s", encoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

