/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.leader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.AfterConnectionEstablished;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.recipes.locks.LockInternals;
import org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderLatch
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String latchPath;
    private final String id;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean hasLeadership = new AtomicBoolean(false);
    private final AtomicReference<String> ourPath = new AtomicReference();
    private final ListenerContainer<LeaderLatchListener> listeners = new ListenerContainer();
    private final CloseMode closeMode;
    private final AtomicReference<Future<?>> startTask = new AtomicReference();
    private final ConnectionStateListener listener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            LeaderLatch.this.handleStateChange(newState);
        }
    };
    private static final String LOCK_NAME = "latch-";
    private static final LockInternalsSorter sorter = new LockInternalsSorter(){

        @Override
        public String fixForSorting(String str, String lockName) {
            return StandardLockInternalsDriver.standardFixForSorting(str, lockName);
        }
    };
    @VisibleForTesting
    volatile CountDownLatch debugResetWaitLatch = null;

    public LeaderLatch(CuratorFramework client, String latchPath) {
        this(client, latchPath, "", CloseMode.SILENT);
    }

    public LeaderLatch(CuratorFramework client, String latchPath, String id) {
        this(client, latchPath, id, CloseMode.SILENT);
    }

    public LeaderLatch(CuratorFramework client, String latchPath, String id, CloseMode closeMode) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.latchPath = PathUtils.validatePath(latchPath);
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.closeMode = (CloseMode)((Object)Preconditions.checkNotNull((Object)((Object)closeMode), (Object)"closeMode cannot be null"));
    }

    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        this.startTask.set(AfterConnectionEstablished.execute(this.client, new Runnable(){

            @Override
            public void run() {
                try {
                    LeaderLatch.this.internalStart();
                }
                finally {
                    LeaderLatch.this.startTask.set(null);
                }
            }
        }));
    }

    @Override
    public void close() throws IOException {
        this.close(this.closeMode);
    }

    public synchronized void close(CloseMode closeMode) throws IOException {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Already closed or has not been started");
        Preconditions.checkNotNull((Object)((Object)closeMode), (Object)"closeMode cannot be null");
        this.cancelStartTask();
        try {
            this.setNode(null);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.client.getConnectionStateListenable().removeListener(this.listener);
            switch (closeMode) {
                case NOTIFY_LEADER: {
                    this.setLeadership(false);
                    this.listeners.clear();
                    break;
                }
                default: {
                    this.listeners.clear();
                    this.setLeadership(false);
                }
            }
        }
    }

    @VisibleForTesting
    protected boolean cancelStartTask() {
        Future localStartTask = this.startTask.getAndSet(null);
        if (localStartTask != null) {
            localStartTask.cancel(true);
            return true;
        }
        return false;
    }

    public void addListener(LeaderLatchListener listener) {
        this.listeners.addListener(listener);
    }

    public void addListener(LeaderLatchListener listener, Executor executor) {
        this.listeners.addListener(listener, executor);
    }

    public void removeListener(LeaderLatchListener listener) {
        this.listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException, EOFException {
        LeaderLatch leaderLatch = this;
        synchronized (leaderLatch) {
            while (this.state.get() == State.STARTED && !this.hasLeadership.get()) {
                this.wait();
            }
        }
        if (this.state.get() != State.STARTED) {
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        LeaderLatch leaderLatch = this;
        synchronized (leaderLatch) {
            long elapsed;
            for (long waitNanos = TimeUnit.NANOSECONDS.convert(timeout, unit); waitNanos > 0L && this.state.get() == State.STARTED && !this.hasLeadership.get(); waitNanos -= elapsed) {
                long startNanos = System.nanoTime();
                TimeUnit.NANOSECONDS.timedWait(this, waitNanos);
                elapsed = System.nanoTime() - startNanos;
            }
        }
        return this.hasLeadership();
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state.get();
    }

    public Collection<Participant> getParticipants() throws Exception {
        Collection<String> participantNodes = LockInternals.getParticipantNodes(this.client, this.latchPath, LOCK_NAME, sorter);
        return LeaderSelector.getParticipants(this.client, participantNodes);
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = LockInternals.getParticipantNodes(this.client, this.latchPath, LOCK_NAME, sorter);
        return LeaderSelector.getLeader(this.client, participantNodes);
    }

    public boolean hasLeadership() {
        return this.state.get() == State.STARTED && this.hasLeadership.get();
    }

    @VisibleForTesting
    void reset() throws Exception {
        this.setLeadership(false);
        this.setNode(null);
        BackgroundCallback callback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (LeaderLatch.this.debugResetWaitLatch != null) {
                    LeaderLatch.this.debugResetWaitLatch.await();
                    LeaderLatch.this.debugResetWaitLatch = null;
                }
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    LeaderLatch.this.setNode(event.getName());
                    if (LeaderLatch.this.state.get() == State.CLOSED) {
                        LeaderLatch.this.setNode(null);
                    } else {
                        LeaderLatch.this.getChildren();
                    }
                } else {
                    LeaderLatch.this.log.error("getChildren() failed. rc = " + event.getResultCode());
                }
            }
        };
        ((PathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).inBackground(callback)).forPath(ZKPaths.makePath(this.latchPath, LOCK_NAME), LeaderSelector.getIdBytes(this.id));
    }

    private synchronized void internalStart() {
        if (this.state.get() == State.STARTED) {
            this.client.getConnectionStateListenable().addListener(this.listener);
            try {
                this.reset();
            }
            catch (Exception e) {
                this.log.error("An error occurred checking resetting leadership.", (Throwable)e);
            }
        }
    }

    private void checkLeadership(List<String> children) throws Exception {
        int ourIndex;
        final String localOurPath = this.ourPath.get();
        List<String> sortedChildren = LockInternals.getSortedChildren(LOCK_NAME, sorter, children);
        int n = ourIndex = localOurPath != null ? sortedChildren.indexOf(ZKPaths.getNodeFromPath(localOurPath)) : -1;
        if (ourIndex < 0) {
            this.log.error("Can't find our node. Resetting. Index: " + ourIndex);
            this.reset();
        } else if (ourIndex == 0) {
            this.setLeadership(true);
        } else {
            String watchPath = sortedChildren.get(ourIndex - 1);
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    if (LeaderLatch.this.state.get() == State.STARTED && event.getType() == Watcher.Event.EventType.NodeDeleted && localOurPath != null) {
                        try {
                            LeaderLatch.this.getChildren();
                        }
                        catch (Exception ex) {
                            LeaderLatch.this.log.error("An error occurred checking the leadership.", (Throwable)ex);
                        }
                    }
                }
            };
            BackgroundCallback callback = new BackgroundCallback(){

                @Override
                public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                    if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                        LeaderLatch.this.reset();
                    }
                }
            };
            ((Pathable)((BackgroundPathable)this.client.getData().usingWatcher(watcher)).inBackground(callback)).forPath(ZKPaths.makePath(this.latchPath, watchPath));
        }
    }

    private void getChildren() throws Exception {
        BackgroundCallback callback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    LeaderLatch.this.checkLeadership(event.getChildren());
                }
            }
        };
        ((Pathable)this.client.getChildren().inBackground(callback)).forPath(ZKPaths.makePath(this.latchPath, null));
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            default: {
                break;
            }
            case RECONNECTED: {
                try {
                    this.reset();
                }
                catch (Exception e) {
                    this.log.error("Could not reset leader latch", (Throwable)e);
                    this.setLeadership(false);
                }
                break;
            }
            case SUSPENDED: 
            case LOST: {
                this.setLeadership(false);
            }
        }
    }

    private synchronized void setLeadership(boolean newValue) {
        boolean oldValue = this.hasLeadership.getAndSet(newValue);
        if (oldValue && !newValue) {
            this.listeners.forEach(new Function<LeaderLatchListener, Void>(){

                public Void apply(LeaderLatchListener listener) {
                    listener.notLeader();
                    return null;
                }
            });
        } else if (!oldValue && newValue) {
            this.listeners.forEach(new Function<LeaderLatchListener, Void>(){

                public Void apply(LeaderLatchListener input) {
                    input.isLeader();
                    return null;
                }
            });
        }
        this.notifyAll();
    }

    private void setNode(String newValue) throws Exception {
        String oldPath = this.ourPath.getAndSet(newValue);
        if (oldPath != null) {
            ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(oldPath);
        }
    }

    public static enum CloseMode {
        SILENT,
        NOTIFY_LEADER;

    }

    public static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

