/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.BucketIndexSupport$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.SparkBaseIndexSupport;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.util.collection.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u000e\u001d\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0004G\u0001\t\u0007I\u0011B$\t\r9\u0003\u0001\u0015!\u0003I\u0011\u001dy\u0005A1A\u0005\nACaa\u0016\u0001!\u0002\u0013\t\u0006\u0002\u0003-\u0001\u0011\u000b\u0007I\u0011B-\t\u000b\u0001\u0004A\u0011I1\t\u000b=\u0004A\u0011\u00019\t\u000bU\u0004A\u0011\t<\t\u000bi\u0004A\u0011I>\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003D\u0011\"a3\u0001\u0005\u0004%I!!4\t\u0011\u0005}\u0007\u0001)A\u0005\u0003\u001fDa!!9\u0001\t\u0003\u0001vaBAr9!\u0005\u0011Q\u001d\u0004\u00077qA\t!a:\t\r\u0001;B\u0011AAx\u0011%\t\tp\u0006b\u0001\n\u0003\t\u0019\u0010\u0003\u0005\u0002\u0000^\u0001\u000b\u0011BA{\u0005I\u0011UoY6fi&sG-\u001a=TkB\u0004xN\u001d;\u000b\u0005uq\u0012\u0001\u00025vI&T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011C\u0001\u0001%!\t)c%D\u0001\u001d\u0013\t9CDA\u000bTa\u0006\u00148NQ1tK&sG-\u001a=TkB\u0004xN\u001d;\u0002\u000bM\u0004\u0018M]6\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013aA:rY*\u0011\u0001FH\u0005\u0003_-\u0012Ab\u00159be.\u001cVm]:j_:\fa\"\\3uC\u0012\fG/Y\"p]\u001aLw\r\u0005\u00023o5\t1G\u0003\u00025k\u000511m\u001c8gS\u001eT!A\u000e\u000f\u0002\r\r|W.\\8o\u0013\tA4G\u0001\u000bI_>$\u0017.Z'fi\u0006$\u0017\r^1D_:4\u0017nZ\u0001\u000b[\u0016$\u0018m\u00117jK:$\bCA\u001e?\u001b\u0005a$BA\u001f6\u0003\u0015!\u0018M\u00197f\u0013\tyDHA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0011\u00115\tR#\u0011\u0005\u0015\u0002\u0001\"\u0002\u0015\u0005\u0001\u0004I\u0003\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B\u001d\u0005\u0001\u0004Q\u0014a\u00017pOV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002LA\u0005)1\u000f\u001c45U&\u0011QJ\u0013\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\rW\u0016Lx)\u001a8fe\u0006$xN]\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A\u000bH\u0001\u0007W\u0016Lx-\u001a8\n\u0005Y\u001b&\u0001D&fs\u001e+g.\u001a:bi>\u0014\u0018!D6fs\u001e+g.\u001a:bi>\u0014\b%\u0001\u0006bmJ|7k\u00195f[\u0006,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;z\tA!\u0019<s_&\u0011q\f\u0018\u0002\u0007'\u000eDW-\\1\u0002\u0019\u001d,G/\u00138eKbt\u0015-\\3\u0016\u0003\t\u0004\"a\u00197\u000f\u0005\u0011T\u0007CA3i\u001b\u00051'BA4#\u0003\u0019a$o\\8u})\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\u00061\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0007.\u0001\tjg&sG-\u001a=Bm\u0006LG.\u00192mKV\t\u0011\u000f\u0005\u0002sg6\t\u0001.\u0003\u0002uQ\n9!i\\8mK\u0006t\u0017\u0001E5om\u0006d\u0017\u000eZ1uK\u000e\u000b7\r[3t)\u00059\bC\u0001:y\u0013\tI\bN\u0001\u0003V]&$\u0018!G2p[B,H/Z\"b]\u0012LG-\u0019;f\r&dWMT1nKN$2\u0002`A\u0003\u0003\u001f\t)$a\u000f\u0002fA\u0019!/`@\n\u0005yD'AB(qi&|g\u000e\u0005\u0003d\u0003\u0003\u0011\u0017bAA\u0002]\n\u00191+\u001a;\t\u000f\u0005\u001dQ\u00021\u0001\u0002\n\u0005Ia-\u001b7f\u0013:$W\r\u001f\t\u0004K\u0005-\u0011bAA\u00079\ty\u0001j\\8eS\u00164\u0015\u000e\\3J]\u0012,\u0007\u0010C\u0004\u0002\u00125\u0001\r!a\u0005\u0002\u0019E,XM]=GS2$XM]:\u0011\r\u0005U\u0011qDA\u0013\u001d\u0011\t9\"a\u0007\u000f\u0007\u0015\fI\"C\u0001j\u0013\r\ti\u0002[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t#a\t\u0003\u0007M+\u0017OC\u0002\u0002\u001e!\u0004B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0006fqB\u0014Xm]:j_:\u001c(bAA\u0018W\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u00024\u0005%\"AC#yaJ,7o]5p]\"9\u0011qG\u0007A\u0002\u0005e\u0012AF9vKJL(+\u001a4fe\u0016t7-\u001a3D_2,XN\\:\u0011\u000b\u0005U\u0011q\u00042\t\u000f\u0005uR\u00021\u0001\u0002@\u0005i\u0002O];oK\u0012\u0004\u0016M\u001d;ji&|gn]!oI\u001aKG.Z*mS\u000e,7\u000f\u0005\u0004\u0002\u0016\u0005}\u0011\u0011\t\t\be\u0006\r\u0013qIA,\u0013\r\t)\u0005\u001b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\tIl\u0018\u0011\n\t\u0005\u0003\u0017\n\tFD\u0002&\u0003\u001bJ1!a\u0014\u001d\u0003a\u0011\u0015m]3I_>$\u0017.\u001a+bE2,g)\u001b7f\u0013:$W\r_\u0005\u0005\u0003'\n)FA\u0007QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u0006\u0004\u0003\u001fb\u0002CBA\u000b\u0003?\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty&N\u0001\u0006[>$W\r\\\u0005\u0005\u0003G\niFA\u0005GS2,7\u000b\\5dK\"1\u0011qM\u0007A\u0002E\f\u0011d\u001d5pk2$\u0007+^:i\t><hNR5mKN4\u0015\u000e\u001c;fe\u0006\tr-\u001a;DC:$\u0017\u000eZ1uK\u001aKG.Z:\u0015\u000b}\fi'!\u001d\t\r\u0005=d\u00021\u0001\u0000\u00031\tG\u000e\u001c$jY\u0016\u001ch*Y7f\u0011\u001d\t\u0019H\u0004a\u0001\u0003k\n\u0011BY;dW\u0016$\u0018\nZ:\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0007\u0005}T&\u0001\u0003vi&d\u0017\u0002BAB\u0003s\u0012aAQ5u'\u0016$\u0018\u0001\t4jYR,'/U;fe&,7oV5uQ\n+8m[3u\u0011\u0006\u001c\bNR5fY\u0012$B!!#\u0002\fB!!/`A;\u0011\u001d\t\tb\u0004a\u0001\u0003'\tadZ3u\u0005V\u001c7.\u001a;t\u0005flU\u000f\u001c;ja2,\u0007*Y:i\r&,G\u000eZ:\u0015\u0011\u0005U\u0014\u0011SAJ\u0003/Cq!!\u0005\u0011\u0001\u0004\t\u0019\u0002\u0003\u0004\u0002\u0016B\u0001\ra`\u0001\u0016S:$W\r\u001f\"vG.,G\u000fS1tQ\u001aKW\r\u001c3t\u0011\u001d\tI\n\u0005a\u0001\u00037\u000b!B\\;n\u0005V\u001c7.\u001a;t!\r\u0011\u0018QT\u0005\u0004\u0003?C'aA%oi\u0006!r-\u001a;FcV\fG.\u001b;z\r&,G\u000e\u001a)bSJ$b!!*\u00028\u0006m\u0006cBAT\u0003[\u0013\u0017\u0011W\u0007\u0003\u0003SSA!a\u001f\u0002,*\u0019\u0011qP\u001b\n\t\u0005=\u0016\u0011\u0016\u0002\u0005!\u0006L'\u000fE\u0002s\u0003gK1!!.i\u0005\r\te.\u001f\u0005\b\u0003s\u000b\u0002\u0019AA\u0013\u0003\u0011)\u0007\u0010\u001d:\t\r\u0005u\u0016\u00031\u0001\u0000\u00039)\u0017/^1mSRLh)[3mIN\fAdZ3u\u0005V\u001c7.\u001a;t\u0005f\u001c\u0016N\\4mK\"\u000b7\u000f\u001b$jK2$7\u000f\u0006\u0005\u0002v\u0005\r\u0017QYAe\u0011\u001d\tIL\u0005a\u0001\u0003KAa!a2\u0013\u0001\u0004\u0011\u0017\u0001\u00052vG.,GoQ8mk6tg*Y7f\u0011\u001d\tIJ\u0005a\u0001\u00037\u000b\u0001$\u001b8eKb\u0014UoY6fi\"\u000b7\u000f\u001b$jK2$7o\u00149u+\t\ty\r\u0005\u0003s{\u0006E\u0007#BAj\u00037\u0014WBAAk\u0015\u0011\ty(a6\u000b\u0005\u0005e\u0017\u0001\u00026bm\u0006LA!!8\u0002V\n!A*[:u\u0003eIg\u000eZ3y\u0005V\u001c7.\u001a;ICNDg)[3mIN|\u0005\u000f\u001e\u0011\u0002\u001f\u001d,GoS3z\u000f\u0016tWM]1u_J\f!CQ;dW\u0016$\u0018J\u001c3fqN+\b\u000f]8siB\u0011QeF\n\u0004/\u0005%\bc\u0001:\u0002l&\u0019\u0011Q\u001e5\u0003\r\u0005s\u0017PU3g)\t\t)/\u0001\u0006J\u001d\u0012+\u0005l\u0018(B\u001b\u0016+\"!!>\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sTA!a?\u0002X\u0006!A.\u00198h\u0013\ri\u0017\u0011`\u0001\f\u0013:#U\tW0O\u00036+\u0005\u0005")
public class BucketIndexSupport
extends SparkBaseIndexSupport {
    private Schema avroSchema;
    private final HoodieMetadataConfig metadataConfig;
    private HoodieTableMetaClient metaClient;
    private final Logger log;
    private final KeyGenerator keyGenerator;
    private final Option<List<String>> indexBucketHashFieldsOpt;
    private volatile boolean bitmap$0;

    public static String INDEX_NAME() {
        return BucketIndexSupport$.MODULE$.INDEX_NAME();
    }

    private Logger log() {
        return this.log;
    }

    private KeyGenerator keyGenerator() {
        return this.keyGenerator;
    }

    private Schema avroSchema$lzycompute() {
        BucketIndexSupport bucketIndexSupport = this;
        synchronized (bucketIndexSupport) {
            if (!this.bitmap$0) {
                this.avroSchema = new TableSchemaResolver(this.metaClient).getTableAvroSchema(false);
                this.bitmap$0 = true;
            }
        }
        this.metaClient = null;
        return this.avroSchema;
    }

    private Schema avroSchema() {
        if (!this.bitmap$0) {
            return this.avroSchema$lzycompute();
        }
        return this.avroSchema;
    }

    @Override
    public String getIndexName() {
        return BucketIndexSupport$.MODULE$.INDEX_NAME();
    }

    @Override
    public boolean isIndexAvailable() {
        return this.indexBucketHashFieldsOpt().isDefined() && this.metadataConfig.getStringOrDefault(HoodieIndexConfig.INDEX_TYPE, "").equalsIgnoreCase(HoodieIndex.IndexType.BUCKET.name()) && this.metadataConfig.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE).equalsIgnoreCase(HoodieIndex.BucketIndexEngineType.SIMPLE.name()) && this.metadataConfig.getBooleanOrDefault(HoodieIndexConfig.BUCKET_QUERY_INDEX);
    }

    @Override
    public void invalidateCaches() {
    }

    @Override
    public Option<scala.collection.immutable.Set<String>> computeCandidateFileNames(HoodieFileIndex fileIndex, Seq<Expression> queryFilters, Seq<String> queryReferencedColumns, Seq<Tuple2<Option<BaseHoodieTableFileIndex.PartitionPath>, Seq<FileSlice>>> prunedPartitionsAndFileSlices, boolean shouldPushDownFilesFilter) {
        Option<BitSet> bucketIdsBitMapByFilter = this.filterQueriesWithBucketHashField(queryFilters);
        if (bucketIdsBitMapByFilter.isDefined() && ((BitSet)bucketIdsBitMapByFilter.get()).cardinality() > 0) {
            scala.collection.immutable.Set allFilesName = (scala.collection.immutable.Set)this.getPrunedPartitionsAndFileNames(fileIndex, prunedPartitionsAndFileSlices)._2();
            return Option$.MODULE$.apply(this.getCandidateFiles((scala.collection.immutable.Set<String>)allFilesName, (BitSet)bucketIdsBitMapByFilter.get()));
        }
        return Option$.MODULE$.empty();
    }

    public scala.collection.immutable.Set<String> getCandidateFiles(scala.collection.immutable.Set<String> allFilesName, BitSet bucketIds) {
        Set candidateFiles = Set$.MODULE$.empty();
        allFilesName.foreach((Function1 & Serializable & scala.Serializable)fileName -> {
            String fileId = FSUtils.getFileIdFromFileName(fileName);
            int fileBucketId = BucketIdentifier.bucketIdFromFileId(fileId);
            if (bucketIds.get(fileBucketId)) {
                return candidateFiles.$plus$eq(fileName);
            }
            return BoxedUnit.UNIT;
        });
        return candidateFiles.toSet();
    }

    public Option<BitSet> filterQueriesWithBucketHashField(Seq<Expression> queryFilters) {
        Integer bucketNumber = this.metadataConfig.getIntOrDefault(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS);
        if (this.indexBucketHashFieldsOpt().isEmpty() || queryFilters.isEmpty()) {
            return None$.MODULE$;
        }
        BitSet matchedBuckets = null;
        matchedBuckets = ((List)this.indexBucketHashFieldsOpt().get()).size() == 1 ? this.getBucketsBySingleHashFields((Expression)queryFilters.reduce((Function2)And$.MODULE$), (String)((List)this.indexBucketHashFieldsOpt().get()).get(0), Predef$.MODULE$.Integer2int(bucketNumber)) : this.getBucketsByMultipleHashFields(queryFilters, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.indexBucketHashFieldsOpt().get()).asScala()).toSet(), Predef$.MODULE$.Integer2int(bucketNumber));
        int numBucketsSelected = matchedBuckets.cardinality();
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)numBucketsSelected), (Object)bucketNumber)) {
            this.log().info("The query predicates do not include equality expressions for all the hashing fields, fall back to the other indices");
            return None$.MODULE$;
        }
        return new Some((Object)matchedBuckets);
    }

    private BitSet getBucketsByMultipleHashFields(Seq<Expression> queryFilters, scala.collection.immutable.Set<String> indexBucketHashFields, int numBuckets) {
        Seq hashValuePairs = (Seq)((TraversableLike)queryFilters.map((Function1 & Serializable & scala.Serializable)expr -> this.getEqualityFieldPair((Expression)expr, indexBucketHashFields), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)BucketIndexSupport.$anonfun$getBucketsByMultipleHashFields$2(pair)));
        BitSet matchedBuckets = new BitSet(numBuckets);
        if (hashValuePairs.size() != indexBucketHashFields.size()) {
            matchedBuckets.setUntil(numBuckets);
        } else {
            GenericData.Record record = new GenericData.Record(this.avroSchema());
            hashValuePairs.foreach((Function1 & Serializable & scala.Serializable)p -> {
                record.put((String)p.getKey(), p.getValue());
                return BoxedUnit.UNIT;
            });
            HoodieKey hoodieKey = this.keyGenerator().getKey((GenericRecord)record);
            matchedBuckets.set(BucketIdentifier.getBucketId(hoodieKey, (List)this.indexBucketHashFieldsOpt().get(), numBuckets));
        }
        return matchedBuckets;
    }

    private Pair<String, Object> getEqualityFieldPair(Expression expr, scala.collection.immutable.Set<String> equalityFields) {
        BinaryComparison binaryComparison;
        Option option;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    if (equalityFields.contains((Object)attribute.name())) {
                        return Pair.of(attribute.name(), v);
                    }
                }
            }
        }
        return null;
    }

    private BitSet getBucketsBySingleHashFields(Expression expr, String bucketColumnName, int numBuckets) {
        Expression a;
        IsNull isNull;
        Expression a2;
        BinaryComparison binaryComparison;
        Option option;
        boolean bl = false;
        IsNaN isNaN = null;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a3 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return this.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a4 = in.value();
            Seq list = in.list();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                if (list.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BucketIndexSupport.$anonfun$getBucketsBySingleHashFields$3(x$1)))) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        return this.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a5 = inSet.child();
            scala.collection.immutable.Set hset = inSet.hset();
            if (a5 instanceof Attribute) {
                Attribute attribute = (Attribute)a5;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    return this.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a2;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (!(string != null ? !string.equals(string5) : string5 != null)) {
                return this.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof IsNaN) {
            bl = true;
            isNaN = (IsNaN)expression;
            Expression a6 = isNaN.child();
            if (a6 instanceof Attribute) {
                Attribute attribute = (Attribute)a6;
                String string = attribute.name();
                String string6 = bucketColumnName;
                if (!(string != null ? !string.equals(string6) : string6 != null)) {
                    DataType dataType = attribute.dataType();
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(floatType$) : floatType$ != null)) {
                        return this.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToFloat((float)Float.NaN), numBuckets);
                    }
                }
            }
        }
        if (bl && (a = isNaN.child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string7 = bucketColumnName;
            if (!(string != null ? !string.equals(string7) : string7 != null)) {
                DataType dataType = attribute.dataType();
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null)) {
                    return this.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToDouble((double)Double.NaN), numBuckets);
                }
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getBucketsBySingleHashFields(left, bucketColumnName, numBuckets).$amp(this.getBucketsBySingleHashFields(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getBucketsBySingleHashFields(left, bucketColumnName, numBuckets).$bar(this.getBucketsBySingleHashFields(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<List<String>> indexBucketHashFieldsOpt() {
        return this.indexBucketHashFieldsOpt;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator();
    }

    public static final /* synthetic */ boolean $anonfun$getBucketsByMultipleHashFields$2(Pair pair) {
        return pair != null;
    }

    private final int getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        GenericData.Record record = new GenericData.Record(this.avroSchema());
        record.put(attr.name(), v);
        HoodieKey hoodieKey = this.keyGenerator().getKey((GenericRecord)record);
        return BucketIdentifier.getBucketId(hoodieKey, (List)this.indexBucketHashFieldsOpt().get(), numBuckets$1);
    }

    private final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)this.getBucketNumber$1(attr, v, numBuckets$1)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketNum -> matchedBuckets.set(bucketNum));
        return matchedBuckets;
    }

    private final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(this.getBucketNumber$1(attr, v, numBuckets$1));
        return matchedBuckets;
    }

    public static final /* synthetic */ boolean $anonfun$getBucketsBySingleHashFields$3(Expression x$1) {
        return x$1 instanceof Literal;
    }

    public BucketIndexSupport(SparkSession spark, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient) {
        this.metadataConfig = metadataConfig;
        this.metaClient = metaClient;
        super(spark, metadataConfig, metaClient);
        this.log = LoggerFactory.getLogger(this.getClass());
        TypedProperties props = new TypedProperties(metadataConfig.getProps());
        TypedProperties.putAll(props, metaClient.getTableConfig().getProps());
        this.keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
        String bucketHashFields = metadataConfig.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD, metadataConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS));
        this.indexBucketHashFieldsOpt = bucketHashFields == null || bucketHashFields.isEmpty() ? Option$.MODULE$.apply(null) : Option$.MODULE$.apply(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])bucketHashFields.split(","))).asJava());
    }
}

